/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.io.ClassLoaderObjectInputStream;

public class SerializedValueSnapshot
implements ValueSnapshot {
    private final HashCode implementationHash;
    private final byte[] serializedValue;

    public SerializedValueSnapshot(HashCode implementationHash, byte[] serializedValue) {
        this.implementationHash = implementationHash;
        this.serializedValue = serializedValue;
    }

    public HashCode getImplementationHash() {
        return this.implementationHash;
    }

    public byte[] getValue() {
        return this.serializedValue;
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot snapshot = snapshotter.snapshot(value);
        if (snapshot instanceof SerializedValueSnapshot) {
            Object oldValue;
            SerializedValueSnapshot newSnapshot = (SerializedValueSnapshot)snapshot;
            if (!Objects.equal((Object)this.implementationHash, (Object)newSnapshot.implementationHash)) {
                return newSnapshot;
            }
            if (Arrays.equals(this.serializedValue, newSnapshot.serializedValue)) {
                return this;
            }
            try {
                oldValue = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(this.serializedValue), value.getClass().getClassLoader()).readObject();
            }
            catch (Exception e) {
                throw new UncheckedIOException((Throwable)e);
            }
            if (oldValue.equals(value)) {
                return this;
            }
        }
        return snapshot;
    }

    public void appendToHasher(BuildCacheHasher hasher) {
        if (this.implementationHash == null) {
            hasher.putNull();
        } else {
            hasher.putHash(this.implementationHash);
        }
        hasher.putBytes(this.serializedValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SerializedValueSnapshot other = (SerializedValueSnapshot)obj;
        return Objects.equal((Object)this.implementationHash, (Object)other.implementationHash) && Arrays.equals(this.serializedValue, other.serializedValue);
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedValue);
    }
}

