/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.IgnoredPathFileSnapshot;
import org.gradle.api.internal.changedetection.state.IndexedNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.NonNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.nativeintegration.filesystem.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TaskFilePropertySnapshotNormalizationStrategy implements SnapshotNormalizationStrategy
{
    ABSOLUTE{

        public boolean isPathAbsolute() {
            return true;
        }

        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            return new NonNormalizedFileSnapshot(fileSnapshot.getPath(), fileSnapshot.getContent());
        }
    }
    ,
    RELATIVE{

        public boolean isPathAbsolute() {
            return false;
        }

        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            if (fileSnapshot.isRoot() && fileSnapshot.getType() == FileType.Directory) {
                return new IgnoredPathFileSnapshot(fileSnapshot.getContent());
            }
            return 2.getRelativeSnapshot(fileSnapshot, fileSnapshot.getContent(), stringInterner);
        }
    }
    ,
    NAME_ONLY{

        public boolean isPathAbsolute() {
            return false;
        }

        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            if (fileSnapshot.isRoot() && fileSnapshot.getType() == FileType.Directory) {
                return new IgnoredPathFileSnapshot(fileSnapshot.getContent());
            }
            return 3.getRelativeSnapshot(fileSnapshot, fileSnapshot.getName(), fileSnapshot.getContent(), stringInterner);
        }
    }
    ,
    NONE{

        public boolean isPathAbsolute() {
            return false;
        }

        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            if (fileSnapshot.getType() == FileType.Directory) {
                return null;
            }
            return new IgnoredPathFileSnapshot(fileSnapshot.getContent());
        }
    };


    public static TaskFilePropertySnapshotNormalizationStrategy valueOf(PathSensitivity pathSensitivity) {
        switch (pathSensitivity) {
            case ABSOLUTE: {
                return ABSOLUTE;
            }
            case RELATIVE: {
                return RELATIVE;
            }
            case NAME_ONLY: {
                return NAME_ONLY;
            }
            case NONE: {
                return NONE;
            }
        }
        throw new IllegalArgumentException("Unknown path usage: " + (Object)((Object)pathSensitivity));
    }

    public static NormalizedFileSnapshot getRelativeSnapshot(FileSnapshot fileSnapshot, FileContentSnapshot snapshot, StringInterner stringInterner) {
        String[] segments = fileSnapshot.getRelativePath().getSegments();
        StringBuilder builder = new StringBuilder();
        int len = segments.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                builder.append('/');
            }
            builder.append(segments[i]);
        }
        return TaskFilePropertySnapshotNormalizationStrategy.getRelativeSnapshot(fileSnapshot, builder.toString(), snapshot, stringInterner);
    }

    public static NormalizedFileSnapshot getRelativeSnapshot(FileSnapshot fileSnapshot, String normalizedPath, FileContentSnapshot snapshot, StringInterner stringInterner) {
        String absolutePath = fileSnapshot.getPath();
        if (absolutePath.endsWith(normalizedPath)) {
            return new IndexedNormalizedFileSnapshot(absolutePath, absolutePath.length() - normalizedPath.length(), snapshot);
        }
        return new DefaultNormalizedFileSnapshot(stringInterner.intern(normalizedPath), snapshot);
    }
}

