/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.GradleException;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.AbstractRoleAwareBuildCacheServiceDecorator;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortCircuitingErrorHandlerBuildCacheServiceDecorator
extends AbstractRoleAwareBuildCacheServiceDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortCircuitingErrorHandlerBuildCacheServiceDecorator.class);
    private boolean closed;
    private final int maxErrorCount;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final AtomicInteger remainingErrorCount;
    private final LoggingConfiguration loggingConfiguration;
    private String disableMessage;

    public ShortCircuitingErrorHandlerBuildCacheServiceDecorator(int maxErrorCount, LoggingConfiguration loggingConfiguration, RoleAwareBuildCacheService delegate) {
        super(delegate);
        this.maxErrorCount = maxErrorCount;
        this.remainingErrorCount = new AtomicInteger(maxErrorCount);
        this.loggingConfiguration = loggingConfiguration;
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) {
        if (this.enabled.get()) {
            try {
                LOGGER.debug("Loading entry {} from {} build cache", (Object)key, (Object)this.getRole());
                return super.load(key, reader);
            }
            catch (BuildCacheException e) {
                this.reportFailure("load", "from", key, (Exception)((Object)e));
                this.recordFailure();
            }
            catch (RuntimeException e) {
                throw new GradleException("Could not load entry " + key + " from " + this.getRole() + " build cache", (Throwable)e);
            }
        }
        return false;
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) {
        if (this.enabled.get()) {
            try {
                LOGGER.debug("Storing entry {} in {} build cache", (Object)key, (Object)this.getRole());
                super.store(key, writer);
            }
            catch (BuildCacheException e) {
                this.reportFailure("store", "in", key, (Exception)((Object)e));
                this.recordFailure();
            }
            catch (Exception e) {
                this.reportFailure("store", "in", key, e);
                this.disableBuildCache("a non-recoverable error was encountered.");
            }
        }
    }

    public void close() throws IOException {
        LOGGER.debug("Closing {} build cache", (Object)this.getRole());
        if (!this.closed) {
            if (!this.enabled.get()) {
                LOGGER.warn("The {} build cache was disabled during the build because {}", (Object)this.getRole(), (Object)this.disableMessage);
            }
            super.close();
        }
        this.closed = true;
    }

    private void reportFailure(String verb, String preposition, BuildCacheKey key, Exception e) {
        if (!LOGGER.isWarnEnabled()) {
            return;
        }
        if (this.loggingConfiguration.getShowStacktrace() == ShowStacktrace.INTERNAL_EXCEPTIONS) {
            LOGGER.warn("Could not {} entry {} {} {} build cache: {}", new Object[]{verb, key, preposition, this.getRole(), e.getMessage()});
        } else {
            LOGGER.warn("Could not {} entry {} {} {} build cache", new Object[]{verb, key, preposition, this.getRole(), e});
        }
    }

    private void recordFailure() {
        if (this.remainingErrorCount.decrementAndGet() <= 0) {
            this.disableBuildCache(this.maxErrorCount + " recoverable errors were encountered.");
        }
    }

    private void disableBuildCache(String message) {
        if (this.enabled.compareAndSet(true, false)) {
            this.disableMessage = message;
            LOGGER.warn("The {} build cache is now disabled because {}", (Object)this.getRole(), (Object)message);
        }
    }
}

