/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Objects;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectDescriptor
implements ProjectDescriptor,
ProjectIdentifier {
    private static final String BUILD_SCRIPT_BASENAME = "build";
    private String name;
    private final PathToFileResolver fileResolver;
    private final ScriptFileResolver scriptFileResolver;
    private File dir;
    private File canonicalDir;
    private DefaultProjectDescriptor parent;
    private Set<ProjectDescriptor> children = new LinkedHashSet<ProjectDescriptor>();
    private ProjectDescriptorRegistry projectDescriptorRegistry;
    private Path path;
    private String buildFileName;

    public DefaultProjectDescriptor(DefaultProjectDescriptor parent, String name, File dir, ProjectDescriptorRegistry projectDescriptorRegistry, PathToFileResolver fileResolver) {
        this(parent, name, dir, projectDescriptorRegistry, fileResolver, null);
    }

    public DefaultProjectDescriptor(DefaultProjectDescriptor parent, String name, File dir, ProjectDescriptorRegistry projectDescriptorRegistry, PathToFileResolver fileResolver, @Nullable ScriptFileResolver scriptFileResolver) {
        this.parent = parent;
        this.name = name;
        this.fileResolver = fileResolver;
        this.dir = dir;
        this.projectDescriptorRegistry = projectDescriptorRegistry;
        this.path = this.path(name);
        projectDescriptorRegistry.addProject(this);
        if (parent != null) {
            parent.getChildren().add(this);
        }
        this.scriptFileResolver = scriptFileResolver;
    }

    private Path path(String name) {
        if (this.isRootDescriptor()) {
            this.path = Path.ROOT;
            return this.path;
        }
        return this.parent.absolutePath(name);
    }

    private Path absolutePath(String path) {
        return this.path.child(path);
    }

    private boolean isRootDescriptor() {
        return this.parent == null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.projectDescriptorRegistry.changeDescriptorPath(this.path, this.path(name));
        this.name = name;
    }

    @Override
    public File getProjectDir() {
        if (this.canonicalDir == null) {
            this.canonicalDir = this.fileResolver.resolve((Object)this.dir);
        }
        return this.canonicalDir;
    }

    @Override
    public void setProjectDir(File dir) {
        this.canonicalDir = null;
        this.dir = dir;
    }

    @Override
    public DefaultProjectDescriptor getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public Set<ProjectDescriptor> getChildren() {
        return this.children;
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    void setPath(Path path) {
        this.path = path;
    }

    @Override
    public String getBuildFileName() {
        return this.buildFile().getName();
    }

    @Override
    public void setBuildFileName(String name) {
        this.buildFileName = name;
    }

    @Override
    public File getBuildFile() {
        return FileUtils.canonicalize((File)this.buildFile());
    }

    private File buildFile() {
        File buildScriptFile;
        if (this.buildFileName != null) {
            return new File(this.getProjectDir(), this.buildFileName);
        }
        File defaultBuildFile = new File(this.getProjectDir(), "build.gradle");
        if (defaultBuildFile.isFile()) {
            return defaultBuildFile;
        }
        if (this.scriptFileResolver != null && (buildScriptFile = this.scriptFileResolver.resolveScriptFile(this.getProjectDir(), BUILD_SCRIPT_BASENAME)) != null) {
            return buildScriptFile;
        }
        return defaultBuildFile;
    }

    public ProjectDescriptorRegistry getProjectDescriptorRegistry() {
        return this.projectDescriptorRegistry;
    }

    public void setProjectDescriptorRegistry(ProjectDescriptorRegistry projectDescriptorRegistry) {
        this.projectDescriptorRegistry = projectDescriptorRegistry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDescriptor that = (DefaultProjectDescriptor)o;
        return Objects.equal((Object)this.getParent(), (Object)that.getParent()) && Objects.equal((Object)this.getName(), (Object)that.getName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getParent(), this.getName()});
    }

    public String toString() {
        return this.getPath();
    }

    public Path path() {
        return this.path;
    }
}

