/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;

public class AttributionSupport {
    private Attributed source;
    private Image attrImage;
    private String attrTermsText;
    private String attrTermsUrl;
    public static final Font ATTR_FONT = new Font("Arial", 0, 10);
    public static final Font ATTR_LINK_FONT;
    protected Rectangle attrTextBounds;
    protected Rectangle attrToUBounds;
    protected Rectangle attrImageBounds;

    public void initialize(Attributed attributed) {
        this.source = attributed;
        boolean bl = attributed.requiresAttribution();
        if (bl) {
            this.attrImage = attributed.getAttributionImage();
            this.attrTermsText = attributed.getTermsOfUseText();
            this.attrTermsUrl = attributed.getTermsOfUseURL();
            if (this.attrTermsUrl != null && this.attrTermsText == null) {
                this.attrTermsText = FeatureAdapter.tr("Background Terms of Use", new Object[0]);
            }
        } else {
            this.attrImage = null;
            this.attrTermsUrl = null;
        }
    }

    public void paintAttribution(Graphics graphics, int n, int n2, ICoordinate iCoordinate, ICoordinate iCoordinate2, int n3, ImageObserver imageObserver) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.source == null || !this.source.requiresAttribution()) {
            this.attrToUBounds = null;
            this.attrImageBounds = null;
            this.attrTextBounds = null;
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(ATTR_LINK_FONT);
        int n8 = 0;
        int n9 = n2;
        if (this.attrTermsText != null) {
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(this.attrTermsText, graphics);
            n7 = (int)rectangle2D.getHeight();
            n8 = n7 - 5;
            n6 = (int)rectangle2D.getWidth();
            n9 = n2 - n8;
            n5 = 2;
            n4 = n2 - n8;
            this.attrToUBounds = new Rectangle(n5, n4 - n8, n6, n7);
            graphics.setColor(Color.black);
            graphics.drawString(this.attrTermsText, n5 + 1, n4 + 1);
            graphics.setColor(Color.white);
            graphics.drawString(this.attrTermsText, n5, n4);
        } else {
            this.attrToUBounds = null;
        }
        if (this.attrImage != null) {
            int n10 = 2;
            n7 = this.attrImage.getWidth(imageObserver);
            n6 = this.attrImage.getHeight(imageObserver);
            n5 = n9 - n6 - n8 - 5;
            this.attrImageBounds = new Rectangle(n10, n5, n7, n6);
            graphics.drawImage(this.attrImage, n10, n5, null);
        } else {
            this.attrImageBounds = null;
        }
        graphics.setFont(ATTR_FONT);
        String string = this.source.getAttributionText(n3, iCoordinate, iCoordinate2);
        if (string == null) {
            string = this.source.getAttributionLinkURL();
        }
        if (string != null) {
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
            n6 = (int)rectangle2D.getHeight() - 5;
            n5 = n - (int)rectangle2D.getWidth();
            n4 = n2 - n6;
            graphics.setColor(Color.black);
            graphics.drawString(string, n5 + 1, n4 + 1);
            graphics.setColor(Color.white);
            graphics.drawString(string, n5, n4);
            this.attrTextBounds = new Rectangle(n5, n4 - n6, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        } else {
            this.attrTextBounds = null;
        }
        graphics.setFont(font);
    }

    public boolean handleAttributionCursor(Point point) {
        if (this.attrTextBounds != null && this.attrTextBounds.contains(point)) {
            return true;
        }
        if (this.attrImageBounds != null && this.attrImageBounds.contains(point)) {
            return true;
        }
        return this.attrToUBounds != null && this.attrToUBounds.contains(point);
    }

    public boolean handleAttribution(Point point, boolean bl) {
        String string;
        if (this.source == null || !this.source.requiresAttribution()) {
            return false;
        }
        if (this.attrTextBounds != null && this.attrTextBounds.contains(point)) {
            String string2 = this.source.getAttributionLinkURL();
            if (string2 != null) {
                if (bl) {
                    FeatureAdapter.openLink(string2);
                }
                return true;
            }
        } else if (this.attrImageBounds != null && this.attrImageBounds.contains(point)) {
            String string3 = this.source.getAttributionImageURL();
            if (string3 != null) {
                if (bl) {
                    FeatureAdapter.openLink(this.source.getAttributionImageURL());
                }
                return true;
            }
        } else if (this.attrToUBounds != null && this.attrToUBounds.contains(point) && (string = this.source.getTermsOfUseURL()) != null) {
            if (bl) {
                FeatureAdapter.openLink(string);
            }
            return true;
        }
        return false;
    }

    static {
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        ATTR_LINK_FONT = ATTR_FONT.deriveFont(hashMap);
    }
}

