/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractPasteAction
extends JosmAction
implements FlavorListener {
    protected final OsmTransferHandler transferHandler = new OsmTransferHandler();

    public AbstractPasteAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        this(string, string2, string3, shortcut, bl, null);
    }

    public AbstractPasteAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4) {
        super(string, string2, string3, shortcut, bl, string4, true);
        ClipboardUtils.getClipboard().addFlavorListener(this);
    }

    protected EastNorth computePastePosition(ActionEvent actionEvent) {
        EastNorth eastNorth = Main.map.mapView.getCenter();
        if (actionEvent != null && !this.getValue("Name").equals(actionEvent.getActionCommand())) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            Point point2 = Main.map.mapView.getLocationOnScreen();
            Point point3 = new Point(point.x - point2.x, point.y - point2.y);
            if (Main.map.mapView.contains(point3)) {
                eastNorth = Main.map.mapView.getEastNorth(point3.x, point3.y);
            }
        }
        return eastNorth;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doPaste(actionEvent, ClipboardUtils.getClipboardContent());
    }

    protected void doPaste(ActionEvent actionEvent, Transferable transferable) {
        this.transferHandler.pasteOn(Main.getLayerManager().getEditLayer(), this.computePastePosition(actionEvent), transferable);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null && this.transferHandler.isDataAvailable());
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        this.updateEnabledState();
    }
}

