/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class CombineWayAction
extends JosmAction {
    private static final BooleanProperty PROP_REVERSE_WAY = new BooleanProperty("tag-correction.reverse-way", true);

    public CombineWayAction() {
        super(I18n.tr("Combine Way", new Object[0]), "combineway", I18n.tr("Combine several ways into one.", new Object[0]), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way", new Object[0])), 67, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/CombineWay"));
    }

    protected static boolean confirmChangeDirectionOfWays() {
        return new ExtendedDialog(Main.parent, I18n.tr("Change directions?", new Object[0]), I18n.tr("Reverse and Combine", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("wayflip", "cancel").setContent(I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?", new Object[0])).toggleEnable("combineway-reverse").showDialog().getValue() == 1;
    }

    protected static void warnCombiningImpossible() {
        String string = I18n.tr("Could not combine ways<br>(They could not be merged into a single string of nodes)", new Object[0]);
        new Notification(string).setIcon(1).show();
    }

    protected static Way getTargetWay(Collection<Way> collection) {
        Way way = collection.iterator().next();
        Iterator<Way> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Way way2;
            way = way2 = iterator.next();
            if (way2.isNew()) continue;
            break;
        }
        return way;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Way, Command> combineWaysWorker(Collection<Way> collection) throws UserCancelException {
        Object object;
        List<Command> list;
        List<Way> list2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        collection.remove(null);
        collection = new LinkedHashSet<Way>(collection);
        List list3 = collection.stream().map(OsmPrimitive::getDataSet).distinct().collect(Collectors.toList());
        if (list3.size() != 1) {
            throw new IllegalArgumentException("Cannot combine ways of multiple data sets.");
        }
        NodeGraph nodeGraph = NodeGraph.createNearlyUndirectedGraphFromNodeWays(collection);
        List<Node> list4 = nodeGraph.buildSpanningPath();
        if (list4 == null) {
            CombineWayAction.warnCombiningImpossible();
            return null;
        }
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(collection);
        LinkedList<Command> linkedList = new LinkedList<Command>();
        List<Way> list5 = new LinkedList<Way>();
        List<Way> list6 = new LinkedList<Way>();
        for (Way object32 : collection) {
            if (object32.getNodesCount() < 2 || list4.indexOf(object32.getNode(0)) + 1 == list4.lastIndexOf(object32.getNode(1))) {
                list6.add(object32);
                continue;
            }
            list5.add(object32);
        }
        if (list6.isEmpty()) {
            Collections.reverse(list4);
            list6 = list5;
            list5 = null;
        }
        if (list5 != null && !list5.isEmpty()) {
            if (!CombineWayAction.confirmChangeDirectionOfWays()) {
                return null;
            }
            list6 = ReverseWayTagCorrector.irreversibleWays(list6);
            if ((list5 = ReverseWayTagCorrector.irreversibleWays(list5)).size() > list6.size()) {
                Collections.reverse(list4);
                list2 = list6;
                list6 = null;
                list5 = list2;
            }
            if (!list5.isEmpty() && PROP_REVERSE_WAY.get().booleanValue()) {
                list2 = new ArrayList<Way>(collection);
                list2.removeAll(list5);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                list = new ArrayList<Command>(list5.size());
                for (Way way : list5) {
                    object = new Way(way);
                    list.add((Command)object);
                    linkedList.addAll(reverseWayTagCorrector.execute(way, (Way)object));
                }
                if (!linkedList.isEmpty()) {
                    Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Reverse Ways", new Object[0]), linkedList));
                }
                tagCollection = TagCollection.unionOfAllPrimitives(list);
                tagCollection.add(TagCollection.unionOfAllPrimitives(list2));
            }
        }
        list2 = CombineWayAction.getTargetWay(collection);
        Way way = new Way((Way)((Object)list2));
        way.setNodes(list4);
        try {
            list = CombinePrimitiveResolverDialog.launchIfNecessary(tagCollection, collection, Collections.singleton(list2));
        }
        finally {
            if (!linkedList.isEmpty()) {
                Main.main.undoRedo.undo();
            }
        }
        LinkedList<ChangeCommand> linkedList2 = new LinkedList<ChangeCommand>();
        LinkedList<Way> linkedList3 = new LinkedList<Way>(collection);
        linkedList3.remove(list2);
        linkedList2.add(new ChangeCommand((DataSet)list3.get(0), (OsmPrimitive)((Object)list2), (OsmPrimitive)way));
        linkedList2.addAll(linkedList);
        linkedList2.addAll(list);
        linkedList2.add((ChangeCommand)((Object)new DeleteCommand((DataSet)list3.get(0), linkedList3)));
        object = new SequenceCommand(I18n.trn("Combine {0} way", "Combine {0} ways", collection.size(), collection.size()), (Collection<Command>)linkedList2);
        return new Pair<List<Way>, Object>(list2, object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Pair<Way, Command> pair;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            return;
        }
        Collection<Way> collection = dataSet.getSelectedWays();
        if (collection.size() < 2) {
            new Notification(I18n.tr("Please select at least two ways to combine.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        try {
            pair = CombineWayAction.combineWaysWorker(collection);
        }
        catch (UserCancelException userCancelException) {
            Main.trace(userCancelException);
            return;
        }
        if (pair == null) {
            return;
        }
        Way way = (Way)pair.a;
        Main.main.undoRedo.add((Command)pair.b);
        if (way != null) {
            GuiHelper.runInEDT(() -> dataSet.setSelected(way));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        this.setEnabled(n >= 2);
    }

    public static class NodeGraph {
        private final Set<NodePair> edges;
        private int numUndirectedEges;
        private final Map<Node, List<NodePair>> successors = new LinkedHashMap<Node, List<NodePair>>();
        private final Map<Node, List<NodePair>> predecessors = new LinkedHashMap<Node, List<NodePair>>();

        public static List<NodePair> buildNodePairs(Way way, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Pair<Node, Node> pair : way.getNodePairs(false)) {
                arrayList.add(new NodePair(pair));
                if (bl) continue;
                arrayList.add(new NodePair(pair).swap());
            }
            return arrayList;
        }

        public static List<NodePair> buildNodePairs(List<Way> list, boolean bl) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (Way way : list) {
                arrayList.addAll(NodeGraph.buildNodePairs(way, bl));
            }
            return arrayList;
        }

        public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> list) {
            ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
            for (NodePair nodePair : list) {
                if (arrayList.contains(nodePair) || arrayList.contains(nodePair.swap())) continue;
                arrayList.add(nodePair);
            }
            return arrayList;
        }

        public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
            }
            return nodeGraph;
        }

        public static NodeGraph createDirectedGraphFromWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, true));
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> list) {
            NodeGraph nodeGraph = new NodeGraph();
            for (NodePair nodePair : list) {
                nodeGraph.add(nodePair);
                nodeGraph.add(nodePair.swap());
            }
            return nodeGraph;
        }

        public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> collection) {
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                nodeGraph.add(NodeGraph.buildNodePairs(way, false));
            }
            return nodeGraph;
        }

        public static NodeGraph createNearlyUndirectedGraphFromNodeWays(Collection<Way> collection) {
            boolean bl = true;
            NodeGraph nodeGraph = new NodeGraph();
            for (Way way : collection) {
                if (!way.isNew()) {
                    nodeGraph.add(NodeGraph.buildNodePairs(way, bl));
                    bl = false;
                    continue;
                }
                nodeGraph.add(NodeGraph.buildNodePairs(way, false));
            }
            return nodeGraph;
        }

        protected void rememberSuccessor(NodePair nodePair) {
            if (this.successors.containsKey(nodePair.getA())) {
                if (!this.successors.get(nodePair.getA()).contains(nodePair)) {
                    this.successors.get(nodePair.getA()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.successors.put(nodePair.getA(), arrayList);
            }
        }

        protected void rememberPredecessors(NodePair nodePair) {
            if (this.predecessors.containsKey(nodePair.getB())) {
                if (!this.predecessors.get(nodePair.getB()).contains(nodePair)) {
                    this.predecessors.get(nodePair.getB()).add(nodePair);
                }
            } else {
                ArrayList<NodePair> arrayList = new ArrayList<NodePair>();
                arrayList.add(nodePair);
                this.predecessors.put(nodePair.getB(), arrayList);
            }
        }

        protected boolean isTerminalNode(Node node) {
            if (this.successors.get(node) == null) {
                return false;
            }
            if (this.successors.get(node).size() != 1) {
                return false;
            }
            if (this.predecessors.get(node) == null) {
                return true;
            }
            if (this.predecessors.get(node).size() == 1) {
                NodePair nodePair = this.successors.get(node).get(0);
                NodePair nodePair2 = this.predecessors.get(node).get(0);
                return nodePair.equals(nodePair2.swap());
            }
            return false;
        }

        protected void prepare() {
            LinkedHashSet<NodePair> linkedHashSet = new LinkedHashSet<NodePair>();
            this.successors.clear();
            this.predecessors.clear();
            for (NodePair nodePair : this.edges) {
                if (!linkedHashSet.contains(nodePair) && !linkedHashSet.contains(nodePair.swap())) {
                    linkedHashSet.add(nodePair);
                }
                this.rememberSuccessor(nodePair);
                this.rememberPredecessors(nodePair);
            }
            this.numUndirectedEges = linkedHashSet.size();
        }

        public NodeGraph() {
            this.edges = new LinkedHashSet<NodePair>();
        }

        public void add(NodePair nodePair) {
            if (!this.edges.contains(nodePair)) {
                this.edges.add(nodePair);
            }
        }

        public void add(List<NodePair> list) {
            for (NodePair nodePair : list) {
                this.add(nodePair);
            }
        }

        protected Set<Node> getTerminalNodes() {
            LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
            for (Node node : this.getNodes()) {
                if (!this.isTerminalNode(node)) continue;
                linkedHashSet.add(node);
            }
            return linkedHashSet;
        }

        protected List<NodePair> getOutboundPairs(NodePair nodePair) {
            return this.getOutboundPairs(nodePair.getB());
        }

        protected List<NodePair> getOutboundPairs(Node node) {
            return Optional.ofNullable(this.successors.get(node)).orElseGet(Collections::emptyList);
        }

        protected Set<Node> getNodes() {
            LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>(2 * this.edges.size());
            for (NodePair nodePair : this.edges) {
                linkedHashSet.add(nodePair.getA());
                linkedHashSet.add(nodePair.getB());
            }
            return linkedHashSet;
        }

        protected boolean isSpanningWay(Stack<NodePair> stack) {
            return this.numUndirectedEges == stack.size();
        }

        protected List<Node> buildPathFromNodePairs(Stack<NodePair> stack) {
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (NodePair nodePair : stack) {
                linkedList.add(nodePair.getA());
            }
            linkedList.add(stack.peek().getB());
            return linkedList;
        }

        protected List<Node> buildSpanningPath(Node node) {
            if (node == null) {
                return null;
            }
            Stack<NodePair> stack = new Stack<NodePair>();
            Stack<NodePair> stack2 = new Stack<NodePair>();
            stack2.addAll(this.getOutboundPairs(node));
            while (!stack2.isEmpty()) {
                NodePair nodePair = (NodePair)stack2.pop();
                if (stack.contains(nodePair) || stack.contains(nodePair.swap())) continue;
                while (!stack.isEmpty() && !((NodePair)stack.peek()).isPredecessorOf(nodePair)) {
                    stack.pop();
                }
                stack.push(nodePair);
                if (this.isSpanningWay(stack)) {
                    return this.buildPathFromNodePairs(stack);
                }
                stack2.addAll(this.getOutboundPairs(stack.peek()));
            }
            return null;
        }

        public List<Node> buildSpanningPath() {
            this.prepare();
            Set<Node> set = this.getTerminalNodes();
            set = set.isEmpty() ? this.getNodes() : set;
            for (Node node : set) {
                List<Node> list = this.buildSpanningPath(node);
                if (list == null) continue;
                return list;
            }
            return null;
        }
    }

    public static class NodePair {
        private final Node a;
        private final Node b;

        public NodePair(Node node, Node node2) {
            this.a = node;
            this.b = node2;
        }

        public NodePair(Pair<Node, Node> pair) {
            this((Node)pair.a, (Node)pair.b);
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public boolean isSuccessorOf(NodePair nodePair) {
            return nodePair.getB() == this.a;
        }

        public boolean isPredecessorOf(NodePair nodePair) {
            return this.b == nodePair.getA();
        }

        public NodePair swap() {
            return new NodePair(this.b, this.a);
        }

        public String toString() {
            return "" + '[' + this.a.getId() + ',' + this.b.getId() + ']';
        }

        public boolean contains(Node node) {
            return this.a == node || this.b == node;
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NodePair nodePair = (NodePair)object;
            return Objects.equals(this.a, nodePair.a) && Objects.equals(this.b, nodePair.b);
        }
    }
}

