/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmChangeTask
extends DownloadOsmTask {
    private static final String OSM_WEBSITE_PATTERN = "https?://www\\.(osm|openstreetmap)\\.org/changeset/(\\p{Digit}+).*";

    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/api/0.6/changeset/\\p{Digit}+/download", OSM_WEBSITE_PATTERN, "https?://.*/.*\\.osc"};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM Change", new Object[0]);
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        Matcher matcher = Pattern.compile(OSM_WEBSITE_PATTERN).matcher(string);
        if (matcher.matches()) {
            string = OsmApi.getOsmApi().getBaseUrl() + "changeset/" + Long.parseLong(matcher.group(2)) + "/download";
        }
        this.downloadTask = new DownloadTask(bl, (OsmServerReader)new OsmServerLocationReader(string), progressMonitor);
        this.extractOsmFilename("https?://.*/(.*\\.osc)", string);
        return Main.worker.submit(this.downloadTask);
    }

    private static final class HistoryLoaderAndListener
    extends HistoryLoadTask
    implements HistoryDataSetListener {
        private final Map<OsmPrimitive, Date> toLoad;

        private HistoryLoaderAndListener(Map<OsmPrimitive, Date> map) {
            this.toLoad = map;
            this.add(map.keySet());
            HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        }

        @Override
        public void historyUpdated(HistoryDataSet historyDataSet, PrimitiveId primitiveId) {
            HashMap<OsmPrimitive, Date> hashMap = new HashMap<OsmPrimitive, Date>();
            Iterator<Map.Entry<OsmPrimitive, Date>> iterator = this.toLoad.entrySet().iterator();
            while (iterator.hasNext()) {
                PrimitiveData primitiveData;
                HistoryOsmPrimitive historyOsmPrimitive;
                Map.Entry<OsmPrimitive, Date> entry = iterator.next();
                OsmPrimitive osmPrimitive = entry.getKey();
                History history = historyDataSet.getHistory(osmPrimitive.getPrimitiveId());
                Date date = entry.getValue();
                if (history == null || date == null || (historyOsmPrimitive = history.getByDate(date)) == null) continue;
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        primitiveData = ((HistoryNode)historyOsmPrimitive).fillPrimitiveData(new NodeData());
                        break;
                    }
                    case WAY: {
                        primitiveData = ((HistoryWay)historyOsmPrimitive).fillPrimitiveData(new WayData());
                        for (Long l : ((HistoryWay)historyOsmPrimitive).getNodes()) {
                            if (osmPrimitive.getDataSet().getPrimitiveById(l, OsmPrimitiveType.NODE) != null) continue;
                            Node node = new Node(l);
                            osmPrimitive.getDataSet().addPrimitive(node);
                            hashMap.put(node, date);
                        }
                        break;
                    }
                    case RELATION: {
                        primitiveData = ((HistoryRelation)historyOsmPrimitive).fillPrimitiveData(new RelationData());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unknown primitive type");
                    }
                }
                try {
                    osmPrimitive.load(primitiveData);
                    iterator.remove();
                }
                catch (AssertionError assertionError) {
                    Main.error((Throwable)((Object)assertionError), "Cannot load " + osmPrimitive + ':');
                }
            }
            historyDataSet.removeHistoryDataSetListener(this);
            if (hashMap.isEmpty()) {
                Main.map.repaint();
            } else {
                Main.worker.submit(new HistoryLoaderAndListener(hashMap));
            }
        }

        @Override
        public void historyDataSetCleared(HistoryDataSet historyDataSet) {
        }
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(DownloadOsmChangeTask.this, bl, osmServerReader, progressMonitor);
        }

        @Override
        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        @Override
        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            try {
                HashMap<OsmPrimitive, Date> hashMap = new HashMap<OsmPrimitive, Date>();
                for (OsmPrimitive osmPrimitive : ((DataSet)DownloadOsmChangeTask.this.downloadedData).allNonDeletedPrimitives()) {
                    if (!osmPrimitive.isIncomplete()) continue;
                    Date date = null;
                    for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                        if (osmPrimitive2.isTimestampEmpty()) continue;
                        date = osmPrimitive2.getTimestamp();
                        break;
                    }
                    hashMap.put(osmPrimitive, date);
                }
                if (DownloadOsmChangeTask.this.isCanceled()) {
                    return;
                }
                Main.worker.submit(new HistoryLoaderAndListener(hashMap));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                DownloadOsmChangeTask.this.rememberException(rejectedExecutionException);
                DownloadOsmChangeTask.this.setFailed(true);
            }
        }
    }
}

