/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangeRelationMemberRoleCommand
extends Command {
    private final Relation relation;
    private final int position;
    private final String newRole;
    private String oldRole;
    private Boolean oldModified;

    public ChangeRelationMemberRoleCommand(Relation relation, int n, String string) {
        this.relation = relation;
        this.position = n;
        this.newRole = string;
    }

    public ChangeRelationMemberRoleCommand(DataSet dataSet, Relation relation, int n, String string) {
        super(dataSet);
        this.relation = relation;
        this.position = n;
        this.newRole = string;
    }

    @Override
    public boolean executeCommand() {
        if (this.position >= 0 && this.position < this.relation.getMembersCount()) {
            this.oldRole = this.relation.getMember(this.position).getRole();
            if (!this.newRole.equals(this.oldRole)) {
                this.relation.setMember(this.position, new RelationMember(this.newRole, this.relation.getMember(this.position).getMember()));
                this.oldModified = this.relation.isModified();
                this.relation.setModified(true);
            }
        }
        return true;
    }

    @Override
    public void undoCommand() {
        if (this.position >= 0 && this.position < this.relation.getMembersCount()) {
            this.relation.setMember(this.position, new RelationMember(this.oldRole, this.relation.getMember(this.position).getMember()));
            if (this.oldModified != null) {
                this.relation.setModified(this.oldModified);
            }
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.relation);
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Change relation member role for {0} {1}", new Object[]{OsmPrimitiveType.from(this.relation), this.relation.getDisplayName(DefaultNameFormatter.getInstance())});
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.relation.getDisplayType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relation, this.position, this.newRole, this.oldRole, this.oldModified);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangeRelationMemberRoleCommand changeRelationMemberRoleCommand = (ChangeRelationMemberRoleCommand)object;
        return this.position == changeRelationMemberRoleCommand.position && Objects.equals(this.relation, changeRelationMemberRoleCommand.relation) && Objects.equals(this.newRole, changeRelationMemberRoleCommand.newRole) && Objects.equals(this.oldRole, changeRelationMemberRoleCommand.oldRole) && Objects.equals(this.oldModified, changeRelationMemberRoleCommand.oldModified);
    }
}

