/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScrollViewport
extends JPanel {
    private static final int NO_SCROLL = 0;
    public static final int UP_DIRECTION = 1;
    public static final int DOWN_DIRECTION = 2;
    public static final int LEFT_DIRECTION = 4;
    public static final int RIGHT_DIRECTION = 8;
    public static final int VERTICAL_DIRECTION = 3;
    public static final int HORIZONTAL_DIRECTION = 12;
    public static final int ALL_DIRECTION = 15;
    private final JViewport vp = new JViewport();
    private JComponent component;
    private final List<JButton> buttons = new ArrayList<JButton>();
    private final Timer timer = new Timer(100, actionEvent -> this.scroll());
    private int scrollDirection = 0;
    private final int allowedScrollDirections;
    private final ComponentAdapter refreshButtonsOnResize = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ScrollViewport.this.showOrHideButtons();
        }
    };

    public ScrollViewport(JComponent jComponent, int n) {
        this(n);
        this.add(jComponent);
    }

    public ScrollViewport(int n) {
        super(new BorderLayout());
        this.allowedScrollDirections = n;
        if ((n & 1) != 0) {
            this.addScrollButton(1, "svpUp", "North");
        }
        if ((n & 2) != 0) {
            this.addScrollButton(2, "svpDown", "South");
        }
        if ((n & 4) != 0) {
            this.addScrollButton(4, "svpLeft", "West");
        }
        if ((n & 8) != 0) {
            this.addScrollButton(8, "svpRight", "East");
        }
        this.add((Component)this.vp, "Center");
        this.addComponentListener(this.refreshButtonsOnResize);
        this.showOrHideButtons();
        if ((n & 3) != 0) {
            this.addMouseWheelListener(mouseWheelEvent -> this.scroll(0, mouseWheelEvent.getUnitsToScroll() * 5));
        } else if ((n & 0xC) != 0) {
            this.addMouseWheelListener(mouseWheelEvent -> this.scroll(mouseWheelEvent.getUnitsToScroll() * 5, 0));
        }
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(400);
    }

    private void addScrollButton(int n, String string, String string2) {
        JButton jButton = new JButton();
        jButton.addMouseListener(new ScrollViewPortMouseListener(n));
        jButton.setPreferredSize(new Dimension(10, 10));
        jButton.setIcon(ImageProvider.get(string));
        this.add((Component)jButton, string2);
        this.buttons.add(jButton);
    }

    public synchronized void scroll() {
        int n = this.scrollDirection;
        if (this.component == null || n == 0) {
            return;
        }
        Rectangle rectangle = this.vp.getViewRect();
        int n2 = 0;
        int n3 = 0;
        if (n < 4) {
            n3 = rectangle.height * 2 / 7;
        } else {
            n2 = rectangle.width * 2 / 7;
        }
        switch (n) {
            case 1: {
                n3 *= -1;
                break;
            }
            case 4: {
                n2 *= -1;
                break;
            }
        }
        this.scroll(n2, n3);
    }

    public synchronized void scroll(int n, int n2) {
        if (this.component == null) {
            return;
        }
        Dimension dimension = this.component.getSize();
        Rectangle rectangle = this.vp.getViewRect();
        int n3 = rectangle.x + n;
        int n4 = rectangle.y + n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > dimension.height - rectangle.height) {
            n4 = dimension.height - rectangle.height;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > dimension.width - rectangle.width) {
            n3 = dimension.width - rectangle.width;
        }
        this.vp.setViewPosition(new Point(n3, n4));
    }

    public void showOrHideButtons() {
        boolean bl = false;
        if ((this.allowedScrollDirections & 3) != 0) {
            bl |= this.getViewSize().height > this.getViewRect().height;
        }
        if ((this.allowedScrollDirections & 0xC) != 0) {
            bl |= this.getViewSize().width > this.getViewRect().width;
        }
        for (JButton jButton : this.buttons) {
            jButton.setVisible(bl);
        }
    }

    public Rectangle getViewRect() {
        return this.vp.getViewRect();
    }

    public Dimension getViewSize() {
        return this.vp.getViewSize();
    }

    public Point getViewPosition() {
        return this.vp.getViewPosition();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.component == null) {
            return this.vp.getPreferredSize();
        }
        return this.component.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.component == null) {
            return this.vp.getMinimumSize();
        }
        Dimension dimension = this.component.getMinimumSize();
        if ((this.allowedScrollDirections & 0xC) != 0) {
            dimension = new Dimension(20, dimension.height);
        }
        if ((this.allowedScrollDirections & 3) != 0) {
            dimension = new Dimension(dimension.width, 20);
        }
        return dimension;
    }

    public void add(JComponent jComponent) {
        this.vp.removeAll();
        if (this.component != null) {
            this.component.removeComponentListener(this.refreshButtonsOnResize);
        }
        this.component = jComponent;
        jComponent.addComponentListener(this.refreshButtonsOnResize);
        this.vp.add(jComponent);
    }

    private class ScrollViewPortMouseListener
    extends MouseAdapter {
        private final int direction;

        ScrollViewPortMouseListener(int n) {
            this.direction = n;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = this.direction;
            ScrollViewport.this.scroll();
            ScrollViewport.this.timer.restart();
        }
    }
}

