/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class ConvertToDataLayerAction<T extends Layer>
extends AbstractAction {
    protected final transient T layer;

    protected ConvertToDataLayerAction(T t) {
        super(I18n.tr("Convert to data layer", new Object[0]), ImageProvider.get("converttoosm"));
        this.layer = t;
        this.putValue("help", HelpUtil.ht("/Action/ConvertToDataLayer"));
    }

    public abstract DataSet convert();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:</html>", new Object[0])), GBC.eol());
        jPanel.add((Component)new UrlLabel(Main.getOSMWebsite() + "/traces", 2), GBC.eop());
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, jPanel, I18n.tr("Warning", new Object[0]), 2, 2, 0)) {
            return;
        }
        DataSet dataSet = this.convert();
        OsmDataLayer osmDataLayer = new OsmDataLayer(dataSet, I18n.tr("Converted from: {0}", ((Layer)this.layer).getName()), null);
        if (((Layer)this.layer).getAssociatedFile() != null) {
            osmDataLayer.setAssociatedFile(new File(((Layer)this.layer).getAssociatedFile().getParentFile(), ((Layer)this.layer).getAssociatedFile().getName() + ".osm"));
        }
        osmDataLayer.setUploadDiscouraged(true);
        Main.getLayerManager().addLayer(osmDataLayer);
        Main.getLayerManager().removeLayer((Layer)this.layer);
    }

    public static class FromMarkerLayer
    extends ConvertToDataLayerAction<MarkerLayer> {
        public FromMarkerLayer(MarkerLayer markerLayer) {
            super(markerLayer);
        }

        @Override
        public DataSet convert() {
            DataSet dataSet = new DataSet();
            for (Marker marker : ((MarkerLayer)this.layer).data) {
                Node node = new Node(marker.getCoor());
                Collection<String> collection = Main.pref.getCollection("gpx.to-osm-mapping", Arrays.asList("name", "name", "desc", "description", "cmt", "note", "src", "source", "sym", "gpxicon"));
                if (collection.size() % 2 == 0) {
                    Iterator<String> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        String string = iterator.next();
                        String string3 = iterator.next();
                        Optional.ofNullable(marker.getTemplateValue(string, false)).map(String::valueOf).ifPresent(string2 -> node.put(string3, (String)string2));
                    }
                } else {
                    Main.warn("Invalid gpx.to-osm-mapping Einstein setting: expecting even number of entries");
                }
                dataSet.addPrimitive(node);
            }
            return dataSet;
        }
    }

    public static class FromGpxLayer
    extends ConvertToDataLayerAction<GpxLayer> {
        public FromGpxLayer(GpxLayer gpxLayer) {
            super(gpxLayer);
        }

        @Override
        public DataSet convert() {
            DataSet dataSet = new DataSet();
            for (GpxTrack gpxTrack : ((GpxLayer)this.layer).data.getTracks()) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        Node node = new Node(wayPoint.getCoor());
                        String string = wayPoint.getString("time");
                        if (string != null) {
                            try {
                                node.setTimestamp(DateUtils.fromString(string));
                            }
                            catch (UncheckedParseException uncheckedParseException) {
                                Main.warn((Throwable)uncheckedParseException, false);
                            }
                        }
                        dataSet.addPrimitive(node);
                        arrayList.add(node);
                    }
                    Way way = new Way();
                    way.setNodes(arrayList);
                    dataSet.addPrimitive(way);
                }
            }
            return dataSet;
        }
    }
}

