/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.image.BufferedImage;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.imagery.ColorfulFilter;

public class ColorfulImageProcessor
implements ImageProcessor {
    private ColorfulFilter op;
    private double colorfulness = 1.0;

    public double getColorfulness() {
        return this.colorfulness;
    }

    public void setColorfulness(double d) {
        this.colorfulness = d < 0.0 ? 0.0 : d;
        this.op = this.colorfulness < 0.95 || this.colorfulness > 1.05 ? new ColorfulFilter(this.colorfulness) : null;
    }

    @Override
    public BufferedImage process(BufferedImage bufferedImage) {
        if (this.op != null) {
            return this.op.filter(bufferedImage, null);
        }
        return bufferedImage;
    }

    public String toString() {
        return "ColorfulImageProcessor [colorfulness=" + this.colorfulness + ']';
    }
}

