/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.styleelement.LabelCompositionStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class TextLabel
implements StyleKeys {
    public static final LabelCompositionStrategy AUTO_LABEL_COMPOSITION_STRATEGY = new LabelCompositionStrategy.DeriveLabelFromNameTagsCompositionStrategy();
    public LabelCompositionStrategy labelCompositionStrategy;
    public Font font;
    public int xOffset;
    public int yOffset;
    public Color color;
    public Float haloRadius;
    public Color haloColor;
    private final PositionForAreaStrategy labelPositionStrategy;

    protected TextLabel(LabelCompositionStrategy labelCompositionStrategy, Font font, int n, int n2, Color color, Float f, Color color2, PositionForAreaStrategy positionForAreaStrategy) {
        this.labelCompositionStrategy = labelCompositionStrategy;
        this.font = Objects.requireNonNull(font, "font");
        this.xOffset = n;
        this.yOffset = n2;
        this.color = Objects.requireNonNull(color, "color");
        this.haloRadius = f;
        this.haloColor = color2;
        this.labelPositionStrategy = Objects.requireNonNull(positionForAreaStrategy, "labelPositionStrategy");
    }

    public TextLabel(TextLabel textLabel) {
        this.labelCompositionStrategy = textLabel.labelCompositionStrategy;
        this.font = textLabel.font;
        this.xOffset = textLabel.xOffset;
        this.yOffset = textLabel.yOffset;
        this.color = textLabel.color;
        this.haloColor = textLabel.haloColor;
        this.haloRadius = textLabel.haloRadius;
        this.labelPositionStrategy = textLabel.labelPositionStrategy;
    }

    private TextLabel(TextLabel textLabel, PositionForAreaStrategy positionForAreaStrategy) {
        this.labelCompositionStrategy = textLabel.labelCompositionStrategy;
        this.font = textLabel.font;
        this.xOffset = textLabel.xOffset;
        this.yOffset = textLabel.yOffset;
        this.color = textLabel.color;
        this.haloColor = textLabel.haloColor;
        this.haloRadius = textLabel.haloRadius;
        this.labelPositionStrategy = positionForAreaStrategy;
    }

    protected static LabelCompositionStrategy buildLabelCompositionStrategy(Cascade cascade, boolean bl) {
        MapPaintStyles.TagKeyReference tagKeyReference = cascade.get("text", null, MapPaintStyles.TagKeyReference.class, true);
        if (tagKeyReference != null) {
            return new LabelCompositionStrategy.TagLookupCompositionStrategy(tagKeyReference.key);
        }
        Keyword keyword = cascade.get("text", null, Keyword.class, true);
        if (Keyword.AUTO.equals(keyword)) {
            return AUTO_LABEL_COMPOSITION_STRATEGY;
        }
        String string = cascade.get("text", null, String.class, true);
        if (string != null) {
            return new LabelCompositionStrategy.StaticLabelCompositionStrategy(string);
        }
        return bl ? AUTO_LABEL_COMPOSITION_STRATEGY : null;
    }

    public static TextLabel create(Environment environment, Color color, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(color);
        Cascade cascade = environment.mc.getCascade(environment.layer);
        LabelCompositionStrategy labelCompositionStrategy = TextLabel.buildLabelCompositionStrategy(cascade, bl);
        if (labelCompositionStrategy == null) {
            return null;
        }
        String string = labelCompositionStrategy.compose(environment.osm);
        if (string == null) {
            return null;
        }
        Font font = StyleElement.getFont(cascade, string);
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = cascade.get("text-offset", null, float[].class);
        if (fArray != null) {
            if (fArray.length == 1) {
                f2 = fArray[0];
            } else if (fArray.length >= 2) {
                f = fArray[0];
                f2 = fArray[1];
            }
        }
        f = cascade.get("text-offset-x", Float.valueOf(f), Float.class).floatValue();
        f2 = cascade.get("text-offset-y", Float.valueOf(f2), Float.class).floatValue();
        Color color2 = cascade.get("text-color", color, Color.class);
        float f3 = cascade.get("text-opacity", Float.valueOf(1.0f), Float.class).floatValue();
        color2 = Utils.alphaMultiply(color2, f3);
        Float f4 = cascade.get("text-halo-radius", null, Float.class);
        if (f4 != null && f4.floatValue() <= 0.0f) {
            f4 = null;
        }
        Color color3 = null;
        if (f4 != null) {
            color3 = cascade.get("text-halo-color", Utils.complement(color2), Color.class);
            float f5 = cascade.get("text-halo-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color3 = Utils.alphaMultiply(color3, f5);
        }
        Keyword keyword = cascade.get("text-position", null, Keyword.class);
        PositionForAreaStrategy positionForAreaStrategy = PositionForAreaStrategy.forKeyword(keyword);
        return new TextLabel(labelCompositionStrategy, font, (int)f, -((int)f2), color2, f4, color3, positionForAreaStrategy);
    }

    public String getString(OsmPrimitive osmPrimitive) {
        if (this.labelCompositionStrategy == null) {
            return null;
        }
        return this.labelCompositionStrategy.compose(osmPrimitive);
    }

    public PositionForAreaStrategy getLabelPositionStrategy() {
        return this.labelPositionStrategy;
    }

    public TextLabel withPosition(PositionForAreaStrategy positionForAreaStrategy) {
        return new TextLabel(this, positionForAreaStrategy);
    }

    public String toString() {
        return "TextLabel{" + this.toStringImpl() + '}';
    }

    protected String toStringImpl() {
        StringBuilder stringBuilder = new StringBuilder(96);
        stringBuilder.append("labelCompositionStrategy=").append(this.labelCompositionStrategy).append(" font=").append(this.font);
        if (this.xOffset != 0) {
            stringBuilder.append(" xOffset=").append(this.xOffset);
        }
        if (this.yOffset != 0) {
            stringBuilder.append(" yOffset=").append(this.yOffset);
        }
        stringBuilder.append(" color=").append(Utils.toString(this.color));
        if (this.haloRadius != null) {
            stringBuilder.append(" haloRadius=").append(this.haloRadius).append(" haloColor=").append(this.haloColor);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.labelCompositionStrategy, this.font, this.xOffset, this.yOffset, this.color, this.haloRadius, this.haloColor);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextLabel textLabel = (TextLabel)object;
        return this.xOffset == textLabel.xOffset && this.yOffset == textLabel.yOffset && Objects.equals(this.labelCompositionStrategy, textLabel.labelCompositionStrategy) && Objects.equals(this.font, textLabel.font) && Objects.equals(this.color, textLabel.color) && Objects.equals(this.haloRadius, textLabel.haloRadius) && Objects.equals(this.haloColor, textLabel.haloColor);
    }
}

