/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;

public class PluginUpdatePolicyPanel
extends JPanel {
    private transient Map<Policy, JRadioButton> rbVersionBasedUpatePolicy;
    private transient Map<Policy, JRadioButton> rbTimeBasedUpatePolicy;
    private final JosmTextField tfUpdateInterval = new JosmTextField(5);
    private final JLabel lblUpdateInterval = new JLabel(I18n.tr("Update interval (in days):", new Object[0]));

    public PluginUpdatePolicyPanel() {
        this.build();
        this.initFromPreferences();
    }

    protected JPanel buildVersionBasedUpdatePolicyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbVersionBasedUpatePolicy = new EnumMap<Policy, JRadioButton>(Policy.class);
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("Ask before updating", new Object[0]));
        this.rbVersionBasedUpatePolicy.put(Policy.ASK, jRadioButton);
        buttonGroup.add(jRadioButton);
        jRadioButton = new JRadioButton(I18n.tr("Always update without asking", new Object[0]));
        this.rbVersionBasedUpatePolicy.put(Policy.ALWAYS, jRadioButton);
        buttonGroup.add(jRadioButton);
        jRadioButton = new JRadioButton(I18n.tr("Never update", new Object[0]));
        this.rbVersionBasedUpatePolicy.put(Policy.NEVER, jRadioButton);
        buttonGroup.add(jRadioButton);
        JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("Please decide whether JOSM shall automatically update active plugins at startup after an update of JOSM itself.", new Object[0]));
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        for (Policy policy : Policy.values()) {
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.rbVersionBasedUpatePolicy.get((Object)policy), gridBagConstraints);
        }
        return jPanel;
    }

    protected JPanel buildUpdateIntervalPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.lblUpdateInterval);
        jPanel.add(this.tfUpdateInterval);
        this.lblUpdateInterval.setLabelFor(this.tfUpdateInterval);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUpdateInterval);
        return jPanel;
    }

    protected JPanel buildTimeBasedUpdatePolicyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        TimeBasedPolicyChangeListener timeBasedPolicyChangeListener = new TimeBasedPolicyChangeListener();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbTimeBasedUpatePolicy = new EnumMap<Policy, JRadioButton>(Policy.class);
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("Ask before updating", new Object[0]));
        jRadioButton.addChangeListener(timeBasedPolicyChangeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.ASK, jRadioButton);
        buttonGroup.add(jRadioButton);
        jRadioButton = new JRadioButton(I18n.tr("Always update without asking", new Object[0]));
        jRadioButton.addChangeListener(timeBasedPolicyChangeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.ALWAYS, jRadioButton);
        buttonGroup.add(jRadioButton);
        jRadioButton = new JRadioButton(I18n.tr("Never update", new Object[0]));
        jRadioButton.addChangeListener(timeBasedPolicyChangeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.NEVER, jRadioButton);
        buttonGroup.add(jRadioButton);
        JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("Please decide whether JOSM shall automatically update active plugins after a certain period of time.", new Object[0]));
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        for (Policy policy : Policy.values()) {
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.rbTimeBasedUpatePolicy.get((Object)policy), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.buildUpdateIntervalPanel(), gridBagConstraints);
        return jPanel;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.buildVersionBasedUpdatePolicyPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buildTimeBasedUpdatePolicyPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public final void initFromPreferences() {
        this.rbVersionBasedUpatePolicy.get((Object)Optional.ofNullable(Policy.fromPreferenceValue(Main.pref.get("pluginmanager.version-based-update.policy", "ask"))).orElse(Policy.ASK)).setSelected(true);
        this.rbTimeBasedUpatePolicy.get((Object)Optional.ofNullable(Policy.fromPreferenceValue(Main.pref.get("pluginmanager.time-based-update.policy", "ask"))).orElse(Policy.ASK)).setSelected(true);
        String string = Main.pref.get("pluginmanager.warntime", null);
        int n = 0;
        if (string != null) {
            Main.pref.put("pluginmanager.warntime", null);
            try {
                n = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                Main.trace(numberFormatException);
            }
            if (n <= 0) {
                n = 30;
            }
        }
        if (n == 0) {
            n = Main.pref.getInteger("pluginmanager.time-based-update.interval", 30);
        }
        this.tfUpdateInterval.setText(Integer.toString(n));
    }

    public void rememberInPreferences() {
        for (Policy policy : Policy.values()) {
            if (!this.rbVersionBasedUpatePolicy.get((Object)policy).isSelected()) continue;
            Main.pref.put("pluginmanager.version-based-update.policy", policy.getPreferencesValue());
            break;
        }
        for (Policy policy : Policy.values()) {
            if (!this.rbTimeBasedUpatePolicy.get((Object)policy).isSelected()) continue;
            Main.pref.put("pluginmanager.time-based-update.policy", policy.getPreferencesValue());
            break;
        }
        int n = 0;
        try {
            n = Integer.parseInt(this.tfUpdateInterval.getText().trim());
            if (n <= 0) {
                n = 30;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        Main.pref.putInteger("pluginmanager.time-based-update.interval", n);
    }

    class TimeBasedPolicyChangeListener
    implements ChangeListener {
        TimeBasedPolicyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            PluginUpdatePolicyPanel.this.lblUpdateInterval.setEnabled(!((JRadioButton)PluginUpdatePolicyPanel.this.rbTimeBasedUpatePolicy.get((Object)Policy.NEVER)).isSelected());
            PluginUpdatePolicyPanel.this.tfUpdateInterval.setEnabled(!((JRadioButton)PluginUpdatePolicyPanel.this.rbTimeBasedUpatePolicy.get((Object)Policy.NEVER)).isSelected());
        }
    }

    private static enum Policy {
        ASK("ask"),
        ALWAYS("always"),
        NEVER("never");

        private final String preferenceValue;

        private Policy(String string2) {
            this.preferenceValue = string2;
        }

        public String getPreferencesValue() {
            return this.preferenceValue;
        }

        static Policy fromPreferenceValue(String string) {
            if (string == null) {
                return null;
            }
            String string2 = string.trim().toLowerCase(Locale.ENGLISH);
            for (Policy policy : Policy.values()) {
                if (!policy.getPreferencesValue().equals(string2)) continue;
                return policy;
            }
            return null;
        }
    }
}

