/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Locale;
import java.util.Optional;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Utils;

final class StreamProgressUpdater {
    private final long size;
    private final ProgressMonitor progressMonitor;
    private final String taskTitle;
    private int soFar;
    private int lastDialogUpdate;

    StreamProgressUpdater(long l, ProgressMonitor progressMonitor, String string) {
        this.size = l;
        this.progressMonitor = Optional.ofNullable(progressMonitor).orElse(NullProgressMonitor.INSTANCE);
        this.taskTitle = string;
        this.initProgressMonitor();
    }

    private void initProgressMonitor() {
        if (this.size > 0L) {
            this.progressMonitor.subTask(this.taskTitle);
            this.progressMonitor.setTicksCount((int)this.size);
        } else {
            this.progressMonitor.indeterminateSubTask(this.taskTitle);
        }
    }

    void advanceTicker(int n) {
        this.soFar += n;
        if (this.soFar / 1024 != this.lastDialogUpdate) {
            ++this.lastDialogUpdate;
            if (this.size > 0L) {
                this.progressMonitor.setTicks(this.soFar);
            }
            this.progressMonitor.setExtraText(Utils.getSizeString(this.soFar, Locale.getDefault()));
        }
    }

    void finishTask() {
        this.progressMonitor.finishTask();
    }
}

