/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.fiber.FiberQueue;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ThreadFiber
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadFiber.class);
    volatile FiberData data;
    volatile RubyThread thread;

    public ThreadFiber(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public static void initRootFiber(ThreadContext context) {
        Ruby runtime = context.runtime;
        ThreadFiber rootFiber = new ThreadFiber(runtime, runtime.getClass("Fiber"));
        rootFiber.data = new FiberData(new FiberQueue(runtime), null, rootFiber);
        rootFiber.thread = context.getThread();
        context.setRootFiber(rootFiber);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            throw runtime.newArgumentError("tried to create Proc object without block");
        }
        this.data = new FiberData(new FiberQueue(runtime), context.getFiberCurrentThread(), this);
        FiberData currentFiberData = context.getFiber().data;
        this.thread = ThreadFiber.createThread(runtime, this.data, currentFiberData.queue, block);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject resume(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime = context.runtime;
        if (this.data.prev != null || this.data.transferred) {
            throw runtime.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (this.data == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = RubyArray.newArrayMayCopy(runtime, values2);
            }
        }
        if (this.data.parent != context.getFiberCurrentThread()) {
            throw runtime.newFiberError("fiber called across threads");
        }
        this.data.prev = context.getFiber();
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, this.data, val);
            return iRubyObject;
        }
        finally {
            this.data.prev = null;
        }
    }

    private static IRubyObject exchangeWithFiber(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, IRubyObject val) {
        try {
            targetFiberData.queue.push(context, new IRubyObject[]{val});
        }
        catch (RaiseException re) {
            ThreadFiber.handleExceptionDuringExchange(context, currentFiberData, targetFiberData, re);
        }
        while (true) {
            try {
                IRubyObject result2 = currentFiberData.queue.pop(context);
                return result2 == NEVER ? context.nil : result2;
            }
            catch (RaiseException re) {
                ThreadFiber.handleExceptionDuringExchange(context, currentFiberData, targetFiberData, re);
                continue;
            }
            break;
        }
    }

    private static void handleExceptionDuringExchange(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, RaiseException re) {
        if (context.runtime.getLocalJumpError().isInstance(re.getException())) {
            throw re;
        }
        if (currentFiberData.queue.isShutdown()) {
            throw re;
        }
        if (targetFiberData.queue.isShutdown()) {
            throw re;
        }
        ThreadFiber fiber2 = (ThreadFiber)targetFiberData.fiber.get();
        if (fiber2 != null && fiber2.alive()) {
            fiber2.thread.raise(re.getException());
        } else {
            LOG.warn("no fiber thread to raise: {}", re.getException().inspect(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject __transfer__(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime = context.runtime;
        if (this.data.prev != null) {
            throw runtime.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (this.data == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return RubyArray.newArrayMayCopy(runtime, values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = RubyArray.newArrayMayCopy(runtime, values2);
            }
        }
        if (this.data.parent != context.getFiberCurrentThread()) {
            throw runtime.newFiberError("fiber called across threads");
        }
        if (currentFiberData.prev != null) {
            this.data.prev = currentFiberData.prev;
            currentFiberData.prev = null;
            currentFiberData.transferred = true;
        } else {
            this.data.prev = context.getFiber();
        }
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, this.data, val);
            return iRubyObject;
        }
        finally {
            this.data.prev = null;
            currentFiberData.transferred = false;
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2) {
        return ThreadFiber.yield(context, recv2, context.nil);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
        Ruby runtime = context.runtime;
        FiberData currentFiberData = context.getFiber().data;
        if (currentFiberData.parent == null) {
            throw runtime.newFiberError("can't yield from root fiber");
        }
        if (currentFiberData.prev == null) {
            throw runtime.newFiberError("BUG: yield occurred with null previous fiber. Report this at http://bugs.jruby.org");
        }
        if (currentFiberData.queue.isShutdown()) {
            throw runtime.newFiberError("dead fiber yielded");
        }
        FiberData prevFiberData = currentFiberData.prev.data;
        return ThreadFiber.exchangeWithFiber(context, currentFiberData, prevFiberData, value2);
    }

    @JRubyMethod
    public IRubyObject __alive__(ThreadContext context) {
        return context.runtime.newBoolean(this.alive());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __current__(ThreadContext context, IRubyObject recv2) {
        return context.getFiber();
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.thread.getContextVariables();
    }

    final boolean alive() {
        return this.thread != null && this.thread.isAlive() && !this.data.queue.isShutdown();
    }

    static RubyThread createThread(final Ruby runtime, final FiberData data2, FiberQueue queue, final Block block) {
        final AtomicReference fiberThread = new AtomicReference();
        boolean retried = true;
        try {
            runtime.getFiberExecutor().execute(new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (OutOfMemoryError oome) {
            String oomeMessage = oome.getMessage();
            if (!retried && oomeMessage != null && oomeMessage.contains("unable to create new native thread")) {
                System.gc();
                retried = true;
            }
            throw oome;
        }
        while (fiberThread.get() == null) {
            Thread.yield();
        }
        return (RubyThread)fiberThread.get();
    }

    protected void finalize() throws Throwable {
        try {
            RubyThread thread2;
            FiberData data2 = this.data;
            if (data2 != null) {
                if (data2.parent == null) {
                    return;
                }
                data2.queue.shutdown();
            }
            if ((thread2 = this.thread) != null) {
                thread2.dieFromFinalizer();
                thread2.interrupt();
                data2 = null;
                Object var2_2 = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public FiberData getData() {
        return this.data;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public static class FiberData {
        final FiberQueue queue;
        volatile ThreadFiber prev;
        final RubyThread parent;
        final WeakReference<ThreadFiber> fiber;
        volatile boolean transferred;

        FiberData(FiberQueue queue, RubyThread parent, ThreadFiber fiber2) {
            this.queue = queue;
            this.parent = parent;
            this.fiber = new WeakReference<ThreadFiber>(fiber2);
        }

        public ThreadFiber getPrev() {
            return this.prev;
        }
    }
}

