'use strict';

// Load modules

const RFC3986 = require('./rfc3986');


// Declare internals

const internals = {
    Ip: {
        cidrs: {
            required: '\\/(?:' + RFC3986.cidr + ')',
            optional: '(?:\\/(?:' + RFC3986.cidr + '))?',
            forbidden: ''
        },
        versions: {
            ipv4: RFC3986.IPv4address,
            ipv6: RFC3986.IPv6address,
            ipvfuture: RFC3986.IPvFuture
        }
    }
};


internals.Ip.createIpRegex = function (versions, cidr) {

    let regex;
    for (let i = 0; i < versions.length; ++i) {
        const version = versions[i];
        if (!regex) {
            regex = '^(?:' + internals.Ip.versions[version];
        }
        regex = regex + '|' + internals.Ip.versions[version];
    }

    return new RegExp(regex + ')' + internals.Ip.cidrs[cidr] + '$');
};

module.exports = internals.Ip;
