/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class MergingLexerAdapter
extends MergingLexerAdapterBase {
    private final TokenSet myTokenSet;
    private final MergeFunction myMergeFunction = new MyMergeFunction();

    public MergingLexerAdapter(Lexer original, TokenSet tokensToMerge) {
        super(original);
        this.myTokenSet = tokensToMerge;
    }

    @Override
    public MergeFunction getMergeFunction() {
        return this.myMergeFunction;
    }

    private class MyMergeFunction
    implements MergeFunction {
        private MyMergeFunction() {
        }

        @Override
        public IElementType merge(IElementType type2, Lexer originalLexer) {
            IElementType tokenType;
            if (!MergingLexerAdapter.this.myTokenSet.contains(type2)) {
                return type2;
            }
            while ((tokenType = originalLexer.getTokenType()) == type2) {
                originalLexer.advance();
            }
            return type2;
        }
    }
}

