/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeChangePreprocessorBase
implements PsiTreeChangePreprocessor {
    protected final PsiManager myPsiManager;

    public PsiTreeChangePreprocessorBase(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "<init>"));
        }
        this.myPsiManager = psiManager;
    }

    protected abstract boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl var1);

    protected abstract boolean isOutOfCodeBlock(@NotNull PsiElement var1);

    protected boolean isOutOfCodeBlock(@NotNull PsiFileSystemItem file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "isOutOfCodeBlock"));
        }
        return true;
    }

    private boolean outOfCodeBlock(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        if (element instanceof PsiDirectory) {
            return false;
        }
        if (element instanceof PsiFileSystemItem) {
            return this.isOutOfCodeBlock((PsiFileSystemItem)element);
        }
        return this.isOutOfCodeBlock(element);
    }

    @Override
    public final void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "treeChanged"));
        }
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        if (!this.acceptsEvent(event)) {
            return;
        }
        this.onTreeChanged(event);
    }

    protected void onTreeChanged(@NotNull PsiTreeChangeEventImpl event) {
        boolean outOfCodeBlock;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "onTreeChanged"));
        }
        switch (event.getCode()) {
            case BEFORE_PROPERTY_CHANGE: 
            case BEFORE_CHILD_MOVEMENT: 
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: 
            case BEFORE_CHILD_REPLACEMENT: {
                outOfCodeBlock = false;
                break;
            }
            case BEFORE_CHILDREN_CHANGE: 
            case CHILDREN_CHANGED: {
                if (event.isGenericChange()) {
                    return;
                }
                outOfCodeBlock = this.outOfCodeBlock(event.getParent());
                break;
            }
            case CHILD_ADDED: 
            case CHILD_REMOVED: 
            case CHILD_REPLACED: {
                outOfCodeBlock = this.outOfCodeBlock(event.getParent()) || this.outOfCodeBlock(event.getChild()) || this.outOfCodeBlock(event.getOldChild()) || this.outOfCodeBlock(event.getNewChild());
                break;
            }
            case PROPERTY_CHANGED: {
                outOfCodeBlock = true;
                break;
            }
            case CHILD_MOVED: {
                outOfCodeBlock = this.outOfCodeBlock(event.getOldParent()) || this.outOfCodeBlock(event.getNewParent()) || this.outOfCodeBlock(event.getChild());
                break;
            }
            default: {
                outOfCodeBlock = true;
            }
        }
        if (outOfCodeBlock) {
            this.onOutOfCodeBlockModification(event);
            this.doIncOutOfCodeBlockCounter();
        }
    }

    protected void onOutOfCodeBlockModification(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "onOutOfCodeBlockModification"));
        }
    }

    protected void doIncOutOfCodeBlockCounter() {
        ((PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker()).incOutOfCodeBlockModificationCounter();
    }
}

