/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.storage.HeavyProcessLatch");
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet<String>();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final EventDispatcher<HeavyProcessListener> myUIProcessDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final List<Runnable> toExecuteOutOfHeavyActivity = new ArrayList<Runnable>();

    private HeavyProcessLatch() {
    }

    public void addUIActivityListener(@NotNull HeavyProcessListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/io/storage/HeavyProcessLatch", "addUIActivityListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/io/storage/HeavyProcessLatch", "addUIActivityListener"));
        }
        this.myUIProcessDispatcher.addListener(listener, parentDisposable);
    }

    public static interface HeavyProcessListener
    extends EventListener {
    }
}

