/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;

public class ScriptContext
extends ClassContext {
    private final ScriptDescriptor scriptDescriptor;
    private final List<ScriptDescriptor> earlierScripts;
    private final KtExpression lastStatement;

    public ScriptContext(@NotNull KotlinTypeMapper typeMapper, @NotNull ScriptDescriptor scriptDescriptor, @NotNull List<ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor contextDescriptor, @Nullable CodegenContext parentContext) {
        if (typeMapper == null) {
            ScriptContext.$$$reportNull$$$0(0);
        }
        if (scriptDescriptor == null) {
            ScriptContext.$$$reportNull$$$0(1);
        }
        if (earlierScripts == null) {
            ScriptContext.$$$reportNull$$$0(2);
        }
        if (contextDescriptor == null) {
            ScriptContext.$$$reportNull$$$0(3);
        }
        super(typeMapper, contextDescriptor, OwnerKind.IMPLEMENTATION, parentContext, null);
        this.scriptDescriptor = scriptDescriptor;
        this.earlierScripts = earlierScripts;
        KtScript script = (KtScript)DescriptorToSourceUtils.getSourceFromDescriptor(scriptDescriptor);
        assert (script != null) : "Declaration should be present for script: " + scriptDescriptor;
        KtDeclaration lastDeclaration = CollectionsKt.lastOrNull(script.getDeclarations());
        this.lastStatement = lastDeclaration instanceof KtAnonymousInitializer ? ((KtAnonymousInitializer)lastDeclaration).getBody() : null;
    }

    @NotNull
    public ScriptDescriptor getScriptDescriptor() {
        ScriptDescriptor scriptDescriptor = this.scriptDescriptor;
        if (scriptDescriptor == null) {
            ScriptContext.$$$reportNull$$$0(4);
        }
        return scriptDescriptor;
    }

    @NotNull
    public FieldInfo getResultFieldInfo() {
        assert (this.getState().getReplSpecific().getShouldGenerateScriptResultValue()) : "Should not be called unless 'scriptResultFieldName' is set";
        GenerationState state2 = this.getState();
        String scriptResultFieldName = state2.getReplSpecific().getScriptResultFieldName();
        assert (scriptResultFieldName != null);
        FieldInfo fieldInfo = FieldInfo.createForHiddenField(state2.getTypeMapper().mapClass(this.scriptDescriptor), AsmTypes.OBJECT_TYPE, scriptResultFieldName);
        if (fieldInfo == null) {
            ScriptContext.$$$reportNull$$$0(5);
        }
        return fieldInfo;
    }

    @NotNull
    public List<ScriptDescriptor> getEarlierScripts() {
        List<ScriptDescriptor> list2 = this.earlierScripts;
        if (list2 == null) {
            ScriptContext.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        int index2;
        if (scriptDescriptor == null) {
            ScriptContext.$$$reportNull$$$0(7);
        }
        if ((index2 = this.earlierScripts.indexOf(scriptDescriptor)) < 0) {
            throw new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        String string = "script$" + (index2 + 1);
        if (string == null) {
            ScriptContext.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public KtExpression getLastStatement() {
        return this.lastStatement;
    }

    @Override
    public String toString() {
        return "Script: " + ((ClassDescriptor)this.getContextDescriptor()).getName().asString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earlierScripts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/context/ScriptContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/context/ScriptContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultFieldInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEarlierScripts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFieldName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

