/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.CompareToTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class BinaryOperationTranslator
extends AbstractTranslator {
    @NotNull
    private final KtBinaryExpression expression;
    @NotNull
    private final KtExpression leftKtExpression;
    @NotNull
    private final KtExpression rightKtExpression;
    @NotNull
    private final KtToken operationToken;
    @Nullable
    private final CallableDescriptor operationDescriptor;

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(1);
        }
        JsExpression jsExpression = new BinaryOperationTranslator(expression2, context).translate();
        JsExpression jsExpression2 = jsExpression.source(expression2);
        if (jsExpression2 == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(2);
        }
        return jsExpression2;
    }

    @NotNull
    static JsExpression translateAsOverloadedCall(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(4);
        }
        JsExpression jsExpression = new BinaryOperationTranslator(expression2, context).translateAsOverloadedBinaryOperation();
        JsExpression jsExpression2 = jsExpression.source(expression2);
        if (jsExpression2 == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(5);
        }
        return jsExpression2;
    }

    private BinaryOperationTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(6);
        }
        if (context == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(7);
        }
        super(context);
        this.expression = expression2;
        assert (expression2.getLeft() != null) : "Binary expression should have a left expression: " + expression2.getText();
        this.leftKtExpression = expression2.getLeft();
        assert (expression2.getRight() != null) : "Binary expression should have a right expression: " + expression2.getText();
        this.rightKtExpression = expression2.getRight();
        this.operationToken = PsiUtils.getOperationToken(expression2);
        this.operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(this.bindingContext(), expression2);
    }

    @NotNull
    private JsExpression translate() {
        BinaryOperationIntrinsic intrinsic = this.getIntrinsicForExpression();
        if (intrinsic.exists()) {
            JsExpression jsExpression = this.applyIntrinsic(intrinsic);
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(8);
            }
            return jsExpression;
        }
        if (this.operationToken == KtTokens.ELVIS) {
            JsExpression jsExpression = this.translateElvis();
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(9);
            }
            return jsExpression;
        }
        if (AssignmentTranslator.isAssignmentOperator(this.operationToken)) {
            JsExpression jsExpression = AssignmentTranslator.translate(this.expression, this.context());
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(10);
            }
            return jsExpression;
        }
        if (this.isNotOverloadable()) {
            JsExpression jsExpression = this.translateAsUnOverloadableBinaryOperation();
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(11);
            }
            return jsExpression;
        }
        if (CompareToTranslator.isCompareToCall(this.operationToken, this.operationDescriptor)) {
            JsExpression jsExpression = CompareToTranslator.translate(this.expression, this.context());
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(12);
            }
            return jsExpression;
        }
        if (this.isEquals()) {
            JsExpression jsExpression = this.translateEquals();
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(13);
            }
            return jsExpression;
        }
        assert (this.operationDescriptor != null) : "Overloadable operations must have not null descriptor";
        JsExpression jsExpression = this.translateAsOverloadedBinaryOperation();
        if (jsExpression == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(14);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateElvis() {
        JsIf ifStatement;
        JsExpression result2;
        KotlinType expressionType = this.context().bindingContext().getType(this.expression);
        JsExpression leftExpression = TranslationUtils.boxCastIfNeeded(Translation.translateAsExpression(this.leftKtExpression, this.context()), this.context().bindingContext().getType(this.leftKtExpression), expressionType);
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = TranslationUtils.boxCastIfNeeded(Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock), this.context().bindingContext().getType(this.rightKtExpression), expressionType);
        if (rightBlock.isEmpty()) {
            JsConditional jsConditional = TranslationUtils.notNullConditional(leftExpression, rightExpression, this.context());
            if (jsConditional == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(15);
            }
            return jsConditional;
        }
        if (BindingContextUtilsKt.isUsedAsExpression(this.expression, this.context().bindingContext())) {
            result2 = this.context().cacheExpressionIfNeeded(leftExpression);
            JsBinaryOperation testExpression = TranslationUtils.isNullCheck(result2);
            rightBlock.getStatements().add(JsAstUtils.assignment(result2, rightExpression).makeStmt());
            ifStatement = JsAstUtils.newJsIf(testExpression, rightBlock);
        } else {
            result2 = JsLiteral.NULL;
            JsBinaryOperation testExpression = TranslationUtils.isNullCheck(leftExpression);
            ifStatement = JsAstUtils.newJsIf(testExpression, rightBlock);
        }
        this.context().addStatementToCurrentBlock(ifStatement);
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(16);
        }
        return jsExpression;
    }

    @NotNull
    private BinaryOperationIntrinsic getIntrinsicForExpression() {
        BinaryOperationIntrinsic binaryOperationIntrinsic = this.context().intrinsics().getBinaryOperationIntrinsic(this.expression, this.context());
        if (binaryOperationIntrinsic == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(17);
        }
        return binaryOperationIntrinsic;
    }

    @NotNull
    private JsExpression applyIntrinsic(@NotNull BinaryOperationIntrinsic intrinsic) {
        if (intrinsic == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(18);
        }
        JsExpression leftExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock);
        if (rightBlock.isEmpty()) {
            JsExpression jsExpression = intrinsic.apply(this.expression, leftExpression, rightExpression, this.context());
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(19);
            }
            return jsExpression;
        }
        leftExpression = this.context().cacheExpressionIfNeeded(leftExpression);
        this.context().addStatementsToCurrentBlockFrom(rightBlock);
        JsExpression jsExpression = intrinsic.apply(this.expression, leftExpression, rightExpression, this.context());
        if (jsExpression == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(20);
        }
        return jsExpression;
    }

    private boolean isNotOverloadable() {
        return OperatorConventions.NOT_OVERLOADABLE.contains(this.operationToken);
    }

    @NotNull
    private JsExpression translateAsUnOverloadableBinaryOperation() {
        JsIf ifStatement;
        JsExpression result2;
        assert (OperatorConventions.NOT_OVERLOADABLE.contains(this.operationToken));
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(this.operationToken);
        JsExpression leftExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock);
        if (rightBlock.isEmpty()) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, leftExpression, rightExpression);
            if (jsBinaryOperation == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(21);
            }
            return jsBinaryOperation;
        }
        if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains(this.operationToken)) {
            this.context().addStatementsToCurrentBlockFrom(rightBlock);
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, leftExpression, rightExpression);
            if (jsBinaryOperation == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(22);
            }
            return jsBinaryOperation;
        }
        assert (this.operationToken.equals(KtTokens.ANDAND) || this.operationToken.equals(KtTokens.OROR)) : "Unsupported binary operation: " + this.expression.getText();
        boolean isOror = this.operationToken.equals(KtTokens.OROR);
        JsLiteral.JsBooleanLiteral literalResult = isOror ? JsLiteral.TRUE : JsLiteral.FALSE;
        JsExpression jsExpression = leftExpression = isOror ? JsAstUtils.not(leftExpression) : leftExpression;
        if (BindingContextUtilsKt.isUsedAsExpression(this.expression, this.context().bindingContext())) {
            if (rightExpression instanceof JsNameRef) {
                result2 = rightExpression;
            } else {
                result2 = this.context().declareTemporary(null).reference();
                rightBlock.getStatements().add(JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(result2, rightExpression)));
            }
            JsStatement assignmentStatement = JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(result2, literalResult));
            ifStatement = JsAstUtils.newJsIf(leftExpression, rightBlock, assignmentStatement);
            MetadataProperties.setSynthetic(ifStatement, true);
        } else {
            ifStatement = JsAstUtils.newJsIf(leftExpression, rightBlock);
            result2 = JsLiteral.NULL;
        }
        this.context().addStatementToCurrentBlock(ifStatement);
        JsExpression jsExpression2 = result2;
        if (jsExpression2 == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(23);
        }
        return jsExpression2;
    }

    private boolean isEquals() {
        return this.operationToken == KtTokens.EQEQ || this.operationToken == KtTokens.EXCLEQ;
    }

    private JsExpression translateEquals() {
        JsExpression left = Translation.translateAsExpression(this.leftKtExpression, this.context());
        JsExpression right = Translation.translateAsExpression(this.rightKtExpression, this.context());
        if (left == JsLiteral.NULL || right == JsLiteral.NULL) {
            JsBinaryOperator operator = this.operationToken == KtTokens.EXCLEQ ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
            return new JsBinaryOperation(operator, left, right);
        }
        KotlinType leftType = this.context().bindingContext().getType(this.leftKtExpression);
        KotlinType rightType = this.context().bindingContext().getType(this.rightKtExpression);
        if (leftType != null && TypeUtils.isNullableType(leftType) || rightType != null && TypeUtils.isNullableType(rightType)) {
            return this.mayBeWrapWithNegation(TopLevelFIF.KOTLIN_EQUALS.apply(left, Collections.singletonList(right), this.context()));
        }
        return this.translateAsOverloadedBinaryOperation();
    }

    @NotNull
    private JsExpression translateAsOverloadedBinaryOperation() {
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(this.expression, this.bindingContext());
        JsExpression result2 = CallTranslator.translate(this.context(), resolvedCall2, this.getReceiver());
        JsExpression jsExpression = this.mayBeWrapWithNegation(result2);
        if (jsExpression == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(24);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression getReceiver() {
        if (PsiUtils.isInOrNotInOperation(this.expression)) {
            JsExpression jsExpression = Translation.translateAsExpression(this.rightKtExpression, this.context());
            if (jsExpression == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(25);
            }
            return jsExpression;
        }
        JsExpression jsExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        if (jsExpression == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(26);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression mayBeWrapWithNegation(@NotNull JsExpression result2) {
        if (result2 == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(27);
        }
        if (PsiUtils.isNegatedOperation(this.expression)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(result2);
            if (jsPrefixOperation == null) {
                BinaryOperationTranslator.$$$reportNull$$$0(28);
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            BinaryOperationTranslator.$$$reportNull$$$0(29);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intrinsic";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsOverloadedCall";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "translateElvis";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrinsicForExpression";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "applyIntrinsic";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsUnOverloadableBinaryOperation";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsOverloadedBinaryOperation";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiver";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "mayBeWrapWithNegation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "translateAsOverloadedCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyIntrinsic";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mayBeWrapWithNegation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

