/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CompanionObjectIntrinsicAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class ReferenceTranslator {
    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(1);
        }
        JsExpression jsExpression = ReferenceTranslator.getAccessTranslator(expression2, context).translateAsGet();
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(2);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsValueReference(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(4);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            JsNameRef jsNameRef = context.getInnerReference(descriptor2);
            if (jsNameRef == null) {
                ReferenceTranslator.$$$reportNull$$$0(5);
            }
            return jsNameRef;
        }
        JsExpression alias = context.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(6);
            }
            return jsExpression;
        }
        if (ReferenceTranslator.shouldTranslateAsFQN(descriptor2, context)) {
            JsNameRef jsNameRef = context.getQualifiedReference(descriptor2);
            if (jsNameRef == null) {
                ReferenceTranslator.$$$reportNull$$$0(7);
            }
            return jsNameRef;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor property = (PropertyDescriptor)descriptor2;
            if (context.isFromCurrentModule(property)) {
                JsNameRef jsNameRef = context.getInnerReference(property);
                if (jsNameRef == null) {
                    ReferenceTranslator.$$$reportNull$$$0(8);
                }
                return jsNameRef;
            }
            JsNameRef qualifier = context.getInnerReference(property.getContainingDeclaration());
            JsName name = context.getNameForDescriptor(property);
            JsNameRef jsNameRef = new JsNameRef(name, (JsExpression)qualifier);
            if (jsNameRef == null) {
                ReferenceTranslator.$$$reportNull$$$0(9);
            }
            return jsNameRef;
        }
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            if (!context.isFromCurrentModule(descriptor2)) {
                JsExpression jsExpression = ReferenceTranslator.getLazyReferenceToObject((ClassDescriptor)descriptor2, context);
                if (jsExpression == null) {
                    ReferenceTranslator.$$$reportNull$$$0(10);
                }
                return jsExpression;
            }
            JsNameRef functionRef = JsAstUtils.pureFqn(context.getNameForObjectInstance((ClassDescriptor)descriptor2), null);
            JsInvocation jsInvocation = new JsInvocation((JsExpression)functionRef, new JsExpression[0]);
            if (jsInvocation == null) {
                ReferenceTranslator.$$$reportNull$$$0(11);
            }
            return jsInvocation;
        }
        JsNameRef jsNameRef = context.getInnerReference(descriptor2);
        if (jsNameRef == null) {
            ReferenceTranslator.$$$reportNull$$$0(12);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression translateAsTypeReference(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(14);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            JsNameRef jsNameRef = context.getInnerReference(descriptor2);
            if (jsNameRef == null) {
                ReferenceTranslator.$$$reportNull$$$0(15);
            }
            return jsNameRef;
        }
        if (!ReferenceTranslator.shouldTranslateAsFQN(descriptor2, context)) {
            if ((DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) && !context.isFromCurrentModule(descriptor2)) {
                JsExpression jsExpression = ReferenceTranslator.getPrototypeIfNecessary(descriptor2, ReferenceTranslator.getLazyReferenceToObject(descriptor2, context));
                if (jsExpression == null) {
                    ReferenceTranslator.$$$reportNull$$$0(16);
                }
                return jsExpression;
            }
            JsNameRef jsNameRef = context.getInnerReference(descriptor2);
            if (jsNameRef == null) {
                ReferenceTranslator.$$$reportNull$$$0(17);
            }
            return jsNameRef;
        }
        JsExpression jsExpression = ReferenceTranslator.getPrototypeIfNecessary(descriptor2, context.getQualifiedReference(descriptor2));
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(18);
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression getPrototypeIfNecessary(@NotNull ClassDescriptor descriptor2, @NotNull JsExpression reference) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(19);
        }
        if (reference == null) {
            ReferenceTranslator.$$$reportNull$$$0(20);
        }
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            JsNameRef getPrototypeRef = JsAstUtils.pureFqn("getPrototypeOf", (JsExpression)JsAstUtils.pureFqn("Object", null));
            JsInvocation getPrototypeInvocation = new JsInvocation((JsExpression)getPrototypeRef, reference);
            MetadataProperties.setSideEffects(getPrototypeInvocation, SideEffectKind.PURE);
            reference = JsAstUtils.pureFqn("constructor", (JsExpression)getPrototypeInvocation);
        }
        JsExpression jsExpression = reference;
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(21);
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression getLazyReferenceToObject(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(22);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(23);
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        JsNameRef qualifier = context.getInnerReference(container2);
        JsNameRef jsNameRef = new JsNameRef(context.getNameForDescriptor(descriptor2), (JsExpression)qualifier);
        if (jsNameRef == null) {
            ReferenceTranslator.$$$reportNull$$$0(24);
        }
        return jsNameRef;
    }

    private static boolean shouldTranslateAsFQN(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(25);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(26);
        }
        return ReferenceTranslator.isLocalVarOrFunction(descriptor2) || context.isPublicInlineFunction();
    }

    private static boolean isLocalVarOrFunction(DeclarationDescriptor descriptor2) {
        return descriptor2.getContainingDeclaration() instanceof FunctionDescriptor && !(descriptor2 instanceof ClassDescriptor);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(27);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(28);
        }
        if (KtPsiUtil.isBackingFieldReference(BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression))) {
            BackingFieldAccessTranslator backingFieldAccessTranslator = BackingFieldAccessTranslator.newInstance(referenceExpression, context);
            if (backingFieldAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(29);
            }
            return backingFieldAccessTranslator;
        }
        if (ReferenceTranslator.canBePropertyAccess(referenceExpression, context)) {
            VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context, referenceExpression, null);
            if (variableAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(30);
            }
            return variableAccessTranslator;
        }
        if (CompanionObjectIntrinsicAccessTranslator.isCompanionObjectReference(referenceExpression, context)) {
            CompanionObjectIntrinsicAccessTranslator companionObjectIntrinsicAccessTranslator = CompanionObjectIntrinsicAccessTranslator.newInstance(referenceExpression, context);
            if (companionObjectIntrinsicAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(31);
            }
            return companionObjectIntrinsicAccessTranslator;
        }
        ReferenceAccessTranslator referenceAccessTranslator = ReferenceAccessTranslator.newInstance(referenceExpression, context);
        if (referenceAccessTranslator == null) {
            ReferenceTranslator.$$$reportNull$$$0(32);
        }
        return referenceAccessTranslator;
    }

    public static boolean canBePropertyAccess(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(33);
        }
        if (context == null) {
            ReferenceTranslator.$$$reportNull$$$0(34);
        }
        KtSimpleNameExpression simpleNameExpression = null;
        if (expression2 instanceof KtQualifiedExpression) {
            simpleNameExpression = PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression2);
        } else if (expression2 instanceof KtSimpleNameExpression) {
            simpleNameExpression = (KtSimpleNameExpression)expression2;
        }
        if (simpleNameExpression == null) {
            return false;
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), simpleNameExpression);
        return descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof ValueParameterDescriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 14: 
            case 23: 
            case 26: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "translateSimpleName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsValueReference";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsTypeReference";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrototypeIfNecessary";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyReferenceToObject";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translateSimpleName";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "translateAsValueReference";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "translateAsTypeReference";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPrototypeIfNecessary";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLazyReferenceToObject";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldTranslateAsFQN";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "canBePropertyAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

