/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.build.JvmBuildMetaInfo;
import org.jetbrains.kotlin.build.JvmBuildMetaInfoKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.junit.Assert;
import org.junit.Test;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/build/JvmBuildMetaInfoTest;", "Ljunit/framework/TestCase;", "()V", "testEquals", "", "testSerialization", "testSerializationDeserialization", "kotlin-build-common"})
public final class JvmBuildMetaInfoTest
extends TestCase {
    /*
     * WARNING - void declaration
     */
    @Test
    public final void testSerialization() {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        K2JVMCompilerArguments args = new K2JVMCompilerArguments();
        JvmBuildMetaInfo info = JvmBuildMetaInfoKt.JvmBuildMetaInfo((CommonCompilerArguments)((CommonCompilerArguments)args));
        String actual = JvmBuildMetaInfo.Companion.serializeToString(info);
        List expectedKeys = CollectionsKt.listOf((Object[])new String[]{"apiVersionString", "bytecodeVersionMajor", "bytecodeVersionMinor", "bytecodeVersionPatch", "compilerBuildVersion", "coroutinesEnable", "coroutinesError", "coroutinesVersion", "coroutinesWarn", "isEAP", "languageVersionString", "metadataVersionMajor", "metadataVersionMinor", "metadataVersionPatch", "multiplatformEnable", "multiplatformVersion", "ownVersion"});
        Iterable iterable = StringsKt.split$default((CharSequence)actual, (String[])new String[]{"\r\n", "\n"}, (boolean)false, (int)0, (int)6, null);
        List list = expectedKeys;
        void var7_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void line;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)((CharSequence)line), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null));
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        TestCase.assertEquals((Object)list, (Object)collection);
    }

    @Test
    public final void testSerializationDeserialization() {
        K2JVMCompilerArguments args = new K2JVMCompilerArguments();
        JvmBuildMetaInfo info = JvmBuildMetaInfoKt.JvmBuildMetaInfo((CommonCompilerArguments)((CommonCompilerArguments)args));
        String serialized = JvmBuildMetaInfo.Companion.serializeToString(info);
        JvmBuildMetaInfo deserialized = JvmBuildMetaInfo.Companion.deserializeFromString(serialized);
        TestCase.assertEquals((Object)info, (Object)deserialized);
    }

    @Test
    public final void testEquals() {
        K2JVMCompilerArguments args1 = new K2JVMCompilerArguments();
        args1.coroutinesState = "enable";
        JvmBuildMetaInfo info1 = JvmBuildMetaInfoKt.JvmBuildMetaInfo((CommonCompilerArguments)((CommonCompilerArguments)args1));
        K2JVMCompilerArguments args2 = new K2JVMCompilerArguments();
        args2.coroutinesState = "warn";
        JvmBuildMetaInfo info2 = JvmBuildMetaInfoKt.JvmBuildMetaInfo((CommonCompilerArguments)((CommonCompilerArguments)args2));
        Assert.assertNotEquals((Object)info1, (Object)info2);
        TestCase.assertEquals((Object)info1, (Object)JvmBuildMetaInfo.copy$default((JvmBuildMetaInfo)info2, (boolean)false, null, null, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)131023, null));
    }
}

