/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class GosenKatakanaStemFilter
extends TokenFilter {
    static final char COMBINING_KATAKANA_HIRAGANA_VOICED_SOUND_MARK = '\u3099';
    static final char COMBINING_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK = '\u309a';
    static final char KATAKANA_HIRAGANA_VOICED_SOUND_MARK = '\u309b';
    static final char KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK = '\u309c';
    static final char KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK = '\u30fc';
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

    public GosenKatakanaStemFilter(TokenStream in) {
        super(in);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAtt.isKeyword()) {
                char[] buffer = this.termAtt.buffer();
                int length = this.termAtt.length();
                if (length > 3 && buffer[length - 1] == '\u30fc' && this.isKatakanaString(buffer, length)) {
                    this.termAtt.setLength(length - 1);
                }
            }
            return true;
        }
        return false;
    }

    boolean isKatakanaString(char[] s, int length) {
        for (int i = 0; i < length; ++i) {
            char c = s[i];
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.KATAKANA || c == '\u3099' || c == '\u309a' || c == '\u309b' || c == '\u309c') continue;
            return false;
        }
        return true;
    }
}

