/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.array;

import edu.berkeley.nlp.lm.array.LongArray;
import java.io.Serializable;

public final class CustomWidthArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LOG2_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int WORD_MASK = 63;
    private long size;
    private final int keyWidth;
    private final int fullWidth;
    final long widthDiff;
    private final LongArray data;

    public int getKeyWidth() {
        return this.keyWidth;
    }

    private static final long numLongs(long size) {
        return size + 63L >>> 6;
    }

    private static final long word(long index) {
        return index >>> 6;
    }

    private static final long bit(long index) {
        return index & 0x3FL;
    }

    private static final long mask(long index) {
        return 1L << (int)(index & 0x3FL);
    }

    public CustomWidthArray(long numWords, int keyWidth) {
        this(numWords, keyWidth, keyWidth);
    }

    public CustomWidthArray(long numWords, int keyWidth, int fullWidth) {
        assert (keyWidth > 0);
        assert (fullWidth > 0);
        this.keyWidth = keyWidth;
        this.fullWidth = fullWidth;
        this.widthDiff = 64 - keyWidth;
        long numBits = numWords * (long)fullWidth;
        this.data = new LongArray(CustomWidthArray.numLongs(numBits));
        this.size = 0L;
    }

    private long length() {
        return this.size;
    }

    public void ensureCapacity(long numWords) {
        long numBits = numWords * (long)this.fullWidth;
        long numLongs = CustomWidthArray.numLongs(numBits);
        this.data.ensureCapacity(numLongs);
        if (numLongs > this.data.size()) {
            this.data.setAndGrowIfNeeded(numLongs - 1L, 0L);
        }
    }

    public void trim() {
        this.trimToSize(this.size);
    }

    public void trimToSize(long sizeHere) {
        long numBits = sizeHere * (long)this.fullWidth;
        this.data.trimToSize(CustomWidthArray.numLongs(numBits));
    }

    private void rangeCheck(long index) {
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than length (" + this.length() + ")");
        }
    }

    public boolean getBit(long index) {
        this.rangeCheck(index);
        return (this.data.get(CustomWidthArray.word(index)) & CustomWidthArray.mask(index)) != 0L;
    }

    public void clear(long index) {
        this.rangeCheck(index);
        this.data.set(CustomWidthArray.word(index), this.data.get(CustomWidthArray.word(index)) & (CustomWidthArray.mask(index) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private long getLong(long from, long l) {
        if (l == 64L) {
            return 0L;
        }
        long startWord = CustomWidthArray.word(from);
        long startBit = CustomWidthArray.bit(from);
        if (startBit <= l) {
            return this.data.get(startWord) << (int)(l - startBit) >>> (int)l;
        }
        return this.data.get(startWord) >>> (int)startBit | this.data.get(startWord + 1L) << (int)(64L + l - startBit) >>> (int)l;
    }

    public boolean add(long value) {
        return this.addHelp(value, true);
    }

    public boolean addWithFixedCapacity(long value) {
        return this.addHelp(value, false);
    }

    private boolean addHelp(long value, boolean growCapacity) {
        assert (this.fullWidth == this.keyWidth);
        long length = this.size * (long)this.fullWidth;
        long startWord = CustomWidthArray.word(length);
        long startBit = CustomWidthArray.bit(length);
        if (growCapacity) {
            this.ensureCapacity(this.size + 1L);
        }
        if (startBit + (long)this.keyWidth <= 64L) {
            this.data.set(startWord, this.data.get(startWord) | value << (int)startBit);
        } else {
            this.data.set(startWord, this.data.get(startWord) | value << (int)startBit);
            this.data.set(startWord + 1L, value >>> (int)(64L - startBit));
        }
        ++this.size;
        return true;
    }

    public long get(long index) {
        return this.getHelp(index, 0, this.keyWidth);
    }

    public long get(long index, int offset, int width) {
        return this.getHelp(index, offset, width);
    }

    private long getHelp(long index, int offset, int width) {
        long start = index * (long)this.fullWidth + (long)offset;
        return this.getLong(start, 64 - width);
    }

    public static int numBitsNeeded(long n) {
        if (n == 0L) {
            return 1;
        }
        if (Long.bitCount(n) == 1) {
            return Long.numberOfTrailingZeros(n) + 1;
        }
        return 64 - Long.numberOfLeadingZeros(n - 1L);
    }

    public void set(long index, long value) {
        this.rangeCheck(index);
        boolean offset = false;
        int width = this.keyWidth;
        this.setHelp(index, value, 0, width);
    }

    public void set(long index, long value, int offset, int width) {
        this.rangeCheck(index);
        this.setHelp(index, value, offset, width);
    }

    private void setHelp(long index, long value, int offset, int width) {
        long fullMask;
        assert (CustomWidthArray.numBitsNeeded(value) <= width) : "Value " + value + " bits " + width;
        long start = index * (long)this.fullWidth + (long)offset;
        long startWord = CustomWidthArray.word(start);
        long endWord = CustomWidthArray.word(start + (long)width - 1L);
        long startBit = CustomWidthArray.bit(start);
        long l = fullMask = width == 64 ? -1L : (1L << width) - 1L;
        if (startWord == endWord) {
            long startWordLong = this.data.get(startWord);
            startWordLong &= fullMask << (int)startBit ^ 0xFFFFFFFFFFFFFFFFL;
            this.data.set(startWord, startWordLong |= value << (int)startBit);
            assert (value == (startWordLong >>> (int)startBit & fullMask)) : startWord + " " + startBit + " " + value;
        } else {
            long startWordLong = this.data.get(startWord);
            startWordLong &= (1L << (int)startBit) - 1L;
            this.data.set(startWord, startWordLong |= value << (int)startBit);
            long endWordLong = this.data.get(endWord);
            endWordLong &= -(1L << (int)((long)(width - 64) + startBit));
            this.data.set(endWord, endWordLong |= value >>> (int)(64L - startBit));
            assert (value == (startWordLong >>> (int)startBit | endWordLong << (int)(64L - startBit) & fullMask));
        }
    }

    public void setAndGrowIfNeeded(long pos, long value) {
        if (pos >= this.size) {
            this.ensureCapacity(pos + 2L);
            this.size = pos + 1L;
        }
        this.set(pos, value);
    }

    public void setAndGrowIfNeeded(long pos, long value, int offset, int width) {
        if (pos >= this.size) {
            this.ensureCapacity(pos + 2L);
            this.size = pos + 1L;
        }
        this.set(pos, value, offset, width);
    }

    public long size() {
        return this.length();
    }

    public void fill(long l, long n) {
        long numBits = n * (long)this.fullWidth;
        long numLongs = CustomWidthArray.numLongs(numBits);
        this.data.fill(l, numLongs);
        this.size = Math.max(n, this.size);
    }

    public long linearSearch(long key, long rangeStart, long rangeEnd, long startIndex, long emptyKey, boolean returnFirstEmptyIndex) {
        long searchKey;
        long i;
        for (i = startIndex; i < rangeEnd; ++i) {
            searchKey = this.getHelp(i, 0, this.keyWidth);
            if (searchKey == key) {
                return i;
            }
            if (searchKey != emptyKey) continue;
            return returnFirstEmptyIndex ? i : -1L;
        }
        for (i = rangeStart; i < startIndex; ++i) {
            searchKey = this.getHelp(i, 0, this.keyWidth);
            if (searchKey == key) {
                return i;
            }
            if (searchKey != emptyKey) continue;
            return returnFirstEmptyIndex ? i : -1L;
        }
        return -1L;
    }

    public void incrementCount(long index, long count) {
        if (index >= this.size()) {
            this.setAndGrowIfNeeded(index, count);
        } else {
            long curr = this.get(index);
            this.set(index, curr + count);
        }
    }

    public int getFullWidth() {
        return this.fullWidth;
    }
}

