/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractISBNCheckFilter
extends RuleFilter {
    protected abstract String getLengthMessage(int var1);

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, AnalyzedTokenReadings[] patternTokens) {
        boolean valid;
        String isbn = this.getRequired("isbn", args);
        String cleanIsbn = isbn.replace("-", "");
        if (cleanIsbn.length() == 10) {
            valid = this.validISBN10(cleanIsbn);
        } else if (cleanIsbn.length() == 13) {
            valid = this.validISBN13(cleanIsbn);
        } else {
            return new RuleMatch(match.getRule(), match.getFromPos(), match.getToPos(), this.getLengthMessage(cleanIsbn.length()), match.getShortMessage());
        }
        if (!valid) {
            return match;
        }
        return null;
    }

    boolean validISBN10(String cleanIsbn) {
        int sum = 0;
        for (int i = 0; i <= 9; ++i) {
            sum += (i + 1) * Integer.parseInt(String.valueOf(cleanIsbn.charAt(i)));
        }
        return sum % 11 == 0;
    }

    boolean validISBN13(String cleanIsbn) {
        int sum1 = 0;
        for (int i = 0; i <= 12; i += 2) {
            sum1 += Integer.parseInt(String.valueOf(cleanIsbn.charAt(i)));
        }
        int sum2 = 0;
        for (int i = 1; i <= 11; i += 2) {
            sum2 += Integer.parseInt(String.valueOf(cleanIsbn.charAt(i)));
        }
        return (sum1 + 3 * sum2) % 10 == 0;
    }

    private String getRequired(String key, Map<String, String> map) {
        String result = map.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Missing key '" + key + "'");
        }
        return result;
    }
}

