/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.api.ComplexOption;
import writer2latex.base.BooleanOption;
import writer2latex.base.ConfigBase;
import writer2latex.base.IntegerOption;
import writer2latex.base.Option;
import writer2latex.latex.ContentHandlingOption;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.i18n.ReplacementTrie;
import writer2latex.latex.util.HeadingMap;
import writer2latex.latex.util.StyleMap;
import writer2latex.util.Misc;

public class LaTeXConfig
extends ConfigBase {
    public static final int GENERIC = 0;
    public static final int DVIPS = 1;
    public static final int PDFTEX = 2;
    public static final int UNSPECIFIED = 3;
    public static final int XETEX = 4;
    public static final int IGNORE_ALL = 0;
    public static final int IGNORE_MOST = 1;
    public static final int CONVERT_BASIC = 2;
    public static final int CONVERT_MOST = 3;
    public static final int CONVERT_ALL = 4;
    public static final int CONVERT_HEADER_FOOTER = 5;
    public static final int CONVERT_GEOMETRY = 6;
    public static final int IGNORE = 0;
    public static final int ACCEPT = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int COMMENT = 1;
    public static final int PDFANNOTATION = 2;
    public static final int MARGINPAR = 3;
    public static final int CUSTOM = 4;
    private static final int BACKEND = 0;
    private static final int NO_PREAMBLE = 1;
    private static final int NO_INDEX = 2;
    private static final int DOCUMENTCLASS = 3;
    private static final int GLOBAL_OPTIONS = 4;
    private static final int INPUTENCODING = 5;
    private static final int MULTILINGUAL = 6;
    private static final int GREEK_MATH = 7;
    private static final int USE_OOOMATH = 8;
    private static final int USE_PIFONT = 9;
    private static final int USE_IFSYM = 10;
    private static final int USE_WASYSYM = 11;
    private static final int USE_BBDING = 12;
    private static final int USE_EUROSYM = 13;
    private static final int USE_TIPA = 14;
    private static final int USE_COLOR = 15;
    private static final int USE_COLORTBL = 16;
    private static final int USE_GEOMETRY = 17;
    private static final int USE_FANCYHDR = 18;
    private static final int USE_TITLESEC = 19;
    private static final int USE_TITLETOC = 20;
    private static final int USE_HYPERREF = 21;
    private static final int USE_CAPTION = 22;
    private static final int USE_LONGTABLE = 23;
    private static final int USE_SUPERTABULAR = 24;
    private static final int USE_TABULARY = 25;
    private static final int USE_ENDNOTES = 26;
    private static final int USE_ULEM = 27;
    private static final int USE_LASTPAGE = 28;
    private static final int USE_TITLEREF = 29;
    private static final int USE_OOOREF = 30;
    private static final int USE_BIBTEX = 31;
    private static final int BIBTEX_STYLE = 32;
    private static final int EXTERNAL_BIBTEX_FILES = 33;
    private static final int ZOTERO_BIBTEX_FILES = 34;
    private static final int JABREF_BIBTEX_FILES = 35;
    private static final int INCLUDE_ORIGINAL_CITATIONS = 36;
    private static final int USE_NATBIB = 37;
    private static final int NATBIB_OPTIONS = 38;
    private static final int FORMATTING = 39;
    private static final int PAGE_FORMATTING = 40;
    private static final int OTHER_STYLES = 41;
    private static final int IMAGE_CONTENT = 42;
    private static final int TABLE_CONTENT = 43;
    private static final int TABLE_FIRST_HEAD_STYLE = 44;
    private static final int TABLE_HEAD_STYLE = 45;
    private static final int TABLE_FOOT_STYLE = 46;
    private static final int TABLE_LAST_FOOT_STYLE = 47;
    private static final int IGNORE_HARD_PAGE_BREAKS = 48;
    private static final int IGNORE_HARD_LINE_BREAKS = 49;
    private static final int IGNORE_EMPTY_PARAGRAPHS = 50;
    private static final int IGNORE_DOUBLE_SPACES = 51;
    private static final int DISPLAY_HIDDEN_TEXT = 52;
    private static final int ALIGN_FRAMES = 53;
    private static final int FLOAT_FIGURES = 54;
    private static final int FLOAT_TABLES = 55;
    private static final int FLOAT_OPTIONS = 56;
    private static final int FIGURE_SEQUENCE_NAME = 57;
    private static final int TABLE_SEQUENCE_NAME = 58;
    private static final int IMAGE_OPTIONS = 59;
    private static final int REMOVE_GRAPHICS_EXTENSION = 60;
    private static final int ORIGINAL_IMAGE_SIZE = 61;
    private static final int SIMPLE_TABLE_LIMIT = 62;
    private static final int NOTES = 63;
    private static final int METADATA = 64;
    private static final int TABSTOP = 65;
    private static final int WRAP_LINES_AFTER = 66;
    private static final int SPLIT_LINKED_SECTIONS = 67;
    private static final int SPLIT_TOPLEVEL_SECTIONS = 68;
    private static final int SAVE_IMAGES_IN_SUBDIR = 69;
    private static final int DEBUG = 70;
    private ComplexOption headingMap;
    private ComplexOption parMap;
    private ComplexOption parBlockMap;
    private ComplexOption listMap;
    private ComplexOption listItemMap;
    private ComplexOption textMap;
    private ComplexOption textAttrMap;
    private ComplexOption stringReplace;
    private ComplexOption mathSymbols;
    private String sCustomPreamble = "";

    @Override
    protected int getOptionCount() {
        return 71;
    }

    @Override
    protected String getDefaultConfigPath() {
        return "/writer2latex/latex/config/";
    }

    @Override
    public void setOption(String sName, String sValue) {
        if (sName.equals("custom-preamble")) {
            this.sCustomPreamble = sValue;
        } else {
            if (sName.equals("keep_image_size")) {
                sName = "original_image_size";
            }
            super.setOption(sName, sValue);
        }
    }

    @Override
    public String getOption(String sName) {
        if (sName.equals("custom-preamble")) {
            return this.sCustomPreamble;
        }
        return super.getOption(sName);
    }

    public LaTeXConfig() {
        this.options[1] = new BooleanOption("no_preamble", "false");
        this.options[2] = new BooleanOption("no_index", "false");
        this.options[3] = new Option("documentclass", "article");
        this.options[4] = new Option("global_options", "");
        this.options[0] = new IntegerOption("backend", "pdftex"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                if ("generic".equals(sValue)) {
                    this.nValue = 0;
                } else if ("dvips".equals(sValue)) {
                    this.nValue = 1;
                } else if ("pdftex".equals(sValue)) {
                    this.nValue = 2;
                } else if ("unspecified".equals(sValue)) {
                    this.nValue = 3;
                } else if ("xetex".equals(sValue)) {
                    this.nValue = 4;
                }
            }
        };
        this.options[5] = new IntegerOption("inputencoding", ClassicI18n.writeInputenc(0)){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = ClassicI18n.readInputenc(sValue);
            }
        };
        this.options[6] = new BooleanOption("multilingual", "true");
        this.options[7] = new BooleanOption("greek_math", "true");
        this.options[8] = new BooleanOption("use_ooomath", "false");
        this.options[9] = new BooleanOption("use_pifont", "false");
        this.options[10] = new BooleanOption("use_ifsym", "false");
        this.options[11] = new BooleanOption("use_wasysym", "false");
        this.options[12] = new BooleanOption("use_bbding", "false");
        this.options[13] = new BooleanOption("use_eurosym", "false");
        this.options[14] = new BooleanOption("use_tipa", "false");
        this.options[15] = new BooleanOption("use_color", "true");
        this.options[16] = new BooleanOption("use_colortbl", "false");
        this.options[17] = new BooleanOption("use_geometry", "false");
        this.options[18] = new BooleanOption("use_fancyhdr", "false");
        this.options[19] = new BooleanOption("use_titlesec", "false");
        this.options[20] = new BooleanOption("use_titletoc", "false");
        this.options[21] = new BooleanOption("use_hyperref", "true");
        this.options[22] = new BooleanOption("use_caption", "false");
        this.options[23] = new BooleanOption("use_longtable", "false");
        this.options[24] = new BooleanOption("use_supertabular", "true");
        this.options[25] = new BooleanOption("use_tabulary", "false");
        this.options[26] = new BooleanOption("use_endnotes", "false");
        this.options[27] = new BooleanOption("use_ulem", "false");
        this.options[28] = new BooleanOption("use_lastpage", "false");
        this.options[29] = new BooleanOption("use_titleref", "false");
        this.options[30] = new BooleanOption("use_oooref", "false");
        this.options[31] = new BooleanOption("use_bibtex", "false");
        this.options[32] = new Option("bibtex_style", "plain");
        this.options[33] = new Option("external_bibtex_files", "");
        this.options[34] = new Option("zotero_bibtex_files", "");
        this.options[35] = new Option("jabref_bibtex_files", "");
        this.options[36] = new BooleanOption("include_original_citations", "false");
        this.options[37] = new BooleanOption("use_natbib", "false");
        this.options[38] = new Option("natbib_options", "");
        this.options[39] = new IntegerOption("formatting", "convert_basic"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                if ("convert_all".equals(sValue)) {
                    this.nValue = 4;
                } else if ("convert_most".equals(sValue)) {
                    this.nValue = 3;
                } else if ("convert_basic".equals(sValue)) {
                    this.nValue = 2;
                } else if ("ignore_most".equals(sValue)) {
                    this.nValue = 1;
                } else if ("ignore_all".equals(sValue)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[40] = new IntegerOption("page_formatting", "convert_all"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                if ("convert_all".equals(sValue)) {
                    this.nValue = 4;
                } else if ("convert_header_footer".equals(sValue)) {
                    this.nValue = 5;
                } else if ("convert_geometry".equals(sValue)) {
                    this.nValue = 6;
                } else if ("ignore_all".equals(sValue)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[41] = new ContentHandlingOption("other_styles", "accept");
        this.options[42] = new ContentHandlingOption("image_content", "accept");
        this.options[43] = new ContentHandlingOption("table_content", "accept");
        this.options[44] = new Option("table_first_head_style", "");
        this.options[45] = new Option("table_head_style", "");
        this.options[46] = new Option("table_foot_style", "");
        this.options[47] = new Option("table_last_foot_style", "");
        this.options[48] = new BooleanOption("ignore_hard_page_breaks", "false");
        this.options[49] = new BooleanOption("ignore_hard_line_breaks", "false");
        this.options[50] = new BooleanOption("ignore_empty_paragraphs", "false");
        this.options[51] = new BooleanOption("ignore_double_spaces", "false");
        this.options[52] = new BooleanOption("display_hidden_text", "false");
        this.options[53] = new BooleanOption("align_frames", "true");
        this.options[54] = new BooleanOption("float_figures", "false");
        this.options[55] = new BooleanOption("float_tables", "false");
        this.options[56] = new Option("float_options", "h");
        this.options[57] = new BooleanOption("figure_sequence_name", "");
        this.options[58] = new BooleanOption("table_sequence_name", "");
        this.options[59] = new Option("image_options", "");
        this.options[60] = new BooleanOption("remove_graphics_extension", "false");
        this.options[61] = new BooleanOption("original_image_size", "false");
        this.options[62] = new IntegerOption("simple_table_limit", "0"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[63] = new IntegerOption("notes", "comment"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "ignore".equals(sValue) ? 0 : ("comment".equals(sValue) ? 1 : ("pdfannotation".equals(sValue) ? 2 : ("marginpar".equals(sValue) ? 3 : 4)));
            }
        };
        this.options[64] = new BooleanOption("metadata", "true");
        this.options[65] = new Option("tabstop", "");
        this.options[66] = new IntegerOption("wrap_lines_after", "120"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[67] = new BooleanOption("split_linked_sections", "false");
        this.options[68] = new BooleanOption("split_toplevel_sections", "false");
        this.options[69] = new BooleanOption("save_images_in_subdir", "false");
        this.options[70] = new BooleanOption("debug", "false");
        this.headingMap = this.addComplexOption("heading-map");
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("name", "section");
        attr.put("level", "1");
        this.headingMap.put("1", attr);
        attr = new HashMap();
        attr.put("name", "subsection");
        attr.put("level", "2");
        this.headingMap.put("2", attr);
        attr = new HashMap();
        attr.put("name", "subsubsection");
        attr.put("level", "3");
        this.headingMap.put("3", attr);
        attr = new HashMap();
        attr.put("name", "paragraph");
        attr.put("level", "4");
        this.headingMap.put("4", attr);
        attr = new HashMap();
        attr.put("name", "subparagraph");
        attr.put("level", "5");
        this.headingMap.put("5", attr);
        this.parMap = this.addComplexOption("paragraph-map");
        this.parBlockMap = this.addComplexOption("paragraph-block-map");
        this.listMap = this.addComplexOption("list-map");
        this.listItemMap = this.addComplexOption("listitem-map");
        this.textMap = this.addComplexOption("text-map");
        this.textAttrMap = this.addComplexOption("text-attribute-map");
        this.stringReplace = this.addComplexOption("string-replace");
        attr = new HashMap();
        attr.put("fontenc", "any");
        attr.put("latex-code", " \u2014");
        this.stringReplace.put("\u00a0\u2014", attr);
        attr = new HashMap();
        attr.put("fontenc", "any");
        attr.put("latex-code", " !");
        this.stringReplace.put("\u00a0!", attr);
        attr = new HashMap();
        attr.put("fontenc", "any");
        attr.put("latex-code", " ?");
        this.stringReplace.put("\u00a0?", attr);
        attr = new HashMap();
        attr.put("fontenc", "any");
        attr.put("latex-code", " :");
        this.stringReplace.put("\u00a0:", attr);
        attr = new HashMap();
        attr.put("fontenc", "any");
        attr.put("latex-code", " ;");
        this.stringReplace.put("\u00a0;", attr);
        this.mathSymbols = this.addComplexOption("math-symbol-map");
    }

    @Override
    protected void readInner(Element elm) {
        if (elm.getTagName().equals("heading-map")) {
            this.headingMap.clear();
            for (Node child = elm.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element childElm;
                if (child.getNodeType() != 1 || !(childElm = (Element)child).getTagName().equals("heading-level-map") || !childElm.hasAttribute("writer-level")) continue;
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("name", childElm.getAttribute("name"));
                attr.put("level", childElm.getAttribute("level"));
                this.headingMap.put(childElm.getAttribute("writer-level"), attr);
            }
        } else if (elm.getTagName().equals("style-map")) {
            String sName = elm.getAttribute("name");
            String sFamily = elm.getAttribute("family");
            if (sFamily.length() == 0) {
                sFamily = elm.getAttribute("class");
            }
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("before", elm.getAttribute("before"));
            attr.put("after", elm.getAttribute("after"));
            if ("paragraph".equals(sFamily)) {
                if (elm.hasAttribute("line-break")) {
                    attr.put("line-break", elm.getAttribute("line-break"));
                }
                if (elm.hasAttribute("break-after")) {
                    attr.put("break-after", elm.getAttribute("break-after"));
                }
                if (elm.hasAttribute("verbatim")) {
                    attr.put("verbatim", elm.getAttribute("verbatim"));
                }
                this.parMap.put(sName, attr);
            }
            if ("paragraph-block".equals(sFamily)) {
                attr.put("next", elm.getAttribute("next"));
                if (elm.hasAttribute("verbatim")) {
                    attr.put("verbatim", elm.getAttribute("verbatim"));
                }
                this.parBlockMap.put(sName, attr);
            } else if ("list".equals(sFamily)) {
                this.listMap.put(sName, attr);
            } else if ("listitem".equals(sFamily)) {
                this.listItemMap.put(sName, attr);
            } else if ("text".equals(sFamily)) {
                if (elm.hasAttribute("verbatim")) {
                    attr.put("verbatim", elm.getAttribute("verbatim"));
                }
                this.textMap.put(sName, attr);
            } else if ("text-attribute".equals(sFamily)) {
                this.textAttrMap.put(sName, attr);
            }
        } else if (elm.getTagName().equals("string-replace")) {
            String sInput = elm.getAttribute("input");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("latex-code", elm.getAttribute("latex-code"));
            if (elm.hasAttribute("fontenc") && elm.getAttribute("fontenc").length() > 0) {
                attributes.put("fontenc", elm.getAttribute("fontenc"));
            } else {
                attributes.put("fontenc", "any");
            }
            this.stringReplace.put(sInput, attributes);
        } else if (elm.getTagName().equals("math-symbol-map")) {
            String sName = elm.getAttribute("name");
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("latex", elm.getAttribute("latex"));
            this.mathSymbols.put(sName, attr);
        } else if (elm.getTagName().equals("custom-preamble")) {
            StringBuilder buf = new StringBuilder();
            for (Node child = elm.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                buf.append(child.getNodeValue());
            }
            this.sCustomPreamble = buf.toString();
        }
    }

    @Override
    protected void writeInner(Document dom) {
        int nMaxLevel;
        for (nMaxLevel = 0; nMaxLevel < 10 && this.headingMap.get(Integer.toString(nMaxLevel + 1)) != null; ++nMaxLevel) {
        }
        Element hmNode = dom.createElement("heading-map");
        hmNode.setAttribute("max-level", Integer.toString(nMaxLevel));
        dom.getDocumentElement().appendChild(hmNode);
        for (int i = 1; i <= nMaxLevel; ++i) {
            Element hlmNode = dom.createElement("heading-level-map");
            String sWriterLevel = Integer.toString(i);
            hlmNode.setAttribute("writer-level", sWriterLevel);
            Map<String, String> attr = this.headingMap.get(sWriterLevel);
            hlmNode.setAttribute("name", attr.get("name"));
            hlmNode.setAttribute("level", attr.get("level"));
            hmNode.appendChild(hlmNode);
        }
        this.writeStyleMap(dom, this.parMap, "paragraph");
        this.writeStyleMap(dom, this.parBlockMap, "paragraph-block");
        this.writeStyleMap(dom, this.listMap, "list");
        this.writeStyleMap(dom, this.listItemMap, "listitem");
        this.writeStyleMap(dom, this.textMap, "text");
        this.writeStyleMap(dom, this.textAttrMap, "text-attribute");
        Set<String> inputStrings = this.stringReplace.keySet();
        for (String sInput : inputStrings) {
            Map<String, String> attributes = this.stringReplace.get(sInput);
            Element srNode = dom.createElement("string-replace");
            srNode.setAttribute("input", sInput);
            srNode.setAttribute("latex-code", attributes.get("latex-code"));
            srNode.setAttribute("fontenc", attributes.get("fontenc"));
            dom.getDocumentElement().appendChild(srNode);
        }
        for (String sName : this.mathSymbols.keySet()) {
            String sLatex = this.mathSymbols.get(sName).get("latex");
            Element msNode = dom.createElement("math-symbol-map");
            msNode.setAttribute("name", sName);
            msNode.setAttribute("latex", sLatex);
            dom.getDocumentElement().appendChild(msNode);
        }
        Element cp = dom.createElement("custom-preamble");
        cp.appendChild(dom.createTextNode(this.sCustomPreamble));
        dom.getDocumentElement().appendChild(cp);
    }

    private void writeStyleMap(Document dom, ComplexOption co, String sFamily) {
        for (String sName : co.keySet()) {
            Map<String, String> attr = co.get(sName);
            Element smNode = dom.createElement("style-map");
            smNode.setAttribute("name", sName);
            smNode.setAttribute("family", sFamily);
            smNode.setAttribute("before", attr.containsKey("before") ? attr.get("before") : "");
            smNode.setAttribute("after", attr.containsKey("after") ? attr.get("after") : "");
            if (attr.containsKey("next")) {
                smNode.setAttribute("next", attr.get("next"));
            }
            if (attr.containsKey("line-break")) {
                smNode.setAttribute("line-break", attr.get("line-break"));
            }
            if (attr.containsKey("break-after")) {
                smNode.setAttribute("break-after", attr.get("break-after"));
            }
            if (attr.containsKey("verbatim")) {
                smNode.setAttribute("verbatim", attr.get("verbatim"));
            }
            dom.getDocumentElement().appendChild(smNode);
        }
    }

    public HeadingMap getHeadingMap() {
        int nMaxLevel;
        for (nMaxLevel = 0; nMaxLevel < 10 && this.headingMap.get(Integer.toString(nMaxLevel + 1)) != null; ++nMaxLevel) {
        }
        HeadingMap map = new HeadingMap(nMaxLevel);
        for (int i = 1; i <= nMaxLevel; ++i) {
            String sWriterLevel = Integer.toString(i);
            Map<String, String> attr = this.headingMap.get(sWriterLevel);
            String sName = attr.get("name");
            int nLevel = Misc.getPosInteger(attr.get("level"), 0);
            map.setLevelData(i, sName, nLevel);
        }
        return map;
    }

    public StyleMap getParStyleMap() {
        return this.getStyleMap(this.parMap);
    }

    public StyleMap getParBlockStyleMap() {
        return this.getStyleMap(this.parBlockMap);
    }

    public StyleMap getListStyleMap() {
        return this.getStyleMap(this.listMap);
    }

    public StyleMap getListItemStyleMap() {
        return this.getStyleMap(this.listItemMap);
    }

    public StyleMap getTextAttributeStyleMap() {
        return this.getStyleMap(this.textAttrMap);
    }

    public StyleMap getTextStyleMap() {
        return this.getStyleMap(this.textMap);
    }

    private StyleMap getStyleMap(ComplexOption co) {
        StyleMap map = new StyleMap();
        for (String sName : co.keySet()) {
            Map<String, String> attr = co.get(sName);
            String sBefore = attr.containsKey("before") ? attr.get("before") : "";
            String sAfter = attr.containsKey("after") ? attr.get("after") : "";
            String sNext = attr.containsKey("next") ? attr.get("next") : "";
            boolean bLineBreak = !"false".equals(attr.get("line-break"));
            int nBreakAfter = 2;
            String sBreakAfter = attr.get("break-after");
            if ("none".equals(sBreakAfter)) {
                nBreakAfter = 0;
            } else if ("line".equals(sBreakAfter)) {
                nBreakAfter = 1;
            }
            boolean bVerbatim = "true".equals(attr.get("verbatim"));
            map.put(sName, sBefore, sAfter, sNext, bLineBreak, nBreakAfter, bVerbatim);
        }
        return map;
    }

    public ReplacementTrie getStringReplace() {
        ReplacementTrie trie = new ReplacementTrie();
        for (String sInput : this.stringReplace.keySet()) {
            Map<String, String> attributes = this.stringReplace.get(sInput);
            String sLaTeXCode = attributes.get("latex-code");
            String sFontenc = attributes.get("fontenc");
            trie.put(sInput, sLaTeXCode != null ? sLaTeXCode : "", ClassicI18n.readFontencs(sFontenc != null ? sFontenc : "any"));
        }
        return trie;
    }

    public Map<String, String> getMathSymbols() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String sName : this.mathSymbols.keySet()) {
            String sLatex = this.mathSymbols.get(sName).get("latex");
            map.put(sName, sLatex);
        }
        return map;
    }

    public String getCustomPreamble() {
        return this.sCustomPreamble;
    }

    public boolean debug() {
        return ((BooleanOption)this.options[70]).getValue();
    }

    public String getDocumentclass() {
        return this.options[3].getString();
    }

    public String getGlobalOptions() {
        return this.options[4].getString();
    }

    public int getBackend() {
        return ((IntegerOption)this.options[0]).getValue();
    }

    public int getInputencoding() {
        return ((IntegerOption)this.options[5]).getValue();
    }

    public boolean multilingual() {
        return ((BooleanOption)this.options[6]).getValue();
    }

    public boolean greekMath() {
        return ((BooleanOption)this.options[7]).getValue();
    }

    public boolean noPreamble() {
        return ((BooleanOption)this.options[1]).getValue();
    }

    public boolean noIndex() {
        return ((BooleanOption)this.options[2]).getValue();
    }

    public boolean useOoomath() {
        return ((BooleanOption)this.options[8]).getValue();
    }

    public boolean usePifont() {
        return ((BooleanOption)this.options[9]).getValue();
    }

    public boolean useIfsym() {
        return ((BooleanOption)this.options[10]).getValue();
    }

    public boolean useWasysym() {
        return ((BooleanOption)this.options[11]).getValue();
    }

    public boolean useBbding() {
        return ((BooleanOption)this.options[12]).getValue();
    }

    public boolean useEurosym() {
        return ((BooleanOption)this.options[13]).getValue();
    }

    public boolean useTipa() {
        return ((BooleanOption)this.options[14]).getValue();
    }

    public boolean useColor() {
        return ((BooleanOption)this.options[15]).getValue();
    }

    public boolean useColortbl() {
        return ((BooleanOption)this.options[16]).getValue();
    }

    public boolean useGeometry() {
        return ((BooleanOption)this.options[17]).getValue();
    }

    public boolean useFancyhdr() {
        return ((BooleanOption)this.options[18]).getValue();
    }

    public boolean useTitlesec() {
        return ((BooleanOption)this.options[19]).getValue();
    }

    public boolean useTitletoc() {
        return ((BooleanOption)this.options[20]).getValue();
    }

    public boolean useHyperref() {
        return ((BooleanOption)this.options[21]).getValue();
    }

    public boolean useCaption() {
        return ((BooleanOption)this.options[22]).getValue();
    }

    public boolean useLongtable() {
        return ((BooleanOption)this.options[23]).getValue();
    }

    public boolean useSupertabular() {
        return ((BooleanOption)this.options[24]).getValue();
    }

    public boolean useTabulary() {
        return ((BooleanOption)this.options[25]).getValue();
    }

    public boolean useEndnotes() {
        return ((BooleanOption)this.options[26]).getValue();
    }

    public boolean useUlem() {
        return ((BooleanOption)this.options[27]).getValue();
    }

    public boolean useLastpage() {
        return ((BooleanOption)this.options[28]).getValue();
    }

    public boolean useTitleref() {
        return ((BooleanOption)this.options[29]).getValue();
    }

    public boolean useOooref() {
        return ((BooleanOption)this.options[30]).getValue();
    }

    public boolean useBibtex() {
        return ((BooleanOption)this.options[31]).getValue();
    }

    public String bibtexStyle() {
        return this.options[32].getString();
    }

    public String externalBibtexFiles() {
        return this.options[33].getString();
    }

    public String zoteroBibtexFiles() {
        return this.options[34].getString();
    }

    public String jabrefBibtexFiles() {
        return this.options[35].getString();
    }

    public boolean includeOriginalCitations() {
        return ((BooleanOption)this.options[36]).getValue();
    }

    public boolean useNatbib() {
        return ((BooleanOption)this.options[37]).getValue();
    }

    public String getNatbibOptions() {
        return this.options[38].getString();
    }

    public int formatting() {
        return ((IntegerOption)this.options[39]).getValue();
    }

    public int pageFormatting() {
        return ((IntegerOption)this.options[40]).getValue();
    }

    public int otherStyles() {
        return ((IntegerOption)this.options[41]).getValue();
    }

    public int imageContent() {
        return ((IntegerOption)this.options[42]).getValue();
    }

    public int tableContent() {
        return ((IntegerOption)this.options[43]).getValue();
    }

    public String getTableFirstHeadStyle() {
        return this.options[44].getString();
    }

    public String getTableHeadStyle() {
        return this.options[45].getString();
    }

    public String getTableFootStyle() {
        return this.options[46].getString();
    }

    public String getTableLastFootStyle() {
        return this.options[47].getString();
    }

    public boolean ignoreHardPageBreaks() {
        return ((BooleanOption)this.options[48]).getValue();
    }

    public boolean ignoreHardLineBreaks() {
        return ((BooleanOption)this.options[49]).getValue();
    }

    public boolean ignoreEmptyParagraphs() {
        return ((BooleanOption)this.options[50]).getValue();
    }

    public boolean ignoreDoubleSpaces() {
        return ((BooleanOption)this.options[51]).getValue();
    }

    public boolean displayHiddenText() {
        return ((BooleanOption)this.options[52]).getValue();
    }

    public boolean alignFrames() {
        return ((BooleanOption)this.options[53]).getValue();
    }

    public boolean floatFigures() {
        return ((BooleanOption)this.options[54]).getValue();
    }

    public boolean floatTables() {
        return ((BooleanOption)this.options[55]).getValue();
    }

    public String getFloatOptions() {
        return this.options[56].getString();
    }

    public String getFigureSequenceName() {
        return this.options[57].getString();
    }

    public String getTableSequenceName() {
        return this.options[58].getString();
    }

    public String getImageOptions() {
        return this.options[59].getString();
    }

    public boolean removeGraphicsExtension() {
        return ((BooleanOption)this.options[60]).getValue();
    }

    public boolean originalImageSize() {
        return ((BooleanOption)this.options[61]).getValue();
    }

    public int getSimpleTableLimit() {
        return ((IntegerOption)this.options[62]).getValue();
    }

    public int notes() {
        return ((IntegerOption)this.options[63]).getValue();
    }

    public String getNotesCommand() {
        return this.options[63].getString();
    }

    public boolean metadata() {
        return ((BooleanOption)this.options[64]).getValue();
    }

    public String getTabstop() {
        return this.options[65].getString();
    }

    public int getWrapLinesAfter() {
        return ((IntegerOption)this.options[66]).getValue();
    }

    public boolean splitLinkedSections() {
        return ((BooleanOption)this.options[67]).getValue();
    }

    public boolean splitToplevelSections() {
        return ((BooleanOption)this.options[68]).getValue();
    }

    public boolean saveImagesInSubdir() {
        return ((BooleanOption)this.options[69]).getValue();
    }
}

