#!/bin/sh
if [ $# -lt 2 ]
then
    echo "Usage: `basename $0` gifname color"
    echo "  gifname - name of GIF file"
    echo "  color   - color ID to make transparent"
    echo " E.g. `basename $0` input.gif rgbi:0.5/0.5/0.5"
    echo "   or `basename $0` input.gif rgb:ff/00/00"
    exit 1
fi
# giftoppm $1 | ppmtogif -interlace -transparent $2 > /tmp/$$.gif
giftopnm $1 | ppmtogif -interlace -transparent $2 > /tmp/$$.gif
if [ $? -eq 0 ]
then
    mv /tmp/$$.gif $1
else
    rm /tmp/$$.gif
fi
