/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Draw/Line/LineAngle/Tests/LineAngle01.js
// Timestamp   : 2011-02-09 15:34:36
// Description : same angle, different lengths, input mouse clicks

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function LineAngle01() {
    TdbTest.call(this, 'scripts/Draw/Line/LineAngle/Tests/LineAngle01.js');
}

LineAngle01.prototype = new TdbTest();

LineAngle01.prototype.test00 = function() {
    qDebug('running LineAngle01.test00()...');
    this.setUp();
    this.clickOnWidget('MainWindow::MainToolsPanel::LineToolsPanelButton');
    this.clickOnWidget('MainWindow::LineToolsPanel::LineAngleButton');
    this.setToolOption('LineAngle/Angle',  [ 0, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 10, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', 'Start');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineAngle/Angle',  [ 0, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 20, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', 'Start');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 2);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineAngle/Angle',  [ 0, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 30, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', 'Start');
    this.updateToolOptions();
    this.zoomTo(-20.73, -18.83, 48.75, 32.65);
    var p = new RVector(0, 10);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineAngle/Angle',  [ 0, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 40, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', 'Start');
    this.updateToolOptions();
    this.zoomTo(-20.73, -18.83, 48.75, 32.65);
    var p = new RVector(0, 20);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineAngle/Angle',  [ 0, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 50, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', 'Start');
    this.updateToolOptions();
    this.zoomTo(-26.034, -25.526000000000003, 57.34199999999999, 36.24999999999999);
    var p = new RVector(0, 30);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.verifyDrawing('LineAngle01_000.dxf');
    this.tearDown();
    qDebug('finished LineAngle01.test00()');
};

