/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ProportionalLayout;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.ImportedTextureWizardController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportedTextureWizardStepsPanel
extends JPanel
implements View {
    private static final int LARGE_IMAGE_PIXEL_COUNT_THRESHOLD = 409600;
    private static final int IMAGE_PREFERRED_MAX_SIZE = 512;
    private static final int LARGE_IMAGE_MAX_PIXEL_COUNT = 262144;
    private static final int IMAGE_PREFERRED_SIZE = Math.round(150.0f * SwingTools.getResolutionScale());
    private final ImportedTextureWizardController controller;
    private CardLayout cardLayout;
    private JLabel imageChoiceOrChangeLabel;
    private JButton imageChoiceOrChangeButton;
    private JButton findImagesButton;
    private JLabel imageChoiceErrorLabel;
    private ScaledImageComponent imageChoicePreviewComponent;
    private JLabel attributesLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel categoryLabel;
    private JComboBox categoryComboBox;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private ScaledImageComponent attributesPreviewComponent;
    private Executor imageLoader;
    private static BufferedImage waitImage;

    public ImportedTextureWizardStepsPanel(CatalogTexture catalogTexture, String string, UserPreferences userPreferences, final ImportedTextureWizardController importedTextureWizardController) {
        this.controller = importedTextureWizardController;
        this.imageLoader = Executors.newSingleThreadExecutor();
        this.createComponents(userPreferences, importedTextureWizardController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        this.updateController(catalogTexture, userPreferences);
        if (string != null) {
            this.updateController(string, importedTextureWizardController.getContentManager(), userPreferences, true);
        }
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.STEP, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedTextureWizardStepsPanel.this.updateStep(importedTextureWizardController);
            }
        });
    }

    private void createComponents(final UserPreferences userPreferences, final ImportedTextureWizardController importedTextureWizardController) {
        Object object;
        String string = userPreferences.getLengthUnit().getName();
        this.imageChoiceOrChangeLabel = new JLabel();
        this.imageChoiceOrChangeButton = new JButton();
        this.imageChoiceOrChangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ImportedTextureWizardStepsPanel.this.showImageChoiceDialog(userPreferences, importedTextureWizardController.getContentManager());
                if (string != null) {
                    ImportedTextureWizardStepsPanel.this.updateController(string, importedTextureWizardController.getContentManager(), userPreferences, false);
                }
            }
        });
        try {
            this.findImagesButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "findImagesButton.text", new Object[0]));
            object = userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "findImagesButton.url", new Object[0]);
            this.findImagesButton.addActionListener(new ActionListener((String)object, userPreferences){
                final /* synthetic */ String val$findImagesUrl;
                final /* synthetic */ UserPreferences val$preferences;
                {
                    this.val$findImagesUrl = string;
                    this.val$preferences = userPreferences;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    try {
                        bl = SwingTools.showDocumentInBrowser(new URL(this.val$findImagesUrl));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (!bl) {
                        JTextArea jTextArea = new JTextArea(this.val$preferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "findImagesMessage.text", new Object[0]));
                        String string = this.val$preferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "findImagesMessage.title", new Object[0]);
                        jTextArea.setEditable(false);
                        jTextArea.setOpaque(false);
                        JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedTextureWizardStepsPanel.this), jTextArea, string, 1);
                    }
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.imageChoiceErrorLabel = new JLabel(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceErrorLabel.text", new Object[0]));
        this.imageChoiceErrorLabel.setVisible(false);
        this.imageChoicePreviewComponent = new ScaledImageComponent();
        this.imageChoicePreviewComponent.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                boolean bl = false;
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : list) {
                        final String string = file.getAbsolutePath();
                        if (!importedTextureWizardController.getContentManager().isAcceptable(string, ContentManager.ContentType.IMAGE)) continue;
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                ImportedTextureWizardStepsPanel.this.updateController(string, importedTextureWizardController.getContentManager(), userPreferences, false);
                            }
                        });
                        bl = true;
                        break;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!bl) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedTextureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceErrorLabel.text", new Object[0]));
                        }
                    });
                }
                return bl;
            }
        });
        this.imageChoicePreviewComponent.setBorder(SwingTools.getDropableComponentBorder());
        this.attributesLabel = new JLabel(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "attributesLabel.text", new Object[0]));
        this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "nameLabel.text", new Object[0]));
        this.nameTextField = new JTextField(10);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
        }
        object = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ImportedTextureWizardStepsPanel.this.nameTextField.getDocument().removeDocumentListener(this);
                importedTextureWizardController.setName(ImportedTextureWizardStepsPanel.this.nameTextField.getText().trim());
                ImportedTextureWizardStepsPanel.this.nameTextField.getDocument().addDocumentListener(this);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
        this.nameTextField.getDocument().addDocumentListener((DocumentListener)object);
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.NAME, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!ImportedTextureWizardStepsPanel.this.nameTextField.getText().trim().equals(importedTextureWizardController.getName())) {
                    ImportedTextureWizardStepsPanel.this.nameTextField.setText(importedTextureWizardController.getName());
                }
            }
        });
        this.categoryLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "categoryLabel.text", new Object[0]));
        this.categoryComboBox = new JComboBox<Object>(userPreferences.getTexturesCatalog().getCategories().toArray());
        this.categoryComboBox.setEditable(true);
        final ComboBoxEditor comboBoxEditor = this.categoryComboBox.getEditor();
        this.categoryComboBox.setEditor(new ComboBoxEditor(){

            public Object getItem() {
                String string = (String)comboBoxEditor.getItem();
                if ((string = string.trim()).length() == 0) {
                    Object object = ImportedTextureWizardStepsPanel.this.categoryComboBox.getSelectedItem();
                    this.setItem(object);
                    return object;
                }
                TexturesCategory texturesCategory = new TexturesCategory(string);
                List<TexturesCategory> list = userPreferences.getTexturesCatalog().getCategories();
                int n = Collections.binarySearch(list, texturesCategory);
                if (n >= 0) {
                    return list.get(n);
                }
                return texturesCategory;
            }

            public void setItem(Object object) {
                if (object != null) {
                    TexturesCategory texturesCategory = (TexturesCategory)object;
                    comboBoxEditor.setItem(texturesCategory.getName());
                }
            }

            public void addActionListener(ActionListener actionListener) {
                comboBoxEditor.addActionListener(actionListener);
            }

            public Component getEditorComponent() {
                return comboBoxEditor.getEditorComponent();
            }

            public void removeActionListener(ActionListener actionListener) {
                comboBoxEditor.removeActionListener(actionListener);
            }

            public void selectAll() {
                comboBoxEditor.selectAll();
            }
        });
        this.categoryComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                TexturesCategory texturesCategory = (TexturesCategory)object;
                return super.getListCellRendererComponent((JList<?>)jList, texturesCategory.getName(), n, bl, bl2);
            }
        });
        this.categoryComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                importedTextureWizardController.setCategory((TexturesCategory)itemEvent.getItem());
            }
        });
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.CATEGORY, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TexturesCategory texturesCategory = importedTextureWizardController.getCategory();
                if (texturesCategory != null) {
                    ImportedTextureWizardStepsPanel.this.categoryComboBox.setSelectedItem(texturesCategory);
                }
            }
        });
        this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "widthLabel.text", string));
        float f = userPreferences.getLengthUnit().getMinimumLength();
        float f2 = userPreferences.getLengthUnit().getMaximumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, f2);
        this.widthSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel.removeChangeListener(this);
                importedTextureWizardController.setWidth(nullableSpinnerLengthModel.getLength().floatValue());
                nullableSpinnerLengthModel.addChangeListener(this);
            }
        });
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.WIDTH, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength(Float.valueOf(importedTextureWizardController.getWidth()));
            }
        });
        this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "heightLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, f2);
        this.heightSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                nullableSpinnerLengthModel2.removeChangeListener(this);
                importedTextureWizardController.setHeight(nullableSpinnerLengthModel2.getLength().floatValue());
                nullableSpinnerLengthModel2.addChangeListener(this);
            }
        });
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.HEIGHT, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength(Float.valueOf(importedTextureWizardController.getHeight()));
            }
        });
        this.attributesPreviewComponent = new ScaledImageComponent();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportedTextureWizardStepsPanel.this.updateAttributesPreviewImage();
            }
        };
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.IMAGE, propertyChangeListener);
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.WIDTH, propertyChangeListener);
        importedTextureWizardController.addPropertyChangeListener(ImportedTextureWizardController.Property.HEIGHT, propertyChangeListener);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.findImagesButton != null) {
                this.findImagesButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "findImagesButton.mnemonic", new Object[0])).getKeyCode());
            }
            this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
            this.nameLabel.setLabelFor(this.nameTextField);
            this.categoryLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "categoryLabel.mnemonic", new Object[0])).getKeyCode());
            this.categoryLabel.setLabelFor(this.categoryComboBox);
            this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
            this.widthLabel.setLabelFor(this.widthSpinner);
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
        }
    }

    private void layoutComponents() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.imageChoiceOrChangeLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.imageChoicePreviewComponent.setPreferredSize(new Dimension(IMAGE_PREFERRED_SIZE, IMAGE_PREFERRED_SIZE));
        if (this.findImagesButton != null) {
            jPanel.add((Component)this.imageChoiceOrChangeButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 22, 0, new Insets(0, 0, 0, 10), 0, 0));
            jPanel.add((Component)this.findImagesButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            jPanel.add((Component)this.imageChoiceOrChangeButton, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        jPanel.add((Component)this.imageChoiceErrorLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new ProportionalLayout());
        jPanel2.add((Component)jPanel, (Object)ProportionalLayout.Constraints.TOP);
        jPanel2.add((Component)this.imageChoicePreviewComponent, (Object)ProportionalLayout.Constraints.BOTTOM);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this.attributesLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 10, 0), 0, 0));
        this.attributesPreviewComponent.setPreferredSize(new Dimension(IMAGE_PREFERRED_SIZE, IMAGE_PREFERRED_SIZE));
        jPanel3.add((Component)this.attributesPreviewComponent, new GridBagConstraints(0, 1, 1, 5, 1.0, 0.0, 11, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel3.add((Component)this.nameLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel3.add((Component)this.nameTextField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel3.add((Component)this.categoryLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel3.add((Component)this.categoryComboBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel3.add((Component)this.widthLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 5), 0, 0));
        jPanel3.add((Component)this.widthSpinner, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel3.add((Component)this.heightLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
        jPanel3.add((Component)this.heightSpinner, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel3.add((Component)new JLabel(), new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, ImportedTextureWizardController.Step.IMAGE.name());
        this.add((Component)jPanel3, ImportedTextureWizardController.Step.ATTRIBUTES.name());
    }

    public void updateStep(ImportedTextureWizardController importedTextureWizardController) {
        ImportedTextureWizardController.Step step = importedTextureWizardController.getStep();
        this.cardLayout.show(this, step.name());
        switch (step) {
            case IMAGE: {
                this.imageChoiceOrChangeButton.requestFocusInWindow();
                break;
            }
            case ATTRIBUTES: {
                this.nameTextField.requestFocusInWindow();
            }
        }
    }

    private void updateController(final CatalogTexture catalogTexture, final UserPreferences userPreferences) {
        if (catalogTexture == null) {
            this.setImageChoiceTexts(userPreferences);
            this.updatePreviewComponentsImage(null);
        } else {
            this.setImageChangeTexts(userPreferences);
            this.imageLoader.execute(new Runnable(){

                public void run() {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImportedTextureWizardStepsPanel.this.readImage(catalogTexture.getImage(), userPreferences);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    final BufferedImage bufferedImage2 = bufferedImage;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (bufferedImage2 != null) {
                                ImportedTextureWizardStepsPanel.this.controller.setImage(catalogTexture.getImage());
                                ImportedTextureWizardStepsPanel.this.controller.setName(catalogTexture.getName());
                                ImportedTextureWizardStepsPanel.this.controller.setCategory(catalogTexture.getCategory());
                                ImportedTextureWizardStepsPanel.this.controller.setWidth(catalogTexture.getWidth());
                                ImportedTextureWizardStepsPanel.this.controller.setHeight(catalogTexture.getHeight());
                            } else {
                                ImportedTextureWizardStepsPanel.this.controller.setImage(null);
                                ImportedTextureWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                                ImportedTextureWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(true);
                            }
                        }
                    });
                }
            });
        }
    }

    private void updateController(final String string, final ContentManager contentManager, final UserPreferences userPreferences, final boolean bl) {
        this.imageLoader.execute(new Runnable(){

            public void run() {
                Dimension dimension;
                Content content = null;
                try {
                    content = TemporaryURLContent.copyToTemporaryURLContent(contentManager.getContent(string));
                }
                catch (RecorderException recorderException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (content == null) {
                    if (!bl) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(SwingUtilities.getRootPane(ImportedTextureWizardStepsPanel.this), userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceError", string));
                            }
                        });
                    }
                    return;
                }
                BufferedImage bufferedImage = null;
                try {
                    dimension = SwingTools.getImageSizeInPixels(content);
                    if ((long)dimension.width * (long)dimension.height > 409600L && (content = ImportedTextureWizardStepsPanel.this.readAndReduceImage(content, dimension, userPreferences)) == null) {
                        return;
                    }
                    bufferedImage = ImportedTextureWizardStepsPanel.this.readImage(content, userPreferences);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                dimension = bufferedImage;
                TemporaryURLContent temporaryURLContent = content;
                EventQueue.invokeLater(new Runnable((BufferedImage)((Object)dimension), temporaryURLContent){
                    final /* synthetic */ BufferedImage val$readImage;
                    final /* synthetic */ Content val$readContent;
                    {
                        this.val$readImage = bufferedImage;
                        this.val$readContent = content;
                    }

                    public void run() {
                        if (this.val$readImage != null) {
                            Object object2;
                            ImportedTextureWizardStepsPanel.this.controller.setImage(this.val$readContent);
                            ImportedTextureWizardStepsPanel.this.setImageChangeTexts(userPreferences);
                            ImportedTextureWizardStepsPanel.this.imageChoiceErrorLabel.setVisible(false);
                            ImportedTextureWizardStepsPanel.this.controller.setName(contentManager.getPresentationName(string, ContentManager.ContentType.IMAGE));
                            TexturesCategory texturesCategory = new TexturesCategory(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "userCategory", new Object[0]));
                            for (Object object2 : userPreferences.getTexturesCatalog().getCategories()) {
                                if (!object2.equals(texturesCategory)) continue;
                                texturesCategory = object2;
                                break;
                            }
                            ImportedTextureWizardStepsPanel.this.controller.setCategory(texturesCategory);
                            float f = 20.0f;
                            object2 = userPreferences.getLengthUnit();
                            if (object2 == LengthUnit.INCH || object2 == LengthUnit.INCH_DECIMALS) {
                                f = LengthUnit.inchToCentimeter(8.0f);
                            }
                            ImportedTextureWizardStepsPanel.this.controller.setWidth(f);
                            ImportedTextureWizardStepsPanel.this.controller.setHeight(f / (float)this.val$readImage.getWidth() * (float)this.val$readImage.getHeight());
                        } else if (ImportedTextureWizardStepsPanel.this.isShowing()) {
                            ImportedTextureWizardStepsPanel.this.controller.setImage(null);
                            ImportedTextureWizardStepsPanel.this.setImageChoiceTexts(userPreferences);
                            JOptionPane.showMessageDialog(ImportedTextureWizardStepsPanel.this, userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceFormatError", new Object[0]));
                        }
                    }
                });
            }
        });
    }

    private Content readAndReduceImage(Content content, final Dimension dimension, final UserPreferences userPreferences) throws IOException {
        try {
            float f = (float)dimension.width / (float)dimension.height;
            float f2 = f < 0.5f || (double)f > 2.0 ? (float)Math.sqrt(262144.0f / (float)((long)dimension.width * (long)dimension.height)) : (f < 1.0f ? 512.0f / (float)dimension.height : 512.0f / (float)dimension.width);
            final int n = Math.round((float)dimension.width * f2);
            final int n2 = Math.round((float)dimension.height * f2);
            final AtomicInteger atomicInteger = new AtomicInteger(2);
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    String string = userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "reduceImageSize.title", new Object[0]);
                    String string2 = userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "reduceImageSize.message", dimension.width, dimension.height, n, n2);
                    String string3 = userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "reduceImageSize.reduceSize", new Object[0]);
                    String string4 = userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "reduceImageSize.keepUnchanged", new Object[0]);
                    String string5 = userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "reduceImageSize.cancel", new Object[0]);
                    atomicInteger.set(JOptionPane.showOptionDialog(SwingUtilities.getRootPane(ImportedTextureWizardStepsPanel.this), string2, string, 1, 3, null, new Object[]{string3, string4, string5}, string4));
                }
            });
            if (atomicInteger.get() == 2) {
                return null;
            }
            if (atomicInteger.get() == 0) {
                this.updatePreviewComponentsWithWaitImage(userPreferences);
                InputStream inputStream = content.openStream();
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                inputStream.close();
                if (bufferedImage != null) {
                    BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
                    Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.drawImage(bufferedImage, AffineTransform.getScaleInstance(f2, f2), null);
                    graphics2D.dispose();
                    File file = OperatingSystem.createTemporaryFile("texture", ".tmp");
                    ImageIO.write((RenderedImage)bufferedImage2, bufferedImage.getTransparency() == 1 ? "JPEG" : "PNG", file);
                    return new TemporaryURLContent(file.toURI().toURL());
                }
            }
            return content;
        }
        catch (InterruptedException interruptedException) {
            return content;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return content;
        }
        catch (IOException iOException) {
            this.updatePreviewComponentsImage(null);
            throw iOException;
        }
    }

    private BufferedImage readImage(Content content, UserPreferences userPreferences) throws IOException {
        try {
            this.updatePreviewComponentsWithWaitImage(userPreferences);
            InputStream inputStream = content.openStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            if (bufferedImage != null) {
                this.updatePreviewComponentsImage(bufferedImage);
                return bufferedImage;
            }
            throw new IOException();
        }
        catch (IOException iOException) {
            this.updatePreviewComponentsImage(null);
            throw iOException;
        }
    }

    private void updatePreviewComponentsWithWaitImage(UserPreferences userPreferences) throws IOException {
        if (waitImage == null) {
            waitImage = ImageIO.read(ImportedTextureWizardStepsPanel.class.getResource(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "waitIcon", new Object[0])));
        }
        this.updatePreviewComponentsImage(waitImage);
    }

    private void updatePreviewComponentsImage(final BufferedImage bufferedImage) {
        if (EventQueue.isDispatchThread()) {
            this.imageChoicePreviewComponent.setImage(bufferedImage);
            this.attributesPreviewComponent.setImage(bufferedImage);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ImportedTextureWizardStepsPanel.this.updatePreviewComponentsImage(bufferedImage);
                }
            });
        }
    }

    private void setImageChangeTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChangeLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "imageChangeButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChangeButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void setImageChoiceTexts(UserPreferences userPreferences) {
        this.imageChoiceOrChangeLabel.setText(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceLabel.text", new Object[0]));
        this.imageChoiceOrChangeButton.setText(SwingTools.getLocalizedLabelText(userPreferences, ImportedTextureWizardStepsPanel.class, "imageChoiceButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.imageChoiceOrChangeButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private String showImageChoiceDialog(UserPreferences userPreferences, ContentManager contentManager) {
        return contentManager.showOpenDialog(this, userPreferences.getLocalizedString(ImportedTextureWizardStepsPanel.class, "imageChoiceDialog.title", new Object[0]), ContentManager.ContentType.IMAGE);
    }

    private void updateAttributesPreviewImage() {
        BufferedImage bufferedImage = this.attributesPreviewComponent.getImage();
        if (bufferedImage == null || bufferedImage == this.imageChoicePreviewComponent.getImage()) {
            bufferedImage = new BufferedImage(IMAGE_PREFERRED_SIZE, IMAGE_PREFERRED_SIZE, 1);
            this.attributesPreviewComponent.setImage(bufferedImage);
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(0, 0, IMAGE_PREFERRED_SIZE, IMAGE_PREFERRED_SIZE);
        BufferedImage bufferedImage2 = this.imageChoicePreviewComponent.getImage();
        if (bufferedImage2 != null) {
            graphics2D.setPaint(new TexturePaint(bufferedImage2, new Rectangle2D.Float(0.0f, 0.0f, this.controller.getWidth() / 250.0f * (float)IMAGE_PREFERRED_SIZE, this.controller.getHeight() / 250.0f * (float)IMAGE_PREFERRED_SIZE)));
            graphics2D.fillRect(0, 0, IMAGE_PREFERRED_SIZE, IMAGE_PREFERRED_SIZE);
        }
        graphics2D.dispose();
        this.attributesPreviewComponent.repaint();
    }
}

