/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom.dumpbasketj;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;

public class Main {
    static boolean doout = true;
    static int ind = 0;

    static void inc_ind() {
        ++ind;
    }

    static void dec_ind() {
        --ind;
    }

    static String get_ind() {
        StringBuffer buffer = new StringBuffer(100);
        int i = 0;
        while (i < ind) {
            buffer.append(' ');
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    static String encodeConsistency(int consistency) {
        String ret;
        switch (consistency) {
            case 1: {
                ret = "INCOMPLETE";
                break;
            }
            case 2: {
                ret = "INCONSISTENT";
                break;
            }
            case 3: {
                ret = "ADAPTED";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    static void dumpobjhead(String prefix, IomObject obj) {
        String tag = obj.getobjecttag();
        String oid = obj.getobjectoid();
        String consistency = Main.encodeConsistency(obj.getobjectconsistency());
        if (doout) {
            System.out.print(String.valueOf(Main.get_ind()) + prefix + ": " + tag);
        }
        if (oid != null && doout) {
            System.out.print(", oid <" + oid + ">");
        }
        if (consistency != null && doout) {
            System.out.print(", consistency <" + consistency + ">");
        }
        if (doout) {
            System.out.println();
        }
    }

    static void dumpobject(IomObject obj) {
        Main.inc_ind();
        int i = 0;
        while (i < obj.getattrcount()) {
            String tag = obj.getattrname(i);
            String value = obj.getattrvalue(tag);
            if (value == null) {
                int attri = 0;
                while (attri < obj.getattrvaluecount(tag)) {
                    IomObject structvalue = obj.getattrobj(tag, attri);
                    String refoid = structvalue.getobjectrefoid();
                    if (refoid != null) {
                        long orderPos = structvalue.getobjectreforderpos();
                        Main.inc_ind();
                        if (orderPos != 0L) {
                            if (doout) {
                                System.out.println(String.valueOf(Main.get_ind()) + tag + "=REF " + refoid + ", ORDER_POS " + orderPos);
                            }
                        } else if (doout) {
                            System.out.println(String.valueOf(Main.get_ind()) + tag + "=REF " + refoid);
                        }
                        if (structvalue.getobjecttag() != null) {
                            Main.dumpobject(structvalue);
                        }
                        Main.dec_ind();
                    } else if (structvalue.getobjecttag() != null) {
                        Main.inc_ind();
                        Main.dumpobjhead(tag, structvalue);
                        Main.dumpobject(structvalue);
                        Main.dec_ind();
                    }
                    ++attri;
                }
            } else {
                Main.inc_ind();
                if (doout) {
                    System.out.println(String.valueOf(Main.get_ind()) + tag + "=" + value);
                }
                Main.dec_ind();
            }
            ++i;
        }
        Main.dec_ind();
    }

    public static void main(String[] args) {
        long startTime;
        block43: {
            EhiLogger.getInstance().setTraceFilter(false);
            startTime = System.currentTimeMillis();
            if (args.length < 1) {
                System.err.println("dumbaskets [-oid id] file.xml");
                return;
            }
            int startxml = 0;
            String oid = null;
            boolean dumpall = false;
            if (args[0].equals("-oid")) {
                startxml += 2;
                oid = args[1];
            }
            if (args[0].equals("-all")) {
                ++startxml;
                dumpall = true;
            }
            String xmlFile = args[startxml];
            XtfReader reader = null;
            try {
                reader = new XtfReader(new File(xmlFile));
                IoxEvent event = reader.read();
                StartBasketEvent basket = null;
                while (event != null) {
                    if (event instanceof StartTransferEvent) {
                        if (dumpall) {
                            if (doout) {
                                System.out.println(String.valueOf(Main.get_ind()) + "StartTransferEvent");
                            }
                            Main.inc_ind();
                        }
                    } else if (event instanceof EndTransferEvent) {
                        if (dumpall) {
                            Main.dec_ind();
                            if (doout) {
                                System.out.println(String.valueOf(Main.get_ind()) + "EndTransferEvent");
                            }
                        }
                    } else if (event instanceof StartBasketEvent) {
                        basket = (StartBasketEvent)event;
                        if (oid != null && oid.equals(basket.getBid())) {
                            if (doout) {
                                System.out.println(String.valueOf(Main.get_ind()) + "StartBasketEvent");
                            }
                        } else {
                            if (doout) {
                                System.out.println(String.valueOf(Main.get_ind()) + "StartBasketEvent " + basket.getType() + ", bid " + basket.getBid());
                            }
                            basket = null;
                        }
                        Main.inc_ind();
                    } else if (event instanceof EndBasketEvent) {
                        Main.dec_ind();
                        if ((dumpall || basket != null) && doout) {
                            System.out.println(String.valueOf(Main.get_ind()) + "EndBasketEvent");
                        }
                        basket = null;
                    } else if (event instanceof ObjectEvent) {
                        IomObject obj = ((ObjectEvent)event).getIomObject();
                        if (dumpall) {
                            Main.inc_ind();
                            Main.dumpobjhead("object", obj);
                            Main.dumpobject(obj);
                            Main.dec_ind();
                        } else if (basket != null) {
                            Main.inc_ind();
                            Main.dumpobjhead("object", obj);
                            Main.dec_ind();
                        } else if (oid != null && oid.equals(obj.getobjectoid())) {
                            Main.inc_ind();
                            Main.dumpobjhead("object", obj);
                            Main.dumpobject(obj);
                            Main.dec_ind();
                        }
                    }
                    event = reader.read();
                }
            }
            catch (IoxException ex) {
                EhiLogger.logError(ex);
                if (reader == null) break block43;
                try {
                    reader.close();
                }
                catch (IoxException ex2) {
                    EhiLogger.logError(ex2);
                }
                reader = null;
                break block43;
            }
            catch (Throwable ex) {
                try {
                    EhiLogger.logError(ex);
                    break block43;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IoxException ex3) {
                            EhiLogger.logError(ex3);
                        }
                        reader = null;
                    }
                }
            }
            if (reader == null) break block43;
            try {
                reader.close();
            }
            catch (IoxException ex) {
                EhiLogger.logError(ex);
            }
            reader = null;
        }
        long endTime = System.currentTimeMillis();
        System.out.println(String.valueOf(endTime - startTime) + "ms");
    }
}

