/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.basics.geom.GeometricFunctions;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.relation.helper.ResizableObject;
import com.baselet.element.sticking.PointDoubleIndexed;
import java.util.ArrayList;
import java.util.Arrays;

public class RelationDrawer {
    static final double SHORTEN_IF_ARROW = 1.0;
    static final double ARROWEND_DISPLACEMENT = 0.5;
    public static final double ARROW_LENGTH = 13.0;
    private static final double DIAGONAL_CROSS_LENGTH = 9.0;
    private static final double BOX_SIZE = 20.0;

    public static Rectangle drawBoxArrow(DrawHandler drawer, Line line, boolean drawOnStart, String matchedText, ResizableObject resizableObject) {
        double oldFontsize = drawer.getFontSize();
        drawer.setFontSize(12.0);
        double height = 20.0;
        double distance = drawer.getDistanceBorderToText();
        double width = Math.max(20.0, drawer.textWidth(matchedText) + distance * 2.0);
        PointDoubleIndexed point = (PointDoubleIndexed)line.getPoint(drawOnStart);
        Rectangle r = new Rectangle(point.getX() - width / 2.0, point.getY() - height / 2.0, width, height);
        drawer.drawRectangle(r);
        int arrow = 4;
        ColorOwn oldBgColor = drawer.getBackgroundColor();
        drawer.setBackgroundColor(drawer.getForegroundColor());
        if (matchedText.equals("^")) {
            PointDouble start = new PointDouble(point.getX(), point.getY() - (double)arrow);
            drawer.drawLines(start, new PointDouble(point.getX() + (double)arrow, point.getY() + (double)arrow), new PointDouble(point.getX() - (double)arrow, point.getY() + (double)arrow), start);
        } else if (matchedText.equals("<")) {
            PointDouble start = new PointDouble(point.getX() - (double)arrow, point.getY());
            drawer.drawLines(start, new PointDouble(point.getX() + (double)arrow, point.getY() - (double)arrow), new PointDouble(point.getX() + (double)arrow, point.getY() + (double)arrow), start);
        } else if (matchedText.equals(">")) {
            PointDouble start = new PointDouble(point.getX() + (double)arrow, point.getY());
            drawer.drawLines(start, new PointDouble(point.getX() - (double)arrow, point.getY() - (double)arrow), new PointDouble(point.getX() - (double)arrow, point.getY() + (double)arrow), start);
        } else if (matchedText.equals("v")) {
            PointDouble start = new PointDouble(point.getX() - (double)arrow, point.getY() - (double)arrow);
            drawer.drawLines(start, new PointDouble(point.getX() + (double)arrow, point.getY() - (double)arrow), new PointDouble(point.getX(), point.getY() + (double)arrow), start);
        } else if (matchedText.equals("=")) {
            int dist = 2;
            int size = 6;
            drawer.drawLines(new PointDouble(point.getX() - (double)size, point.getY() - (double)dist), new PointDouble(point.getX() + (double)size, point.getY() - (double)dist), new PointDouble(point.getX(), point.getY() - (double)size));
            drawer.drawLines(new PointDouble(point.getX() + (double)size, point.getY() + (double)dist), new PointDouble(point.getX() - (double)size, point.getY() + (double)dist), new PointDouble(point.getX(), point.getY() + (double)size));
        } else {
            drawer.print(matchedText, new PointDouble(point.getX() - width / 2.0 + distance, point.getY() + drawer.textHeightMax() / 2.0), AlignHorizontal.LEFT);
            resizableObject.setPointMinSize(point.getIndex(), new Rectangle(-width / 2.0, -height / 2.0, width, height));
        }
        drawer.setFontSize(oldFontsize);
        drawer.setBackgroundColor(oldBgColor);
        return r;
    }

    public static void drawArrowToLine(DrawHandler drawer, Line line, boolean drawOnStart, ArrowEndType arrowEndType, boolean fillBody, boolean invertArrow) {
        RelationDrawer.drawArrowToLine(line.getPointOnLineWithDistanceFrom(drawOnStart, 0.5), drawer, line, drawOnStart, arrowEndType, fillBody, invertArrow);
    }

    public static void drawArrowToLine(PointDouble point, DrawHandler drawer, Line line, boolean drawOnStart, ArrowEndType arrowEndType, boolean fillBody, boolean invertArrow) {
        if (invertArrow) {
            point = line.getPointOnLineWithDistanceFrom(drawOnStart, 13.0);
            drawOnStart = !drawOnStart;
        }
        int arrowAngle = drawOnStart ? 150 : 30;
        PointDouble p1 = RelationDrawer.calcPointArrow(point, line.getAngleOfSlope() - (double)arrowAngle);
        PointDouble p2 = RelationDrawer.calcPointArrow(point, line.getAngleOfSlope() + (double)arrowAngle);
        ArrayList<PointDouble> points = new ArrayList<PointDouble>(Arrays.asList(p1, point));
        if (arrowEndType == ArrowEndType.MEASURE) {
            PointDouble m1 = RelationDrawer.calcPoint(point, line.getAngleOfSlope() + 90.0, 10.0);
            PointDouble m2 = RelationDrawer.calcPoint(point, line.getAngleOfSlope() - 90.0, 10.0);
            points.add(m1);
            points.add(m2);
            points.add(point);
        }
        points.add(p2);
        if (arrowEndType == ArrowEndType.CLOSED) {
            points.add(p1);
        } else if (arrowEndType == ArrowEndType.DIAMOND) {
            double lengthDiamond = GeometricFunctions.getDistanceBetweenLineAndPoint(p1, p2, point) * 2.0;
            PointDouble pDiamond = drawOnStart ? line.getPointOnLineWithDistanceFrom(true, lengthDiamond) : line.getPointOnLineWithDistanceFrom(false, lengthDiamond);
            points.add(pDiamond);
            points.add(p1);
        }
        if (fillBody) {
            ColorOwn bgColor = drawer.getBackgroundColor();
            drawer.setBackgroundColor(drawer.getForegroundColor());
            drawer.drawLines(points);
            drawer.setBackgroundColor(bgColor);
        } else {
            drawer.drawLines(points);
        }
    }

    private static PointDouble calcPointArrow(PointDouble point, double angleTotal) {
        return RelationDrawer.calcPoint(point, angleTotal, 13.0);
    }

    private static PointDouble calcPointCross(PointDouble point, double angleTotal) {
        return RelationDrawer.calcPoint(point, angleTotal, 9.0);
    }

    private static PointDouble calcPoint(PointDouble point, double angleTotal, double length) {
        double x = point.x + length * Math.cos(Math.toRadians(angleTotal));
        double y = point.y + length * Math.sin(Math.toRadians(angleTotal));
        return new PointDouble(x, y);
    }

    public static void drawCircle(DrawHandler drawer, Line line, boolean drawOnStart, ResizableObject resizableObject, Direction openDirection, boolean drawCross) {
        PointDoubleIndexed point = (PointDoubleIndexed)line.getPoint(drawOnStart);
        if (openDirection == null) {
            drawer.drawCircle(point.getX(), point.getY(), 10.0);
        } else if (openDirection == Direction.LEFT || openDirection == Direction.RIGHT) {
            ColorOwn bg = drawer.getBackgroundColor();
            drawer.setBackgroundColor(ColorOwn.TRANSPARENT);
            double circleRadius = 30.0;
            Direction directionOfCircle = line.getDirectionOfLine(drawOnStart);
            if (directionOfCircle == Direction.RIGHT) {
                drawer.drawArc(point.getX(), point.getY() - circleRadius / 2.0, circleRadius, circleRadius, 90.0, 180.0, true);
                resizableObject.setPointMinSize(point.getIndex(), new Rectangle(-circleRadius / 4.0, -circleRadius / 2.0, circleRadius * 0.75, circleRadius));
            } else if (directionOfCircle == Direction.DOWN) {
                drawer.drawArc(point.getX() - circleRadius / 2.0, point.getY(), circleRadius, circleRadius, 0.0, 180.0, true);
                resizableObject.setPointMinSize(point.getIndex(), new Rectangle(-circleRadius / 2.0, -circleRadius / 4.0, circleRadius, circleRadius * 0.75));
            } else if (directionOfCircle == Direction.LEFT) {
                drawer.drawArc(point.getX() - circleRadius, point.getY() - circleRadius / 2.0, circleRadius, circleRadius, -90.0, 180.0, true);
                resizableObject.setPointMinSize(point.getIndex(), new Rectangle(-circleRadius / 2.0, -circleRadius / 2.0, circleRadius * 0.75, circleRadius));
            } else {
                drawer.drawArc(point.getX() - circleRadius / 2.0, point.getY() - circleRadius, circleRadius, circleRadius, -180.0, 180.0, true);
                resizableObject.setPointMinSize(point.getIndex(), new Rectangle(-circleRadius / 2.0, -circleRadius / 2.0, circleRadius, circleRadius * 0.75));
            }
            drawer.setBackgroundColor(bg);
        }
        if (drawCross) {
            double length = 5.0;
            drawer.drawLine(point.getX() - length, point.getY(), point.getX() + length, point.getY());
            drawer.drawLine(point.getX(), point.getY() - length, point.getX(), point.getY() + length);
        }
    }

    public static void drawDiagonalCross(DrawHandler drawer, Line line, boolean drawOnStart, ResizableObject resizableObject, Direction openDirection, boolean drawCross) {
        PointDouble p = line.getPointOnLineWithDistanceFrom(drawOnStart, 13.0);
        drawer.drawLines(RelationDrawer.calcPointCross(p, line.getAngleOfSlope() + 45.0), RelationDrawer.calcPointCross(p, line.getAngleOfSlope() - 135.0));
        drawer.drawLines(RelationDrawer.calcPointCross(p, line.getAngleOfSlope() - 45.0), RelationDrawer.calcPointCross(p, line.getAngleOfSlope() + 135.0));
    }

    public static enum ArrowEndType {
        NORMAL,
        CLOSED,
        DIAMOND,
        MEASURE;

    }
}

