/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.PaintConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.control.Labeled;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LabeledText
extends Text {
    private final Labeled labeled;

    public LabeledText(Labeled labeled) {
        if (labeled == null) {
            throw new IllegalArgumentException("labeled cannot be null");
        }
        this.labeled = labeled;
        this.setFill(this.labeled.getTextFill());
        this.setFont(this.labeled.getFont());
        this.setTextAlignment(this.labeled.getTextAlignment());
        this.setUnderline(this.labeled.isUnderline());
        this.fillProperty().bind(this.labeled.textFillProperty());
        this.fontProperty().bind(this.labeled.fontProperty());
        this.textAlignmentProperty().bind(this.labeled.textAlignmentProperty());
        this.underlineProperty().bind(this.labeled.underlineProperty());
        this.getStyleClass().addAll((String[])new String[]{"text"});
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return LabeledText.impl_CSS_STYLEABLES();
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<LabeledText, Font> FONT = new StyleableProperty.FONT<LabeledText>("-fx-font", Font.getDefault()){

            @Override
            public void set(LabeledText labeledText, Font font, Stylesheet.Origin origin) {
                ObjectProperty<Font> objectProperty = labeledText.labeled.fontProperty();
                Stylesheet.Origin origin2 = StyleableProperty.getOrigin(objectProperty);
                if (origin2 == null || origin == null || origin2.compareTo(origin) <= 0) {
                    super.set(labeledText, font, origin);
                }
            }

            @Override
            public boolean isSettable(LabeledText labeledText) {
                return !labeledText.labeled.fontProperty().isBound();
            }

            @Override
            public WritableValue<Font> getWritableValue(LabeledText labeledText) {
                return labeledText.labeled.fontProperty();
            }
        };
        private static final StyleableProperty<LabeledText, Paint> FILL = new StyleableProperty<LabeledText, Paint>("-fx-fill", (StyleConverter)PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public void set(LabeledText labeledText, Paint paint, Stylesheet.Origin origin) {
                ObjectProperty<Paint> objectProperty = labeledText.labeled.textFillProperty();
                Stylesheet.Origin origin2 = StyleableProperty.getOrigin(objectProperty);
                if (origin2 == null || origin == null || origin2.compareTo(origin) <= 0) {
                    super.set(labeledText, paint, origin);
                }
            }

            @Override
            public boolean isSettable(LabeledText labeledText) {
                return !labeledText.labeled.textFillProperty().isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(LabeledText labeledText) {
                return labeledText.labeled.textFillProperty();
            }
        };
        private static final StyleableProperty<LabeledText, TextAlignment> TEXT_ALIGNMENT = new StyleableProperty<LabeledText, TextAlignment>("-fx-text-alignment", new EnumConverter(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public void set(LabeledText labeledText, TextAlignment textAlignment, Stylesheet.Origin origin) {
                ObjectProperty<TextAlignment> objectProperty = labeledText.labeled.textAlignmentProperty();
                Stylesheet.Origin origin2 = StyleableProperty.getOrigin(objectProperty);
                if (origin2 == null || origin == null || origin2.compareTo(origin) <= 0) {
                    super.set(labeledText, textAlignment, origin);
                }
            }

            @Override
            public boolean isSettable(LabeledText labeledText) {
                return !labeledText.labeled.textAlignmentProperty().isBound();
            }

            @Override
            public WritableValue<TextAlignment> getWritableValue(LabeledText labeledText) {
                return labeledText.labeled.textAlignmentProperty();
            }
        };
        private static final StyleableProperty<LabeledText, Boolean> UNDERLINE = new StyleableProperty<LabeledText, Boolean>("-fx-underline", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public void set(LabeledText labeledText, Boolean bl, Stylesheet.Origin origin) {
                BooleanProperty booleanProperty = labeledText.labeled.underlineProperty();
                Stylesheet.Origin origin2 = StyleableProperty.getOrigin(booleanProperty);
                if (origin2 == null || origin == null || origin2.compareTo(origin) <= 0) {
                    super.set(labeledText, bl, origin);
                }
            }

            @Override
            public boolean isSettable(LabeledText labeledText) {
                return !labeledText.labeled.underlineProperty().isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(LabeledText labeledText) {
                return labeledText.labeled.underlineProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Text.impl_CSS_STYLEABLES());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string = ((StyleableProperty)arrayList.get(i)).getProperty();
                if ("-fx-fill".equals(string)) {
                    arrayList.set(i, FILL);
                    continue;
                }
                if ("-fx-font".equals(string)) {
                    arrayList.set(i, FONT);
                    continue;
                }
                if ("-fx-text-alignment".equals(string)) {
                    arrayList.set(i, TEXT_ALIGNMENT);
                    continue;
                }
                if (!"-fx-underline".equals(string)) continue;
                arrayList.set(i, UNDERLINE);
            }
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

