/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableAlert
extends ParosAbstractTable
implements TableAlert {
    private static final String TABLE_NAME = "ALERT";
    private static final String ALERT_INDEX = "ALERT_INDEX";
    private static final String ALERTID = "ALERTID";
    private static final String SCANID = "SCANID";
    private static final String PLUGINID = "PLUGINID";
    private static final String ALERT = "ALERT";
    private static final String RISK = "RISK";
    private static final String RELIABILITY = "RELIABILITY";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String URI = "URI";
    private static final String PARAM = "PARAM";
    private static final String ATTACK = "ATTACK";
    private static final String OTHERINFO = "OTHERINFO";
    private static final String SOLUTION = "SOLUTION";
    private static final String REFERENCE = "REFERENCE";
    private static final String EVIDENCE = "EVIDENCE";
    private static final String CWEID = "CWEID";
    private static final String WASCID = "WASCID";
    private static final String HISTORYID = "HISTORYID";
    private static final String SOURCEHISTORYID = "SOURCEHISTORYID";
    private static final String SOURCEID = "SOURCEID";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psDeleteAlert = null;
    private PreparedStatement psDeleteAllAlerts = null;
    private PreparedStatement psUpdate = null;
    private PreparedStatement psUpdateHistoryIds = null;
    private PreparedStatement psGetAlertsForHistoryId = null;

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            this.updateTable(connection);
            this.psRead = connection.prepareStatement("SELECT TOP 1 * FROM ALERT WHERE ALERTID = ?");
            this.psInsert = connection.prepareStatement("INSERT INTO ALERT (SCANID,PLUGINID,ALERT,RISK,RELIABILITY,DESCRIPTION,URI,PARAM,ATTACK,OTHERINFO,SOLUTION,REFERENCE,EVIDENCE,CWEID,WASCID,HISTORYID,SOURCEHISTORYID,SOURCEID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.psGetIdLastInsert = connection.prepareCall("CALL IDENTITY();");
            this.psDeleteAlert = connection.prepareStatement("DELETE FROM ALERT WHERE ALERTID = ?");
            this.psDeleteAllAlerts = connection.prepareStatement("DELETE FROM ALERT");
            this.psUpdate = connection.prepareStatement("UPDATE ALERT SET ALERT = ?, RISK = ?,RELIABILITY = ?,DESCRIPTION = ?,URI = ?,PARAM = ?,ATTACK = ?,OTHERINFO = ?,SOLUTION = ?,REFERENCE = ?, EVIDENCE = ?, CWEID = ?, WASCID = ?, SOURCEHISTORYID = ? WHERE ALERTID = ?");
            this.psUpdateHistoryIds = connection.prepareStatement("UPDATE ALERT SET HISTORYID = ?, SOURCEHISTORYID = ? WHERE ALERTID = ?");
            this.psGetAlertsForHistoryId = connection.prepareStatement("SELECT * FROM ALERT WHERE SOURCEHISTORYID = ?");
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private void updateTable(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasColumn(connection, "ALERT", SOURCEHISTORYID)) {
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE ALERT ADD COLUMN SOURCEHISTORYID INT DEFAULT 0"));
            }
            if (!DbUtils.hasColumn(connection, "ALERT", ATTACK)) {
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE ALERT ADD COLUMN ATTACK VARCHAR(32768) DEFAULT ''"));
            }
            if (!DbUtils.hasColumn(connection, "ALERT", EVIDENCE)) {
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE ALERT ADD COLUMN EVIDENCE VARCHAR(16777216) DEFAULT ''"));
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE ALERT ADD COLUMN CWEID INT DEFAULT -1"));
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE ALERT ADD COLUMN WASCID INT DEFAULT -1"));
            }
            if (!DbUtils.hasIndex(connection, "ALERT", ALERT_INDEX)) {
                DbUtils.executeAndClose(connection.prepareStatement("CREATE INDEX ALERT_INDEX ON ALERT (SOURCEHISTORYID)"));
            }
            if (!DbUtils.hasColumn(connection, "ALERT", SOURCEID)) {
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE ALERT ADD COLUMN SOURCEID INT DEFAULT 0"));
                DbUtils.executeAndClose(connection.prepareStatement("CREATE INDEX INDEX_ALERT_SOURCEID ON ALERT (SOURCEID)"));
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordAlert read(int n) throws DatabaseException {
        try {
            this.psRead.setInt(1, n);
            try (ResultSet resultSet = this.psRead.executeQuery();){
                RecordAlert recordAlert;
                RecordAlert recordAlert2 = recordAlert = this.build(resultSet);
                return recordAlert2;
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception);
        }
    }

    @Override
    public synchronized RecordAlert write(int n, int n2, String string, int n3, int n4, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n5, int n6, int n7, int n8, int n9) throws DatabaseException {
        try {
            int n10;
            this.psInsert.setInt(1, n);
            this.psInsert.setInt(2, n2);
            this.psInsert.setString(3, string);
            this.psInsert.setInt(4, n3);
            this.psInsert.setInt(5, n4);
            this.psInsert.setString(6, string2);
            this.psInsert.setString(7, string3);
            this.psInsert.setString(8, string4);
            this.psInsert.setString(9, string5);
            this.psInsert.setString(10, string6);
            this.psInsert.setString(11, string7);
            this.psInsert.setString(12, string8);
            this.psInsert.setString(13, string9);
            this.psInsert.setInt(14, n5);
            this.psInsert.setInt(15, n6);
            this.psInsert.setInt(16, n7);
            this.psInsert.setInt(17, n8);
            this.psInsert.setInt(18, n9);
            this.psInsert.executeUpdate();
            try (ResultSet resultSet = this.psGetIdLastInsert.executeQuery();){
                resultSet.next();
                n10 = resultSet.getInt(1);
            }
            return this.read(n10);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private RecordAlert build(ResultSet resultSet) throws DatabaseException {
        try {
            RecordAlert recordAlert = null;
            if (resultSet.next()) {
                recordAlert = new RecordAlert(resultSet.getInt(ALERTID), resultSet.getInt(SCANID), resultSet.getInt(PLUGINID), resultSet.getString("ALERT"), resultSet.getInt(RISK), resultSet.getInt(RELIABILITY), resultSet.getString(DESCRIPTION), resultSet.getString(URI), resultSet.getString(PARAM), resultSet.getString(ATTACK), resultSet.getString(OTHERINFO), resultSet.getString(SOLUTION), resultSet.getString(REFERENCE), resultSet.getString(EVIDENCE), resultSet.getInt(CWEID), resultSet.getInt(WASCID), resultSet.getInt(HISTORYID), resultSet.getInt(SOURCEHISTORYID), resultSet.getInt(SOURCEID));
            }
            return recordAlert;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector<Integer> getAlertListByScan(int n) throws DatabaseException {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT WHERE SCANID = ?");){
            Vector<Integer> vector = new Vector<Integer>();
            preparedStatement.setInt(1, n);
            try (Object object = preparedStatement.executeQuery();){
                while (object.next()) {
                    vector.add(object.getInt(ALERTID));
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Vector<Integer> getAlertListBySession(long l) throws DatabaseException {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT INNER JOIN SCAN ON ALERT.SCANID = SCAN.SCANID WHERE SESSIONID = ?");){
            Vector<Integer> vector = new Vector<Integer>();
            preparedStatement.setLong(1, l);
            try (Object object = preparedStatement.executeQuery();){
                while (object.next()) {
                    int n = object.getInt(ALERTID);
                    vector.add(n);
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void deleteAlert(int n) throws DatabaseException {
        try {
            this.psDeleteAlert.setInt(1, n);
            this.psDeleteAlert.execute();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public int deleteAllAlerts() throws DatabaseException {
        try {
            return this.psDeleteAllAlerts.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void update(int n, String string, int n2, int n3, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n4, int n5, int n6) throws DatabaseException {
        try {
            this.psUpdate.setString(1, string);
            this.psUpdate.setInt(2, n2);
            this.psUpdate.setInt(3, n3);
            this.psUpdate.setString(4, string2);
            this.psUpdate.setString(5, string3);
            this.psUpdate.setString(6, string4);
            this.psUpdate.setString(7, string5);
            this.psUpdate.setString(8, string6);
            this.psUpdate.setString(9, string7);
            this.psUpdate.setString(10, string8);
            this.psUpdate.setString(11, string9);
            this.psUpdate.setInt(12, n4);
            this.psUpdate.setInt(13, n5);
            this.psUpdate.setInt(14, n6);
            this.psUpdate.setInt(15, n);
            this.psUpdate.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void updateHistoryIds(int n, int n2, int n3) throws DatabaseException {
        try {
            this.psUpdateHistoryIds.setInt(1, n2);
            this.psUpdateHistoryIds.setInt(2, n3);
            this.psUpdateHistoryIds.setInt(3, n);
            this.psUpdateHistoryIds.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized List<RecordAlert> getAlertsBySourceHistoryId(int n) throws DatabaseException {
        try {
            ArrayList<RecordAlert> arrayList = new ArrayList<RecordAlert>();
            this.psGetAlertsForHistoryId.setLong(1, n);
            try (ResultSet resultSet = this.psGetAlertsForHistoryId.executeQuery();){
                RecordAlert recordAlert = this.build(resultSet);
                while (recordAlert != null) {
                    arrayList.add(recordAlert);
                    recordAlert = this.build(resultSet);
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Vector<Integer> getAlertList() throws DatabaseException {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT ALERTID FROM ALERT");){
            Vector<Integer> vector = new Vector<Integer>();
            try (Object object = preparedStatement.executeQuery();){
                while (object.next()) {
                    vector.add(object.getInt(ALERTID));
                }
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }
}

