/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class HttpRequestHeader
extends HttpHeader {
    private static final long serialVersionUID = 4156598327921777493L;
    private static final Logger log = Logger.getLogger(HttpRequestHeader.class);
    public static final String OPTIONS = "OPTIONS";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    public static final String CONNECT = "CONNECT";
    public static final String[] METHODS = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "CONNECT"};
    public static final String HOST = "Host";
    private static final Pattern patternRequestLine = Pattern.compile("(\\w+) +([^\\r\\n]+) +(HTTP/\\d+\\.\\d+)", 2);
    private static final Pattern patternImage = Pattern.compile("\\.(bmp|ico|jpg|jpeg|gif|tiff|tif|png)\\z", 2);
    private static final Pattern patternPartialRequestLine = Pattern.compile("\\A *(OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT)\\b", 2);
    private String mMethod;
    private URI mUri;
    private String mHostName;
    private InetAddress senderAddress;
    private int mHostPort;
    private boolean mIsSecure;
    private static final String DELIM = "<>#\"";
    private static final String UNWISE = "{}|\\^[]`";
    private static final String DELIM_UNWISE = "<>#\"{}|\\^[]`";

    public HttpRequestHeader() {
        this.mMethod = "";
        this.mHostName = "";
        this.mHostPort = 80;
    }

    public HttpRequestHeader(String string, boolean bl) throws HttpMalformedHeaderException {
        this.setMessage(string, bl);
    }

    public HttpRequestHeader(String string) throws HttpMalformedHeaderException {
        this.setMessage(string);
    }

    @Override
    public void clear() {
        super.clear();
        this.mMethod = "";
        this.mUri = null;
        this.mHostName = "";
        this.setHostPort(-1);
    }

    public HttpRequestHeader(String string, URI uRI, String string2) throws HttpMalformedHeaderException {
        this(string, uRI, string2, null);
    }

    public HttpRequestHeader(String string, URI uRI, String string2, ConnectionParam connectionParam) throws HttpMalformedHeaderException {
        this(string + " " + uRI.toString() + " " + string2.toUpperCase() + "\r\n" + "\r\n");
        try {
            this.setHeader(HOST, uRI.getHost() + (uRI.getPort() > 0 ? ":" + Integer.toString(uRI.getPort()) : ""));
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        String string3 = connectionParam != null ? connectionParam.getDefaultUserAgent() : "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)";
        this.setHeader("User-Agent", string3);
        this.setHeader("Pragma", "no-cache");
        if (string2.equalsIgnoreCase("HTTP/1.1")) {
            this.setHeader("Cache-Control", "no-cache");
        }
        if (string.equalsIgnoreCase(POST) || string.equalsIgnoreCase(PUT)) {
            this.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        this.setHeader("Accept-Encoding", null);
        if (string2.equalsIgnoreCase("HTTP/1.1")) {
            this.setContentLength(0);
        }
    }

    public void setMessage(String string, boolean bl) throws HttpMalformedHeaderException {
        super.setMessage(string);
        try {
            this.parse(bl);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            this.mMalformedHeader = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Malformed header: " + string), (Throwable)httpMalformedHeaderException);
            }
            throw httpMalformedHeaderException;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException(exception.getMessage());
        }
    }

    @Override
    public void setMessage(String string) throws HttpMalformedHeaderException {
        this.setMessage(string, false);
    }

    public String getMethod() {
        return this.mMethod;
    }

    public void setMethod(String string) {
        this.mMethod = string.toUpperCase();
    }

    public URI getURI() {
        return this.mUri;
    }

    public void setURI(URI uRI) throws URIException {
        this.mUri = uRI.getScheme() == null || uRI.getScheme().equals("") ? new URI("http://" + this.getHeader(HOST) + "/" + this.mUri.toString(), true) : uRI;
        this.mIsSecure = uRI.getScheme().equalsIgnoreCase("https");
        this.setHostPort(this.mUri.getPort());
    }

    @Deprecated
    public boolean getSecure() {
        return this.mIsSecure;
    }

    public boolean isSecure() {
        return this.mIsSecure;
    }

    public void setSecure(boolean bl) throws URIException {
        this.mIsSecure = bl;
        if (this.mUri == null) {
            return;
        }
        URI uRI = this.mUri;
        if (this.isSecure() && this.mUri.getScheme().equalsIgnoreCase("http")) {
            uRI = new URI(this.mUri.toString().replaceFirst("http", "https"), true);
        } else if (!this.isSecure() && this.mUri.getScheme().equalsIgnoreCase("https")) {
            uRI = new URI(this.mUri.toString().replaceFirst("https", "http"), true);
        }
        if (uRI != this.mUri) {
            this.mUri = uRI;
            this.setHostPort(this.mUri.getPort());
        }
    }

    @Override
    public void setVersion(String string) {
        this.mVersion = string.toUpperCase();
    }

    @Override
    public int getContentLength() {
        if (this.mContentLength == -1) {
            return 0;
        }
        return this.mContentLength;
    }

    private void parse(boolean bl) throws URIException, HttpMalformedHeaderException {
        this.mIsSecure = bl;
        Matcher matcher = patternRequestLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Failed to find pattern: " + patternRequestLine);
        }
        this.mMethod = matcher.group(1);
        String string = matcher.group(2);
        this.mVersion = matcher.group(3);
        if (!(this.mVersion.equalsIgnoreCase("HTTP/0.9") || this.mVersion.equalsIgnoreCase("HTTP/1.0") || this.mVersion.equalsIgnoreCase("HTTP/1.1"))) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Unexpected version: " + this.mVersion);
        }
        this.mUri = HttpRequestHeader.parseURI(string);
        if (this.mUri.getScheme() == null || this.mUri.getScheme().equals("")) {
            this.mUri = new URI("http://" + this.getHeader(HOST) + this.mUri.toString(), true);
        }
        if (this.isSecure() && this.mUri.getScheme().equalsIgnoreCase("http")) {
            this.mUri = new URI(this.mUri.toString().replaceFirst("http", "https"), true);
        }
        if (this.mUri.getScheme().equalsIgnoreCase("https")) {
            this.setSecure(true);
        }
        if (this.mMethod.equalsIgnoreCase(CONNECT)) {
            String string2 = string;
            this.parseHostName(string2);
        } else {
            this.mHostName = this.mUri.getHost();
            this.setHostPort(this.mUri.getPort());
        }
    }

    private void parseHostName(String string) {
        if (string == null) {
            return;
        }
        int n = -1;
        int n2 = string.indexOf(58, 2);
        if (n2 > -1) {
            this.mHostName = string.substring(0, n2).trim();
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.mHostName = string.trim();
        }
        this.setHostPort(n);
    }

    public String getHostName() {
        String string;
        block2: {
            string = this.mHostName;
            try {
                string = this.mUri.getHost() != null ? this.mUri.getHost() : this.mHostName;
            }
            catch (URIException uRIException) {
                if (!log.isDebugEnabled()) break block2;
                log.warn((Object)uRIException);
            }
        }
        return string;
    }

    public int getHostPort() {
        return this.mHostPort;
    }

    private void setHostPort(int n) {
        this.mHostPort = n > -1 ? n : (this.isSecure() ? 443 : 80);
    }

    @Override
    public boolean isImage() {
        try {
            String string = this.getURI().getPath();
            if (string != null) {
                return patternImage.matcher(string).find();
            }
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        return false;
    }

    public static boolean isRequestLine(String string) {
        return patternPartialRequestLine.matcher(string).find();
    }

    @Override
    public String getPrimeHeader() {
        return this.getMethod() + " " + this.getURI().toString() + " " + this.getVersion();
    }

    public static URI parseURI(String string) throws URIException {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        char[] cArray = new char[1];
        for (int i = 0; i < n; ++i) {
            String string2;
            char c = string.charAt(i);
            if (DELIM_UNWISE.indexOf(c) >= 0) {
                cArray[0] = c;
                string2 = new String(cArray);
                try {
                    string2 = URLEncoder.encode(string2, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                stringBuilder.append(string2);
                continue;
            }
            if (c == '%') {
                try {
                    String string3 = string.substring(i + 1, i + 3);
                    Integer.parseInt(string3, 16);
                    stringBuilder.append(c);
                }
                catch (Exception exception) {
                    cArray[0] = c;
                    string2 = new String(cArray);
                    try {
                        string2 = URLEncoder.encode(string2, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    stringBuilder.append(string2);
                }
                continue;
            }
            if (c == ' ') {
                stringBuilder.append("%20");
                continue;
            }
            stringBuilder.append(c);
        }
        URI uRI = new URI(stringBuilder.toString(), true);
        return uRI;
    }

    public void setGetParams(TreeSet<HtmlParameter> treeSet) {
        if (this.mUri == null) {
            return;
        }
        if (treeSet.isEmpty()) {
            try {
                this.mUri.setQuery("");
            }
            catch (URIException uRIException) {
                log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (HtmlParameter htmlParameter : treeSet) {
            if (htmlParameter.getType() != HtmlParameter.Type.url) continue;
            stringBuilder.append(htmlParameter.getName());
            stringBuilder.append('=');
            stringBuilder.append(htmlParameter.getValue());
            stringBuilder.append('&');
        }
        if (stringBuilder.length() <= 2) {
            try {
                this.mUri.setQuery("");
            }
            catch (URIException uRIException) {
                log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
            }
            return;
        }
        String string = stringBuilder.substring(0, stringBuilder.length() - 1);
        try {
            this.mUri.setQuery(string);
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
    }

    public void setCookies(List<HttpCookie> list) {
        if (list.isEmpty()) {
            this.setHeader("Cookie", null);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (HttpCookie httpCookie : list) {
            stringBuilder.append(httpCookie.getName());
            stringBuilder.append('=');
            stringBuilder.append(httpCookie.getValue());
            stringBuilder.append("; ");
        }
        if (stringBuilder.length() <= 3) {
            this.setHeader("Cookie", null);
            return;
        }
        String string = stringBuilder.substring(0, stringBuilder.length() - 2);
        this.setHeader("Cookie", string);
    }

    public void setCookieParams(TreeSet<HtmlParameter> treeSet) {
        if (treeSet.isEmpty()) {
            this.setHeader("Cookie", null);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (HtmlParameter htmlParameter : treeSet) {
            if (htmlParameter.getType() != HtmlParameter.Type.cookie) continue;
            stringBuilder.append(htmlParameter.getName());
            stringBuilder.append('=');
            stringBuilder.append(htmlParameter.getValue());
            stringBuilder.append("; ");
        }
        if (stringBuilder.length() <= 3) {
            this.setHeader("Cookie", null);
            return;
        }
        String string = stringBuilder.substring(0, stringBuilder.length() - 2);
        this.setHeader("Cookie", string);
    }

    public TreeSet<HtmlParameter> getCookieParams() {
        TreeSet<HtmlParameter> treeSet = new TreeSet<HtmlParameter>();
        Vector<String> vector = this.getHeaders("Cookie");
        if (vector != null) {
            for (String string : vector) {
                String[] stringArray;
                if (string.toUpperCase().startsWith("Cookie".toUpperCase() + ":")) {
                    string = string.substring("Cookie".length() + 1);
                }
                for (String string2 : stringArray = string.split(";")) {
                    treeSet.add(new HtmlParameter(string2));
                }
            }
        }
        return treeSet;
    }

    public List<HttpCookie> getHttpCookies() {
        LinkedList<HttpCookie> linkedList = new LinkedList<HttpCookie>();
        TreeSet<HtmlParameter> treeSet = this.getCookieParams();
        for (HtmlParameter htmlParameter : treeSet) {
            if (htmlParameter.getName().isEmpty()) continue;
            try {
                linkedList.add(new HttpCookie(htmlParameter.getName(), htmlParameter.getValue()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)(illegalArgumentException.getMessage() + " " + htmlParameter.getName()));
            }
        }
        return linkedList;
    }

    public void setSenderAddress(InetAddress inetAddress) {
        this.senderAddress = inetAddress;
    }

    public InetAddress getSenderAddress() {
        return this.senderAddress;
    }
}

