/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableHistory
extends SqlAbstractTable
implements TableHistory {
    private static final String TABLE_NAME = DbSQL.getSQL("history.table_name");
    private static final String HISTORYID = DbSQL.getSQL("history.field.historyid");
    private static final String SESSIONID = DbSQL.getSQL("history.field.sessionid");
    private static final String HISTTYPE = DbSQL.getSQL("history.field.histtype");
    private static final String STATUSCODE = DbSQL.getSQL("history.field.statuscode");
    private static final String TIMESENTMILLIS = DbSQL.getSQL("history.field.timesentmillis");
    private static final String TIMEELAPSEDMILLIS = DbSQL.getSQL("history.field.timeelapsedmillis");
    private static final String REQHEADER = DbSQL.getSQL("history.field.reqheader");
    private static final String REQBODY = DbSQL.getSQL("history.field.reqbody");
    private static final String RESHEADER = DbSQL.getSQL("history.field.resheader");
    private static final String RESBODY = DbSQL.getSQL("history.field.resbody");
    private static final String TAG = DbSQL.getSQL("history.field.tag");
    private static final String NOTE = DbSQL.getSQL("history.field.note");
    private static final String RESPONSE_FROM_TARGET_HOST = DbSQL.getSQL("history.field.responsefromtargethost");
    private int lastInsertedIndex;
    private static boolean isExistStatusCode = false;
    private static final Logger log = Logger.getLogger(SqlTableHistory.class);
    private boolean bodiesAsBytes;
    int configuredrequestbodysize = -1;
    int configuredresponsebodysize = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            DatabaseParam databaseParam = new DatabaseParam();
            databaseParam.load(Constant.getInstance().FILE_CONFIG);
            this.configuredrequestbodysize = databaseParam.getRequestBodySize();
            this.configuredresponsebodysize = databaseParam.getResponseBodySize();
            this.bodiesAsBytes = true;
            if (DbSQL.getDbType().equals("hsqldb")) {
                this.updateTable(connection);
            }
            isExistStatusCode = DbUtils.hasColumn(connection, TABLE_NAME, STATUSCODE);
            int n = 0;
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(DbSQL.getSQL("history.ps.lastindex"));
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
            }
            finally {
                block25: {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {
                            if (!log.isDebugEnabled()) break block25;
                            log.debug((Object)sQLException.getMessage(), (Throwable)sQLException);
                        }
                    }
                }
            }
            this.lastInsertedIndex = n;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private void updateTable(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasColumn(connection, TABLE_NAME, TAG)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("history.ps.addtag")));
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, NOTE)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("history.ps.addnote")));
            }
            if (DbUtils.getColumnType(connection, TABLE_NAME, REQBODY) != 61) {
                this.bodiesAsBytes = false;
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, RESPONSE_FROM_TARGET_HOST)) {
                DbUtils.executeAndClose(connection.prepareStatement(DbSQL.getSQL("history.ps.addrespfromtarget")));
                DbUtils.executeUpdateAndClose(connection.prepareStatement(DbSQL.getSQL("history.ps.setrespfromtarget")));
            }
            int n = DbUtils.getColumnSize(connection, TABLE_NAME, REQBODY);
            int n2 = DbUtils.getColumnSize(connection, TABLE_NAME, RESBODY);
            try {
                PreparedStatement preparedStatement;
                if (n != this.configuredrequestbodysize && this.configuredrequestbodysize > 0) {
                    preparedStatement = connection.prepareStatement(DbSQL.getSQL("history.ps.changereqsize"));
                    preparedStatement.setInt(1, this.configuredrequestbodysize);
                    DbUtils.executeAndClose(preparedStatement);
                }
                if (n2 != this.configuredresponsebodysize && this.configuredresponsebodysize > 0) {
                    preparedStatement = connection.prepareStatement(DbSQL.getSQL("history.ps.changerespsize"));
                    preparedStatement.setInt(1, this.configuredresponsebodysize);
                    DbUtils.executeAndClose(preparedStatement);
                }
            }
            catch (SQLException sQLException) {
                log.error((Object)("An error occurred while modifying a column length on " + TABLE_NAME));
                log.error((Object)("The 'Maximum Request Body Size' value in the Database Options needs to be set to at least " + n + " to avoid this error"));
                log.error((Object)("The 'Maximum Response Body Size' value in the Database Options needs to be set to at least " + n2 + " to avoid this error"));
                log.error((Object)"The SQL Exception was:", (Throwable)sQLException);
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public RecordHistory read(int n) throws HttpMalformedHeaderException, DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.read");
            sqlPreparedStatementWrapper.getPs().setInt(1, n);
            sqlPreparedStatementWrapper.getPs().execute();
            RecordHistory recordHistory = null;
            try (Object object = sqlPreparedStatementWrapper.getPs().getResultSet();){
                recordHistory = this.build((ResultSet)object);
            }
            object = recordHistory;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public RecordHistory write(long l, int n, HttpMessage httpMessage) throws HttpMalformedHeaderException, DatabaseException {
        String string = "";
        byte[] byArray = new byte[]{};
        String string2 = "";
        byte[] byArray2 = byArray;
        String string3 = "";
        String string4 = "";
        int n2 = 0;
        String string5 = httpMessage.getNote();
        if (!httpMessage.getRequestHeader().isEmpty()) {
            string = httpMessage.getRequestHeader().toString();
            byArray = httpMessage.getRequestBody().getBytes();
            string3 = httpMessage.getRequestHeader().getMethod();
            string4 = httpMessage.getRequestHeader().getURI().toString();
        }
        if (!httpMessage.getResponseHeader().isEmpty()) {
            string2 = httpMessage.getResponseHeader().toString();
            byArray2 = httpMessage.getResponseBody().getBytes();
            n2 = httpMessage.getResponseHeader().getStatusCode();
        }
        return this.write(l, n, httpMessage.getTimeSentMillis(), httpMessage.getTimeElapsedMillis(), string3, string4, n2, string, byArray, string2, byArray2, null, string5, httpMessage.isResponseFromTargetHost());
    }

    /*
     * Exception decompiling
     */
    private RecordHistory write(long var1_1, int var3_2, long var4_3, int var6_4, String var7_5, String var8_6, int var9_7, String var10_8, byte[] var11_9, String var12_10, byte[] var13_11, String var14_12, String var15_13, boolean var16_14) throws HttpMalformedHeaderException, DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordHistory build(ResultSet resultSet) throws HttpMalformedHeaderException, DatabaseException {
        try {
            RecordHistory recordHistory = null;
            try {
                if (resultSet.next()) {
                    byte[] byArray;
                    byte[] byArray2;
                    if (this.bodiesAsBytes) {
                        byArray2 = resultSet.getBytes(REQBODY);
                        byArray = resultSet.getBytes(RESBODY);
                    } else {
                        byArray2 = resultSet.getString(REQBODY).getBytes();
                        byArray = resultSet.getString(RESBODY).getBytes();
                    }
                    recordHistory = new RecordHistory(resultSet.getInt(HISTORYID), resultSet.getInt(HISTTYPE), resultSet.getLong(SESSIONID), resultSet.getLong(TIMESENTMILLIS), resultSet.getInt(TIMEELAPSEDMILLIS), resultSet.getString(REQHEADER), byArray2, resultSet.getString(RESHEADER), byArray, resultSet.getString(TAG), resultSet.getString(NOTE), resultSet.getBoolean(RESPONSE_FROM_TARGET_HOST));
                }
            }
            finally {
                resultSet.close();
            }
            return recordHistory;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<Integer> getHistoryIds(long l) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.gethistoryids");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            sqlPreparedStatementWrapper.getPs().setLong(1, l);
            try (Object object = sqlPreparedStatementWrapper.getPs().executeQuery();){
                while (object.next()) {
                    arrayList.add(object.getInt(HISTORYID));
                }
            }
            object = arrayList;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public List<Integer> getHistoryIdsOfHistType(long l, int ... nArray) throws DatabaseException {
        if (nArray == null || nArray.length == 0) {
            return this.getHistoryIds(l);
        }
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.gethistoryidsinctypes");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            sqlPreparedStatementWrapper.getPs().setLong(1, l);
            DbSQL.setSetValues(sqlPreparedStatementWrapper.getPs(), 2, nArray);
            try (Object object = sqlPreparedStatementWrapper.getPs().executeQuery();){
                while (object.next()) {
                    arrayList.add(object.getInt(HISTORYID));
                }
            }
            object = arrayList;
            return object;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public List<Integer> getHistoryIdsExceptOfHistType(long l, int ... nArray) throws DatabaseException {
        if (nArray == null || nArray.length == 0) {
            return this.getHistoryIds(l);
        }
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.gethistoryidsnottypes");
            sqlPreparedStatementWrapper.getPs().setLong(1, l);
            DbSQL.setSetValues(sqlPreparedStatementWrapper.getPs(), 2, nArray);
            try (Object object = sqlPreparedStatementWrapper.getPs().executeQuery();){
                while (object.next()) {
                    arrayList.add(object.getInt(HISTORYID));
                }
            }
            object = arrayList;
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
            return object;
        }
        catch (SQLException sQLException) {
            try {
                throw new DatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getHistoryList(long l, int n, String string, boolean bl) throws DatabaseException {
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE " + SESSIONID + " = ? AND " + HISTTYPE + " = ? ORDER BY " + HISTORYID);
            ResultSet resultSet = null;
            Vector<Integer> vector = new Vector<Integer>();
            try {
                Pattern pattern = Pattern.compile(string, 10);
                Matcher matcher = null;
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    if (bl) {
                        matcher = pattern.matcher(resultSet.getString(REQHEADER));
                        if (matcher.find()) {
                            vector.add(resultSet.getInt(HISTORYID));
                            continue;
                        }
                        matcher = pattern.matcher(resultSet.getString(REQBODY));
                        if (!matcher.find()) continue;
                        vector.add(resultSet.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(resultSet.getString(RESHEADER));
                    if (matcher.find()) {
                        vector.add(resultSet.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(resultSet.getString(RESBODY));
                    if (!matcher.find()) continue;
                    vector.add(resultSet.getInt(HISTORYID));
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                preparedStatement.close();
            }
            return vector;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void deleteHistorySession(long l) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.deletesession");
            sqlPreparedStatementWrapper.getPs().setLong(1, l);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public void deleteHistoryType(long l, int n) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.deletetype");
            sqlPreparedStatementWrapper.getPs().setLong(1, l);
            sqlPreparedStatementWrapper.getPs().setInt(2, n);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public void delete(int n) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.delete");
            sqlPreparedStatementWrapper.getPs().setInt(1, n);
            sqlPreparedStatementWrapper.getPs().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public void delete(List<Integer> list) throws DatabaseException {
        this.delete(list, 1000);
    }

    @Override
    public void delete(List<Integer> list, int n) throws DatabaseException {
        if (list == null) {
            throw new IllegalArgumentException("Parameter ids must not be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Parameter batchSize must be greater than zero.");
        }
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.delete");
            int n2 = 0;
            for (Integer n3 : list) {
                sqlPreparedStatementWrapper.getPs().setInt(1, n3);
                sqlPreparedStatementWrapper.getPs().addBatch();
                if (++n2 % n != 0) continue;
                sqlPreparedStatementWrapper.getPs().executeBatch();
                n2 = 0;
            }
            if (n2 % n != 0) {
                sqlPreparedStatementWrapper.getPs().executeBatch();
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Deprecated
    public static void setHistoryTypeAsTemporary(int n) {
    }

    @Deprecated
    public static void unsetHistoryTypeAsTemporary(int n) {
        HistoryReference.removeTemporaryType(n);
    }

    @Override
    public void deleteTemporary() throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.deletetemp");
            for (Integer n : HistoryReference.getTemporaryTypes()) {
                sqlPreparedStatementWrapper.getPs().setInt(1, n);
                sqlPreparedStatementWrapper.getPs().execute();
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public boolean containsURI(long l, int n, String string, String string2, byte[] byArray) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.containsuri");
            sqlPreparedStatementWrapper.getPs().setString(1, string2);
            sqlPreparedStatementWrapper.getPs().setString(2, string);
            if (this.bodiesAsBytes) {
                sqlPreparedStatementWrapper.getPs().setBytes(3, byArray);
            } else {
                sqlPreparedStatementWrapper.getPs().setString(3, new String(byArray));
            }
            sqlPreparedStatementWrapper.getPs().setLong(4, l);
            sqlPreparedStatementWrapper.getPs().setInt(5, n);
            try (ResultSet resultSet = sqlPreparedStatementWrapper.getPs().executeQuery();){
                if (resultSet.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecordHistory getHistoryCache(HistoryReference historyReference, HttpMessage httpMessage) throws DatabaseException, HttpMalformedHeaderException {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND " + HISTORYID + " >= ? AND " + HISTORYID + " <= ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND " + HISTORYID + " >= ? AND " + HISTORYID + " <= ? AND SESSIONID = ?)");
            preparedStatement.setString(1, httpMessage.getRequestHeader().getURI().toString());
            preparedStatement.setString(2, httpMessage.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                preparedStatement.setBytes(3, httpMessage.getRequestBody().getBytes());
            } else {
                preparedStatement.setString(3, new String(httpMessage.getRequestBody().getBytes()));
            }
            preparedStatement.setInt(4, historyReference.getHistoryId());
            preparedStatement.setInt(5, historyReference.getHistoryId() + 200);
            preparedStatement.setLong(6, historyReference.getSessionId());
            ResultSet resultSet = preparedStatement.executeQuery();
            RecordHistory recordHistory = null;
            try {
                do {
                    if ((recordHistory = this.build(resultSet)) == null || !recordHistory.getHttpMessage().equals(httpMessage) || recordHistory.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory recordHistory2 = recordHistory;
                    return recordHistory2;
                } while (recordHistory != null);
            }
            finally {
                try {
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            preparedStatement = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ?");
            preparedStatement.setString(1, httpMessage.getRequestHeader().getURI().toString());
            preparedStatement.setString(2, httpMessage.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                preparedStatement.setBytes(3, httpMessage.getRequestBody().getBytes());
            } else {
                preparedStatement.setString(3, new String(httpMessage.getRequestBody().getBytes()));
            }
            preparedStatement.setLong(4, historyReference.getSessionId());
            resultSet = preparedStatement.executeQuery();
            recordHistory = null;
            try {
                do {
                    if ((recordHistory = this.build(resultSet)) == null || !recordHistory.getHttpMessage().equals(httpMessage) || recordHistory.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory recordHistory3 = recordHistory;
                    return recordHistory3;
                } while (recordHistory != null);
                return null;
            }
            finally {
                try {
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void updateNote(int n, String string) throws DatabaseException {
        SqlPreparedStatementWrapper sqlPreparedStatementWrapper = null;
        try {
            sqlPreparedStatementWrapper = DbSQL.getSingleton().getPreparedStatement("history.ps.updatenote");
            sqlPreparedStatementWrapper.getPs().setString(1, string);
            sqlPreparedStatementWrapper.getPs().setInt(2, n);
            sqlPreparedStatementWrapper.getPs().execute();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    @Override
    public int lastIndex() {
        return this.lastInsertedIndex;
    }
}

