/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

abstract class AbstractAPIGenerator {
    protected static final String OPTIONAL_MESSAGE = "This component is optional and therefore the API will only work if it is installed";
    protected static final String VIEW_ENDPOINT = "view";
    protected static final String ACTION_ENDPOINT = "action";
    protected static final String OTHER_ENDPOINT = "other";
    private final Path directory;
    private final boolean optional;
    private final ResourceBundle messages;

    protected AbstractAPIGenerator(String string) {
        this(string, false);
    }

    protected AbstractAPIGenerator(String string, boolean bl) {
        this.directory = Paths.get(string, new String[0]);
        this.optional = bl;
        this.messages = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    }

    protected Path getDirectory() {
        return this.directory;
    }

    protected boolean isOptional() {
        return this.optional;
    }

    protected ResourceBundle getMessages() {
        return this.messages;
    }

    public void generateCoreAPIFiles() throws IOException {
        this.generateAPIFiles(ApiGeneratorUtils.getAllImplementors());
    }

    public void generateAPIFiles(List<ApiImplementor> list) throws IOException {
        for (ApiImplementor apiImplementor : list) {
            this.generateAPIFiles(apiImplementor);
        }
    }

    protected abstract void generateAPIFiles(ApiImplementor var1) throws IOException;
}

