/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public class PopupMenuAddBreakHistory
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = -1984801437717248474L;
    private static final Logger logger = Logger.getLogger(PopupMenuAddBreakHistory.class);
    private final ExtensionBreak extension;

    public PopupMenuAddBreakHistory(ExtensionBreak extensionBreak) {
        super(Constant.messages.getString("brk.add.popup"));
        this.extension = extensionBreak;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.HISTORY_PANEL;
    }

    @Override
    public void performAction(HistoryReference historyReference) {
        try {
            this.extension.addUiBreakpoint(historyReference.getHttpMessage());
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.extension.getView().showWarningDialog(Constant.messages.getString("brk.add.error.history"));
        }
    }
}

