/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.callback.CallbackImplementor;
import org.zaproxy.zap.extension.callback.CallbackParam;
import org.zaproxy.zap.extension.callback.OptionsCallbackPanel;

public class ExtensionCallback
extends ExtensionAdaptor
implements OptionsChangedListener {
    private static final String TEST_PREFIX = "ZapTest";
    private ProxyServer proxyServer;
    private CallbackParam callbackParam;
    private OptionsCallbackPanel optionsCallbackPanel;
    private Map<String, CallbackImplementor> callbacks = new HashMap<String, CallbackImplementor>();
    private int actualPort;
    private String currentConfigLocalAddress;
    private int currentConfigPort;
    private static final Logger LOGGER = Logger.getLogger(ExtensionCallback.class);

    public ExtensionCallback() {
        this.proxyServer = new ProxyServer("ZAP-CallbackServer");
        this.proxyServer.addOverrideMessageProxyListener(new CallbackProxyListener());
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getCallbackParam());
        extensionHook.addOptionsChangedListener(this);
        if (View.isInitialised()) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsCallbackPanel());
        }
    }

    @Override
    public void optionsLoaded() {
        this.proxyServer.setConnectionParam(this.getModel().getOptionsParam().getConnectionParam());
        this.currentConfigLocalAddress = this.getCallbackParam().getLocalAddress();
        this.currentConfigPort = this.getCallbackParam().getPort();
    }

    @Override
    public void postInit() {
        this.restartServer(this.getCallbackParam().getPort());
    }

    private void restartServer(int n) {
        this.actualPort = this.proxyServer.startServer(this.getCallbackParam().getLocalAddress(), n, true);
        LOGGER.info((Object)("Started callback server on " + this.getCallbackParam().getLocalAddress() + ":" + this.actualPort));
    }

    public String getCallbackAddress() {
        String string = this.getCallbackParam().getRemoteAddress();
        if (string.contains(":")) {
            return "http://[" + string + "]:" + this.actualPort + "/";
        }
        return "http://" + string + ":" + this.actualPort + "/";
    }

    public String getTestUrl() {
        return this.getCallbackAddress() + TEST_PREFIX;
    }

    protected int getPort() {
        return this.actualPort;
    }

    public void registerCallbackImplementor(CallbackImplementor callbackImplementor) {
        for (String string : callbackImplementor.getCallbackPrefixes()) {
            LOGGER.debug((Object)("Registering callback prefix: " + string));
            if (this.callbacks.containsKey(string)) {
                LOGGER.error((Object)("Duplicate callback prefix: " + string));
            }
            this.callbacks.put("/" + string, callbackImplementor);
        }
    }

    public void removeCallbackImplementor(CallbackImplementor callbackImplementor) {
        for (String string : callbackImplementor.getCallbackPrefixes()) {
            String string2 = "/" + string;
            if (!this.callbacks.containsKey(string2)) continue;
            LOGGER.debug((Object)("Removing registered callback prefix: " + string));
            this.callbacks.remove(string2);
        }
    }

    private CallbackParam getCallbackParam() {
        if (this.callbackParam == null) {
            this.callbackParam = new CallbackParam();
        }
        return this.callbackParam;
    }

    private OptionsCallbackPanel getOptionsCallbackPanel() {
        if (this.optionsCallbackPanel == null) {
            this.optionsCallbackPanel = new OptionsCallbackPanel(this);
        }
        return this.optionsCallbackPanel;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("callback.desc");
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        if (!this.currentConfigLocalAddress.equals(this.getCallbackParam().getLocalAddress()) || this.currentConfigPort != this.getCallbackParam().getPort()) {
            int n = this.actualPort;
            if (this.currentConfigPort != this.getCallbackParam().getPort()) {
                n = this.getCallbackParam().getPort();
            }
            this.restartServer(n);
            this.currentConfigLocalAddress = this.getCallbackParam().getLocalAddress();
            this.currentConfigPort = this.getCallbackParam().getPort();
        }
    }

    private class CallbackProxyListener
    implements OverrideMessageProxyListener {
        private CallbackProxyListener() {
        }

        @Override
        public int getArrangeableListenerOrder() {
            return 0;
        }

        @Override
        public boolean onHttpRequestSend(HttpMessage httpMessage) {
            try {
                String string = httpMessage.getRequestHeader().getURI().toString();
                String string2 = httpMessage.getRequestHeader().getURI().getPath();
                LOGGER.debug((Object)("Callback received for URL : " + string + " path : " + string2 + " from " + httpMessage.getRequestHeader().getSenderAddress()));
                if (string2.startsWith("/ZapTest")) {
                    String string3 = Constant.messages.getString("callback.test.msg", string, httpMessage.getRequestHeader().getSenderAddress().toString());
                    if (View.isInitialised()) {
                        View.getSingleton().getOutputPanel().appendAsync(string3 + "\n");
                    }
                    LOGGER.info((Object)string3);
                    return true;
                }
                if (string2.startsWith("/favicon.ico")) {
                    return true;
                }
                for (Map.Entry entry : ExtensionCallback.this.callbacks.entrySet()) {
                    if (!string2.startsWith((String)entry.getKey())) continue;
                    ((CallbackImplementor)entry.getValue()).handleCallBack(httpMessage.cloneAll());
                    return true;
                }
                LOGGER.error((Object)("No callback handler for URL : " + string + " from " + httpMessage.getRequestHeader().getSenderAddress()));
            }
            catch (URIException uRIException) {
                LOGGER.error((Object)uRIException.getMessage(), (Throwable)uRIException);
            }
            return true;
        }

        @Override
        public boolean onHttpResponseReceived(HttpMessage httpMessage) {
            return true;
        }
    }
}

