/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.alert.AlertViewPanel;
import org.zaproxy.zap.extension.alert.ExtensionAlert;

public class AlertAddDialog
extends AbstractDialog {
    private static final Logger logger = Logger.getLogger(AlertAddDialog.class);
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private ExtensionHistory extension = null;
    private HistoryReference historyRef;
    private int historyType;
    private HttpMessage httpMessage;
    private JScrollPane jScrollPane = null;
    private AlertViewPanel alertViewPanel = null;

    public AlertAddDialog() throws HeadlessException {
        this.initialize();
    }

    public AlertAddDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("alert.add.title"));
        this.setContentPane(this.getJPanel());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(407, 657);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AlertAddDialog.this.btnCancel.doClick();
            }
        });
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(new Dimension(450, 650));
            this.jPanel.setMinimumSize(new Dimension(450, 650));
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 5;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.anchor = 13;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 10);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(2, 10, 2, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 10;
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.jPanel.add((Component)jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints4);
            this.jPanel.add((Component)this.getBtnOk(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(Constant.messages.getString("alert.add.button.save"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Alert alert = AlertAddDialog.this.alertViewPanel.getAlert();
                    try {
                        ExtensionAlert extensionAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
                        if (alert.getAlertId() >= 0) {
                            if (extensionAlert != null) {
                                extensionAlert.updateAlert(alert);
                            } else if (AlertAddDialog.this.historyRef != null) {
                                AlertAddDialog.this.historyRef.updateAlert(alert);
                                AlertAddDialog.this.extension.notifyHistoryItemChanged(AlertAddDialog.this.historyRef);
                            }
                        } else {
                            if (AlertAddDialog.this.httpMessage != null) {
                                AlertAddDialog.this.historyRef = new HistoryReference(Model.getSingleton().getSession(), AlertAddDialog.this.historyType, AlertAddDialog.this.httpMessage);
                            }
                            alert.setSource(Alert.Source.MANUAL);
                            if (extensionAlert != null) {
                                extensionAlert.alertFound(alert, AlertAddDialog.this.historyRef);
                            } else {
                                AlertAddDialog.this.historyRef.addAlert(alert);
                                AlertAddDialog.this.extension.notifyHistoryItemChanged(AlertAddDialog.this.historyRef);
                            }
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                    AlertAddDialog.this.clearAndCloseDialog();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("alert.add.button.cancel"));
            this.btnCancel.setEnabled(true);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AlertAddDialog.this.clearAndCloseDialog();
                }
            });
        }
        return this.btnCancel;
    }

    private void clearAndCloseDialog() {
        this.getAlertViewPanel().clearAlert();
        this.historyRef = null;
        this.httpMessage = null;
        this.dispose();
    }

    public void setPlugin(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private AlertViewPanel getAlertViewPanel() {
        if (this.alertViewPanel == null) {
            this.alertViewPanel = new AlertViewPanel(true);
        }
        return this.alertViewPanel;
    }

    public void setAlert(Alert alert) {
        this.getAlertViewPanel().displayAlert(alert);
        if (alert.getHistoryRef() != null) {
            this.setHistoryRef(alert.getHistoryRef());
        } else {
            this.setHistoryRef(alert.getMessage().getHistoryRef());
        }
        this.setTitle(Constant.messages.getString("alert.edit.title"));
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setViewportView(this.getAlertViewPanel());
        }
        return this.jScrollPane;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyReference) {
        this.historyRef = historyReference;
        this.httpMessage = null;
        this.alertViewPanel.setHistoryRef(historyReference);
    }

    public void setHttpMessage(HttpMessage httpMessage, int n) {
        this.historyRef = null;
        this.httpMessage = httpMessage;
        this.historyType = n;
        this.alertViewPanel.setHttpMessage(httpMessage);
    }
}

