/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class PopupMenuExportURLs
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    protected ExtensionHistory extension = null;
    private static Logger log = Logger.getLogger(PopupMenuExportURLs.class);

    public PopupMenuExportURLs(String string) {
        super(string);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuExportURLs.this.performAction();
            }
        });
    }

    protected void performAction() {
        File file = this.getOutputFile();
        if (file == null) {
            return;
        }
        this.writeURLs(file, this.getOutputSet((SiteNode)this.extension.getView().getSiteTreePanel().getTreeSite().getModel().getRoot()));
    }

    public void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    protected SortedSet<String> getOutputSet(SiteNode siteNode) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration<TreeNode> enumeration = siteNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            HistoryReference historyReference;
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (siteNode2.isRoot() || (historyReference = siteNode2.getHistoryReference()) == null || HistoryReference.getTemporaryTypes().contains(historyReference.getHistoryType())) continue;
            treeSet.add(historyReference.getURI().toString());
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeURLs(File file, SortedSet<String> sortedSet) {
        boolean bl = file.getName().toLowerCase().endsWith(".htm") || file.getName().toLowerCase().endsWith(".html");
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            for (String string : sortedSet) {
                string = bl ? this.wrapHTML(string) : string;
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception.getStackTrace(), (Throwable)exception);
            this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath());
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {
                log.warn((Object)exception.getStackTrace(), (Throwable)exception);
            }
        }
    }

    private String wrapHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("<a href=\"").append(string).append("\">");
        stringBuilder.append(string).append("</a><br>");
        return stringBuilder.toString();
    }

    protected File getOutputFile() {
        WritableFileChooser writableFileChooser = new WritableFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.ascii"), "txt");
        FileNameExtensionFilter fileNameExtensionFilter2 = new FileNameExtensionFilter(Constant.messages.getString("file.format.html"), "html", "htm");
        writableFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        writableFileChooser.addChoosableFileFilter(fileNameExtensionFilter2);
        writableFileChooser.setFileFilter(fileNameExtensionFilter);
        File file = null;
        int n = writableFileChooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (n == 0) {
            file = writableFileChooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(writableFileChooser.getCurrentDirectory());
            String string = file.getAbsolutePath().toLowerCase();
            if (!(string.endsWith(".txt") || string.endsWith(".htm") || string.endsWith(".html"))) {
                String string2 = fileNameExtensionFilter2.equals(writableFileChooser.getFileFilter()) ? ".html" : ".txt";
                file = new File(file.getAbsolutePath() + string2);
            }
            return file;
        }
        return file;
    }
}

