/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import net.htmlparser.jericho.MasonTagTypes;
import net.htmlparser.jericho.MicrosoftTagTypes;
import net.htmlparser.jericho.PHPTagTypes;
import net.htmlparser.jericho.Source;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.OptionsPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;

public class PassiveScanThread
extends Thread
implements ProxyListener,
SessionChangedListener {
    private static final Logger logger = Logger.getLogger(PassiveScanThread.class);
    public static final int PROXY_LISTENER_ORDER = 5001;
    private OptionsPassiveScan options = null;
    private PassiveScannerList scannerList = null;
    private int currentId = 1;
    private int lastId = -1;
    private int mainSleep = 5000;
    private int postSleep = 200;
    private volatile boolean shutDown = false;
    private final ExtensionHistory extHist;
    private final ExtensionAlert extAlert;
    private final PassiveScanParam pscanOptions;
    private TableHistory historyTable = null;
    private HistoryReference href = null;
    private Session session;

    @Deprecated
    public PassiveScanThread(PassiveScannerList passiveScannerList, ExtensionHistory extensionHistory, ExtensionAlert extensionAlert) {
        this(passiveScannerList, extensionHistory, extensionAlert, new PassiveScanParam());
    }

    public PassiveScanThread(PassiveScannerList passiveScannerList, ExtensionHistory extensionHistory, ExtensionAlert extensionAlert, PassiveScanParam passiveScanParam) {
        super("ZAP-PassiveScanner");
        this.setDaemon(true);
        if (extensionAlert == null) {
            throw new IllegalArgumentException("Parameter extensionAlert must not be null.");
        }
        this.scannerList = passiveScannerList;
        MicrosoftTagTypes.register();
        PHPTagTypes.register();
        PHPTagTypes.PHP_SHORT.deregister();
        MasonTagTypes.register();
        this.extAlert = extensionAlert;
        this.extHist = extensionHistory;
        this.pscanOptions = passiveScanParam;
    }

    @Override
    public void run() {
        this.historyTable = Model.getSingleton().getDb().getTableHistory();
        this.session = Model.getSingleton().getSession();
        this.lastId = this.currentId = this.getLastHistoryId();
        while (!this.shutDown) {
            try {
                if (this.href != null || this.lastId > this.currentId) {
                    ++this.currentId;
                } else {
                    try {
                        Thread.sleep(this.mainSleep);
                        if (this.shutDown) {
                            return;
                        }
                        this.lastId = this.getLastHistoryId();
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            Thread.sleep(this.postSleep);
                        }
                        catch (InterruptedException interruptedException2) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.href = this.getHistoryReference(this.currentId);
                }
                catch (Exception exception) {
                    if (this.shutDown) {
                        return;
                    }
                    logger.error((Object)("Failed to read record " + this.currentId + " from History table"), (Throwable)exception);
                }
                if (this.href == null || this.pscanOptions.isScanOnlyInScope() && !this.session.isInScope(this.href)) continue;
                try {
                    HttpMessage httpMessage = this.href.getHttpMessage();
                    String string = httpMessage.getResponseHeader().toString() + httpMessage.getResponseBody().toString();
                    Source source = new Source((CharSequence)string);
                    for (PassiveScanner passiveScanner : this.scannerList.list()) {
                        try {
                            if (this.shutDown) {
                                return;
                            }
                            if (!passiveScanner.isEnabled() || !passiveScanner.appliesToHistoryType(this.href.getHistoryType())) continue;
                            passiveScanner.setParent(this);
                            passiveScanner.scanHttpRequestSend(httpMessage, this.href.getHistoryId());
                            if (!httpMessage.isResponseFromTargetHost()) continue;
                            passiveScanner.scanHttpResponseReceive(httpMessage, this.href.getHistoryId(), source);
                        }
                        catch (Throwable throwable) {
                            if (this.shutDown) {
                                return;
                            }
                            logger.error((Object)("Scanner " + passiveScanner.getName() + " failed on record " + this.currentId + " from History table: " + this.href.getMethod() + " " + this.href.getURI()), throwable);
                        }
                    }
                }
                catch (Exception exception) {
                    if (HistoryReference.getTemporaryTypes().contains(this.href.getHistoryType())) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Temporary record " + this.currentId + " no longer available:"), (Throwable)exception);
                        continue;
                    }
                    logger.error((Object)("Parser failed on record " + this.currentId + " from History table"), (Throwable)exception);
                }
            }
            catch (Exception exception) {
                if (this.shutDown) {
                    return;
                }
                logger.error((Object)("Failed on record " + this.currentId + " from History table"), (Throwable)exception);
            }
        }
    }

    private HistoryReference getHistoryReference(int n) {
        if (this.extHist != null) {
            return this.extHist.getHistoryReference(n);
        }
        try {
            return new HistoryReference(n);
        }
        catch (DatabaseException | HttpMalformedHeaderException exception) {
            return null;
        }
    }

    private int getLastHistoryId() {
        return this.historyTable.lastIndex();
    }

    protected int getRecordsToScan() {
        return this.getLastHistoryId() - this.getLastScannedId();
    }

    private int getLastScannedId() {
        if (this.currentId > this.lastId) {
            return this.currentId - 1;
        }
        return this.currentId;
    }

    public void raiseAlert(int n, Alert alert) {
        if (this.shutDown) {
            return;
        }
        if (this.currentId != n) {
            logger.error((Object)("Alert id != currentId! " + n + " " + this.currentId));
        }
        alert.setSource(Alert.Source.PASSIVE);
        this.extAlert.alertFound(alert, this.href);
    }

    private void notifyHistoryItemChanged(HistoryReference historyReference) {
        if (this.extHist != null) {
            this.extHist.notifyHistoryItemChanged(historyReference);
        }
    }

    public void addTag(int n, String string) {
        if (this.shutDown) {
            return;
        }
        try {
            if (!this.href.getTags().contains(string)) {
                this.href.addTag(string);
                this.notifyHistoryItemChanged(this.href);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 5001;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage httpMessage) {
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage httpMessage) {
        this.interrupt();
        return true;
    }

    @Override
    public void sessionChanged(Session session) {
        this.historyTable = Model.getSingleton().getDb().getTableHistory();
        this.href = null;
        this.lastId = this.currentId = this.historyTable.lastIndex();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    public void shutdown() {
        this.shutDown = true;
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }
}

