/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.SiteMapPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.OverlayIcon;
import org.zaproxy.zap.view.SiteMapListener;

public class SiteMapTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon ROOT_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/16/094.png"));
    private static final ImageIcon LEAF_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/document-target.png"));
    private static final ImageIcon LEAF_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/document.png"));
    private static final ImageIcon FOLDER_OPEN_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-open-target.png"));
    private static final ImageIcon FOLDER_OPEN_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-open.png"));
    private static final ImageIcon FOLDER_CLOSED_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal-target.png"));
    private static final ImageIcon FOLDER_CLOSED_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/folder-horizontal.png"));
    private static final ImageIcon DATA_DRIVEN_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/database.png"));
    private static final ImageIcon DATA_DRIVEN_IN_SCOPE_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/database-target.png"));
    private static final ImageIcon LOCK_OVERLAY_ICON = new ImageIcon(SiteMapTreeCellRenderer.class.getResource("/resource/icon/fugue/lock-overlay.png"));
    private static final long serialVersionUID = -4278691012245035225L;
    private static Logger log = Logger.getLogger(SiteMapPanel.class);
    private List<SiteMapListener> listeners;
    private JPanel component;

    public SiteMapTreeCellRenderer(List<SiteMapListener> list) {
        this.listeners = list;
        this.component = new JPanel(new FlowLayout(1, 4, 2));
        this.component.setOpaque(false);
        this.putClientProperty("html.disable", Boolean.TRUE);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.component.removeAll();
        SiteNode siteNode = null;
        if (object instanceof SiteNode) {
            siteNode = (SiteNode)object;
        }
        if (siteNode != null) {
            if (siteNode.isFiltered()) {
                this.setPreferredSize(new Dimension(0, 0));
            } else {
                this.setPreferredSize(null);
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            if (siteNode.isRoot()) {
                this.component.add(this.wrap(ROOT_ICON));
            } else {
                OverlayIcon overlayIcon = siteNode.isDataDriven() ? (siteNode.isIncludedInScope() && !siteNode.isExcludedFromScope() ? new OverlayIcon(DATA_DRIVEN_IN_SCOPE_ICON) : new OverlayIcon(DATA_DRIVEN_ICON)) : (bl3 ? (siteNode.isIncludedInScope() && !siteNode.isExcludedFromScope() ? new OverlayIcon(LEAF_IN_SCOPE_ICON) : new OverlayIcon(LEAF_ICON)) : (bl2 ? (siteNode.isIncludedInScope() && !siteNode.isExcludedFromScope() ? new OverlayIcon(FOLDER_OPEN_IN_SCOPE_ICON) : new OverlayIcon(FOLDER_OPEN_ICON)) : (siteNode.isIncludedInScope() && !siteNode.isExcludedFromScope() ? new OverlayIcon(FOLDER_CLOSED_IN_SCOPE_ICON) : new OverlayIcon(FOLDER_CLOSED_ICON))));
                if (siteNode.getParent().isRoot() && siteNode.getNodeName().startsWith("https://")) {
                    overlayIcon.add(LOCK_OVERLAY_ICON);
                }
                this.component.add(this.wrap(DisplayUtils.getScaledIcon(overlayIcon)));
                Alert object2 = siteNode.getHighestAlert();
                if (object2 != null) {
                    this.component.add(this.wrap(object2.getIcon()));
                }
                for (ImageIcon imageIcon : siteNode.getCustomIcons()) {
                    this.component.add(this.wrap(DisplayUtils.getScaledIcon(imageIcon)));
                }
            }
            if (bl) {
                this.component.add(this.wrap(siteNode.toString(), Color.WHITE));
            } else {
                this.component.add(this.wrap(siteNode.toString()));
            }
            for (SiteMapListener siteMapListener : this.listeners) {
                siteMapListener.onReturnNodeRendererComponent(this, bl3, siteNode);
            }
            return this.component;
        }
        return this;
    }

    private JLabel wrap(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(false);
        jLabel.putClientProperty("html.disable", Boolean.TRUE);
        return jLabel;
    }

    private JLabel wrap(String string, Color color) {
        JLabel jLabel = this.wrap(string);
        jLabel.setForeground(color);
        return jLabel;
    }

    private JLabel wrap(ImageIcon imageIcon) {
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setOpaque(false);
        jLabel.putClientProperty("html.disable", Boolean.TRUE);
        return jLabel;
    }

    public HistoryReference getHistoryReferenceFromNode(Object object) {
        SiteNode siteNode = null;
        if (object instanceof SiteNode && (siteNode = (SiteNode)object).getHistoryReference() != null) {
            try {
                return siteNode.getHistoryReference();
            }
            catch (Exception exception) {
                log.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return null;
    }
}

