/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final EverythingGlobalScope ALL_SCOPE = new EverythingGlobalScope();
    protected final Project myProject;
    private volatile PackageDirectoryCache myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(@NotNull Project project, String ... fileExtensions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/NonClasspathClassFinder", "<init>"));
        }
        if (fileExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtensions", "com/intellij/psi/NonClasspathClassFinder", "<init>"));
        }
        this.myProject = project;
        this.myManager = PsiManager.getInstance(this.myProject);
        this.myFileExtensions = ArrayUtil.append(fileExtensions, "class");
        MessageBusConnection connection = project.getMessageBus().connect(project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener.Adapter(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/NonClasspathClassFinder$1", "after"));
                }
                NonClasspathClassFinder.this.clearCache();
            }
        });
        LowMemoryWatcher.register(() -> this.clearCache(), project);
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        PackageDirectoryCache cache2 = this.myCache;
        if (cache2 == null) {
            this.myCache = cache2 = NonClasspathClassFinder.createCache(this.calcClassRoots());
        }
        PackageDirectoryCache packageDirectoryCache = cache2;
        if (packageDirectoryCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getCache"));
        }
        return packageDirectoryCache;
    }

    @NotNull
    protected static PackageDirectoryCache createCache(@NotNull List<VirtualFile> roots2) {
        if (roots2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/psi/NonClasspathClassFinder", "createCache"));
        }
        MultiMap<String, VirtualFile> map2 = MultiMap.create();
        map2.putValues("", roots2);
        PackageDirectoryCache packageDirectoryCache = new PackageDirectoryCache(map2);
        if (packageDirectoryCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "createCache"));
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        this.myCache = null;
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        return this.getCache(scope).getDirectoriesByPackageName("");
    }

    public List<VirtualFile> getClassRoots() {
        return this.getClassRoots(ALL_SCOPE);
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        Ref result2 = Ref.create();
        this.processDirectories(StringUtil.getPackageName(qualifiedName), scope, dir -> {
            PsiClass[] classes2;
            PsiFile file2;
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "lambda$findClass$1"));
            }
            VirtualFile virtualFile = NonClasspathClassFinder.findChild(dir, StringUtil.getShortName(qualifiedName), this.myFileExtensions);
            PsiFile psiFile = file2 = virtualFile == null ? null : this.myManager.findFile(virtualFile);
            if (file2 instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)file2).getClasses()).length == 1) {
                result2.set(classes2[0]);
                return false;
            }
            return true;
        });
        return (PsiClass)result2.get();
    }

    protected abstract List<VirtualFile> calcClassRoots();

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        ArrayList<PsiClass> result2 = ContainerUtil.newArrayList();
        this.processDirectories(psiPackage.getQualifiedName(), scope, dir -> {
            for (VirtualFile file2 : dir.getChildren()) {
                PsiFile psi;
                if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), this.myFileExtensions) || !((psi = this.myManager.findFile(file2)) instanceof PsiClassOwner)) continue;
                ContainerUtil.addAll(result2, ((PsiClassOwner)psi).getClasses());
            }
            return true;
        });
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        HashSet<String> result2 = new HashSet<String>();
        this.processDirectories(psiPackage.getQualifiedName(), scope, dir -> {
            for (VirtualFile file2 : dir.getChildren()) {
                if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), this.myFileExtensions)) continue;
                result2.add(file2.getNameWithoutExtension());
            }
            return true;
        });
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findPackage"));
        }
        CommonProcessors.FindFirstProcessor<VirtualFile> processor = new CommonProcessors.FindFirstProcessor<VirtualFile>();
        this.processDirectories(qualifiedName, ALL_SCOPE, processor);
        return processor.getFoundValue() != null ? this.createPackage(qualifiedName) : null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl(this.myManager, qualifiedName);
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        return this.processDirectories(psiPackage.getQualifiedName(), scope, dir -> {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "lambda$processPackageDirectories$4"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/NonClasspathClassFinder", "lambda$processPackageDirectories$4"));
            }
            PsiDirectory psiDirectory = psiPackage.getManager().findDirectory((VirtualFile)dir);
            return psiDirectory == null || consumer.process(psiDirectory);
        });
    }

    private boolean processDirectories(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope, @NotNull Processor<VirtualFile> processor) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        return ContainerUtil.process(this.getCache(scope).getDirectoriesByPackageName(qualifiedName), file2 -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "lambda$processDirectories$5"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/NonClasspathClassFinder", "lambda$processDirectories$5"));
            }
            return !scope.contains((VirtualFile)file2) || processor.process((VirtualFile)file2);
        });
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        String pkgName = psiPackage.getQualifiedName();
        Set<String> names2 = this.getCache(scope).getSubpackageNames(pkgName);
        if (names2.isEmpty()) {
            PsiPackage[] psiPackageArray = super.getSubPackages(psiPackage, scope);
            if (psiPackageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
            }
            return psiPackageArray;
        }
        ArrayList<PsiPackageImpl> result2 = new ArrayList<PsiPackageImpl>();
        for (String name : names2) {
            result2.add(this.createPackage(pkgName.isEmpty() ? name : pkgName + "." + name));
        }
        PsiPackage[] psiPackageArray = result2.toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        PsiClass psiClass = this.findClass(qualifiedName, scope);
        if (psiClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(@NotNull Project project, @NotNull GlobalSearchScope base) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        GlobalSearchScope scope = base;
        for (PsiElementFinder finder : (PsiElementFinder[])Extensions.getExtensions(EP_NAME, (AreaInstance)project)) {
            if (!(finder instanceof NonClasspathClassFinder)) continue;
            scope = scope.uniteWith(NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots()));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        return globalSearchScope;
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findChild(@NotNull VirtualFile root, @NotNull String relPath, @NotNull String[] extensions) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        VirtualFile file2 = null;
        for (String extension : extensions) {
            file2 = root.findChild(relPath + '.' + extension);
            if (file2 != null) break;
        }
        return file2;
    }
}

