/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationImpl
extends JavaStubPsiElement<PsiAnnotationStub>
implements PsiAnnotation {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = (project, text2) -> JavaPsiFacade.getInstance(project).getElementFactory().createAnnotationFromText((String)text2, null);

    public PsiAnnotationImpl(PsiAnnotationStub stub) {
        super(stub, JavaStubElementTypes.ANNOTATION);
    }

    public PsiAnnotationImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            return PsiTreeUtil.getRequiredChildOfType(stub.getPsiElement(), PsiJavaCodeReferenceElement.class);
        }
        return PsiTreeUtil.getChildOfType(this, PsiJavaCodeReferenceElement.class);
    }

    @Override
    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    @Override
    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        PsiAnnotationMemberValue t = PsiImplUtil.setDeclaredAttributeValue(this, attributeName, value, ANNOTATION_CREATOR);
        return (T)t;
    }

    @Override
    public String toString() {
        return "PsiAnnotation";
    }

    @Override
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.ANNOTATION_PARAMETER_LIST);
        if (psiAnnotationParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl", "getParameterList"));
        }
        return psiAnnotationParameterList;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        return nameRef.getCanonicalText();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnnotation(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }

    @Override
    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement ctx;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiAnnotationOwner) {
            return (PsiAnnotationOwner)((Object)parent2);
        }
        if (parent2 instanceof PsiNewExpression) {
            return ((PsiNewExpression)parent2).getOwner(this);
        }
        if (parent2 instanceof PsiReferenceExpression ? (ctx = parent2.getParent()) instanceof PsiMethodReferenceExpression : parent2 instanceof PsiJavaCodeReferenceElement && ((ctx = PsiTreeUtil.skipParentsOfType(parent2, PsiJavaCodeReferenceElement.class)) instanceof PsiReferenceList || ctx instanceof PsiNewExpression || ctx instanceof PsiTypeElement || ctx instanceof PsiAnonymousClass)) {
            return new PsiClassReferenceType((PsiJavaCodeReferenceElement)parent2, null);
        }
        PsiTypeElement typeElement = null;
        PsiElement anchor2 = null;
        if (parent2 instanceof PsiMethod) {
            typeElement = ((PsiMethod)parent2).getReturnTypeElement();
            anchor2 = ((PsiMethod)parent2).getParameterList();
        } else if (parent2 instanceof PsiField || parent2 instanceof PsiParameter || parent2 instanceof PsiLocalVariable) {
            typeElement = ((PsiVariable)parent2).getTypeElement();
            anchor2 = ((PsiVariable)parent2).getNameIdentifier();
        }
        if (typeElement != null && anchor2 != null) {
            return JavaSharedImplUtil.getType(typeElement, anchor2, this);
        }
        return null;
    }
}

