/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BridgeForBuiltinSpecial;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.GenerateJava8ParameterNamesKt;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmStaticInCompanionObjectGenerator;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedWithOnlyTargetedAnnotations;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.SuspendFunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen {
    public final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final MemberCodegen<?> memberCodegen;
    private final Function1<DeclarationDescriptor, Boolean> IS_PURE_INTERFACE_CHECKER;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state2, @NotNull MemberCodegen<?> memberCodegen) {
        if (owner == null) {
            FunctionCodegen.$$$reportNull$$$0(0);
        }
        if (v == null) {
            FunctionCodegen.$$$reportNull$$$0(1);
        }
        if (state2 == null) {
            FunctionCodegen.$$$reportNull$$$0(2);
        }
        if (memberCodegen == null) {
            FunctionCodegen.$$$reportNull$$$0(3);
        }
        this.IS_PURE_INTERFACE_CHECKER = new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return JvmCodegenUtil.isAnnotationOrJvmInterfaceWithoutDefaults(descriptor2, FunctionCodegen.this.state);
            }
        };
        this.owner = owner;
        this.v = v;
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.memberCodegen = memberCodegen;
    }

    public void gen(@NotNull KtNamedFunction function2) {
        SimpleFunctionDescriptor functionDescriptor;
        if (function2 == null) {
            FunctionCodegen.$$$reportNull$$$0(4);
        }
        if (this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function2)) != null) {
            functionDescriptor = (SimpleFunctionDescriptor)this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor);
        }
        if (functionDescriptor == null) {
            throw ExceptionLogger.logDescriptorNotFound("No descriptor for function " + function2.getName(), function2);
        }
        if (this.owner.getContextKind() != OwnerKind.DEFAULT_IMPLS || function2.hasBody()) {
            FunctionGenerationStrategy.CodegenBased strategy = functionDescriptor.isSuspend() ? new SuspendFunctionGenerationStrategy(this.state, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(functionDescriptor), function2) : new FunctionGenerationStrategy.FunctionDefault(this.state, function2);
            this.generateMethod(JvmDeclarationOriginKt.OtherOrigin(function2, (DeclarationDescriptor)functionDescriptor), functionDescriptor, strategy);
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor, true), functionDescriptor, this.owner.getContextKind(), DefaultParameterValueLoader.DEFAULT, function2);
        this.generateOverloadsWithDefaultValues(function2, functionDescriptor, functionDescriptor);
    }

    public void generateOverloadsWithDefaultValues(@Nullable KtNamedFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionDescriptor delegateFunctionDescriptor) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(5);
        }
        if (delegateFunctionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(6);
        }
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(function2, functionDescriptor, delegateFunctionDescriptor, this.owner.getContextKind(), this.v, this.memberCodegen);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(8);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(9);
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(descriptor2)) {
            this.generateMethod(origin, CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(descriptor2, this.bindingContext), strategy);
            return;
        }
        this.generateMethod(origin, descriptor2, this.owner.intoFunction(descriptor2), strategy);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        boolean staticInCompanionObject;
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(10);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(11);
        }
        if (methodContext == null) {
            FunctionCodegen.$$$reportNull$$$0(12);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(13);
        }
        OwnerKind contextKind = methodContext.getContextKind();
        if (DescriptorUtils.isInterface(functionDescriptor.getContainingDeclaration()) && functionDescriptor.getVisibility() == Visibilities.PRIVATE && !FunctionCodegen.processInterfaceMember(functionDescriptor, contextKind, this.state)) {
            return;
        }
        JvmMethodGenericSignature jvmSignature = this.typeMapper.mapSignatureWithGeneric(functionDescriptor, contextKind);
        Method asmMethod = jvmSignature.getAsmMethod();
        int flags = AsmUtil.getMethodAsmFlags(functionDescriptor, contextKind, this.state);
        if (origin.getOriginKind() == JvmDeclarationOriginKind.SAM_DELEGATION) {
            flags |= 0x1000;
        }
        if (functionDescriptor.isExternal() && this.owner instanceof MultifileClassFacadeContext) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(origin, flags, asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (CodegenContextUtil.isImplClassOwner(this.owner)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, CodegenUtilKt.unwrapFrontendVersion(functionDescriptor), asmMethod);
        }
        this.generateMethodAnnotations(functionDescriptor, asmMethod, mv);
        JvmMethodSignature signature = this.typeMapper.mapSignatureSkipGeneric(functionDescriptor);
        this.generateParameterAnnotations(functionDescriptor, mv, signature);
        GenerateJava8ParameterNamesKt.generateParameterNames(functionDescriptor, mv, signature, this.state, (flags & 0x1000) != 0);
        this.generateBridges(functionDescriptor);
        if (JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(functionDescriptor, this.state) && contextKind != OwnerKind.DEFAULT_IMPLS && this.state.getGenerateDefaultImplsForJvm8()) {
            this.generateDelegateForDefaultImpl(functionDescriptor, origin.getElement());
        }
        if (staticInCompanionObject = CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addAdditionalTask(new JvmStaticInCompanionObjectGenerator(functionDescriptor, origin, this.state, parentBodyCodegen));
        }
        if (!this.state.getClassBuilderMode().generateBodies || AsmUtil.isAbstractMethod(functionDescriptor, contextKind, this.state)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor, FunctionCodegen.getThisTypeForFunction(functionDescriptor, methodContext, this.typeMapper), new Label(), new Label(), contextKind, this.typeMapper, 0);
            mv.visitEnd();
            return;
        }
        if (!functionDescriptor.isExternal()) {
            FunctionCodegen.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy, this.memberCodegen);
        } else if (staticInCompanionObject) {
            mv.visitCode();
            FunctionDescriptor staticFunctionDescriptor = JvmStaticInCompanionObjectGenerator.createStaticFunctionDescriptor(functionDescriptor);
            Method accessorMethod = this.typeMapper.mapAsmMethod(this.memberCodegen.getContext().accessibleDescriptor(staticFunctionDescriptor, null));
            Type owningType = this.typeMapper.mapClass((ClassifierDescriptor)staticFunctionDescriptor.getContainingDeclaration());
            FunctionCodegen.generateDelegateToStaticMethodBody(false, mv, accessorMethod, owningType.getInternalName());
        }
        FunctionCodegen.endVisit(mv, null, origin.getElement());
    }

    private void generateDelegateForDefaultImpl(@NotNull FunctionDescriptor functionDescriptor, @Nullable PsiElement element) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(14);
        }
        Method defaultImplMethod = this.typeMapper.mapAsmMethod(functionDescriptor, OwnerKind.DEFAULT_IMPLS);
        CodegenUtilKt.generateMethod(this.v, "Default Impl delegate in interface", 4105, new Method(defaultImplMethod.getName() + "$defaultImpl", defaultImplMethod.getDescriptor()), element, JvmDeclarationOrigin.NO_ORIGIN, this.state, adapter -> {
            if (functionDescriptor == null) {
                FunctionCodegen.$$$reportNull$$$0(115);
            }
            Method interfaceMethod = this.typeMapper.mapAsmMethod(functionDescriptor, OwnerKind.IMPLEMENTATION);
            Type type2 = this.typeMapper.mapOwner(functionDescriptor);
            FunctionCodegen.generateDelegateToMethodBody(-1, adapter, interfaceMethod, type2.getInternalName(), 183, true);
            return null;
        });
    }

    private void generateMethodAnnotations(@NotNull FunctionDescriptor functionDescriptor, Method asmMethod, MethodVisitor mv) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(15);
        }
        FunctionCodegen.generateMethodAnnotations(functionDescriptor, asmMethod, mv, this.memberCodegen, this.typeMapper);
    }

    public static void generateMethodAnnotations(@NotNull FunctionDescriptor functionDescriptor, Method asmMethod, MethodVisitor mv, @NotNull InnerClassConsumer consumer, @NotNull KotlinTypeMapper typeMapper) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            FunctionCodegen.$$$reportNull$$$0(17);
        }
        if (typeMapper == null) {
            FunctionCodegen.$$$reportNull$$$0(18);
        }
        AnnotationCodegen annotationCodegen = AnnotationCodegen.forMethod(mv, consumer, typeMapper);
        if (functionDescriptor instanceof PropertyAccessorDescriptor) {
            AnnotationUseSiteTarget target = functionDescriptor instanceof PropertySetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_SETTER : AnnotationUseSiteTarget.PROPERTY_GETTER;
            annotationCodegen.genAnnotations(functionDescriptor, asmMethod.getReturnType(), target);
        } else {
            annotationCodegen.genAnnotations(functionDescriptor, asmMethod.getReturnType());
        }
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(19);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(20);
        }
        if (jvmSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(21);
        }
        FunctionCodegen.generateParameterAnnotations(functionDescriptor, mv, jvmSignature, this.memberCodegen, this.state);
    }

    public static void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state2) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(22);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(23);
        }
        if (jvmSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(24);
        }
        if (innerClassConsumer == null) {
            FunctionCodegen.$$$reportNull$$$0(25);
        }
        if (state2 == null) {
            FunctionCodegen.$$$reportNull$$$0(26);
        }
        FunctionCodegen.generateParameterAnnotations(functionDescriptor, mv, jvmSignature, functionDescriptor.getValueParameters(), innerClassConsumer, state2);
    }

    public static void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull InnerClassConsumer innerClassConsumer, @NotNull GenerationState state2) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(27);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(28);
        }
        if (jvmSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(29);
        }
        if (valueParameters == null) {
            FunctionCodegen.$$$reportNull$$$0(30);
        }
        if (innerClassConsumer == null) {
            FunctionCodegen.$$$reportNull$$$0(31);
        }
        if (state2 == null) {
            FunctionCodegen.$$$reportNull$$$0(32);
        }
        KotlinTypeMapper typeMapper = state2.getTypeMapper();
        Iterator<ValueParameterDescriptor> iterator2 = valueParameters.iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            ReceiverParameterDescriptor receiver;
            AnnotationCodegen annotationCodegen;
            JvmMethodParameterSignature parameterSignature = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind = parameterSignature.getKind();
            if (kind.isSkippedInGenericSignature()) {
                FunctionCodegen.markEnumOrInnerConstructorParameterAsSynthetic(mv, i, state2.getClassBuilderMode());
                continue;
            }
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = iterator2.next();
                annotationCodegen = AnnotationCodegen.forParameter(i, mv, innerClassConsumer, typeMapper);
                if (functionDescriptor instanceof PropertySetterDescriptor) {
                    PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)functionDescriptor).getCorrespondingProperty();
                    AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(propertyDescriptor);
                    annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.SETTER_PARAMETER);
                }
                if (functionDescriptor instanceof ConstructorDescriptor) {
                    annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType(), AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
                    continue;
                }
                annotationCodegen.genAnnotations(parameter, parameterSignature.getAsmType());
                continue;
            }
            if (kind != JvmMethodParameterKind.RECEIVER || (receiver = JvmCodegenUtil.getDirectMember(functionDescriptor).getExtensionReceiverParameter()) == null) continue;
            annotationCodegen = AnnotationCodegen.forParameter(i, mv, innerClassConsumer, typeMapper);
            AnnotatedWithOnlyTargetedAnnotations targetedAnnotations = new AnnotatedWithOnlyTargetedAnnotations(receiver.getType());
            annotationCodegen.genAnnotations(targetedAnnotations, parameterSignature.getAsmType(), AnnotationUseSiteTarget.RECEIVER);
            annotationCodegen.genAnnotations(receiver, parameterSignature.getAsmType());
        }
    }

    private static void markEnumOrInnerConstructorParameterAsSynthetic(MethodVisitor mv, int i, ClassBuilderMode mode) {
        if (mode == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        if (av != null) {
            av.visitEnd();
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull KotlinTypeMapper typeMapper) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(33);
        }
        if (context == null) {
            FunctionCodegen.$$$reportNull$$$0(34);
        }
        if (typeMapper == null) {
            FunctionCodegen.$$$reportNull$$$0(35);
        }
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return typeMapper.mapType(functionDescriptor);
        }
        if (dispatchReceiver != null) {
            return typeMapper.mapType(dispatchReceiver.getType());
        }
        if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isLocalFunction(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
            return typeMapper.mapType(context.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen) {
        String name;
        int indexOfLambdaOrdinal;
        Label methodEnd;
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(36);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(37);
        }
        if (context == null) {
            FunctionCodegen.$$$reportNull$$$0(38);
        }
        if (signature == null) {
            FunctionCodegen.$$$reportNull$$$0(39);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(40);
        }
        if (parentCodegen == null) {
            FunctionCodegen.$$$reportNull$$$0(41);
        }
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        KotlinTypeMapper typeMapper = parentCodegen.typeMapper;
        if (BuiltinSpecialBridgesUtil.shouldHaveTypeSafeBarrier(functionDescriptor, typeMapper::mapAsmMethod)) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(new InstructionAdapter(mv), functionDescriptor, signature.getReturnType(), null);
        }
        int functionFakeIndex = -1;
        int lambdaFakeIndex = -1;
        if (context.getParentContext() instanceof MultifileClassFacadeContext) {
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, signature.getAsmMethod(), (MultifileClassFacadeContext)context.getParentContext());
            methodEnd = new Label();
        } else if (OwnerKind.DEFAULT_IMPLS == context.getContextKind() && JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(functionDescriptor, parentCodegen.state)) {
            int flags = AsmUtil.getMethodAsmFlags(functionDescriptor, OwnerKind.DEFAULT_IMPLS, context.getState());
            assert ((flags & 0x400) == 0) : "Interface method with body should be non-abstract" + functionDescriptor;
            Type type2 = typeMapper.mapOwner(functionDescriptor);
            Method asmMethod = typeMapper.mapAsmMethod(functionDescriptor, OwnerKind.DEFAULT_IMPLS);
            FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, new Method(asmMethod.getName() + "$defaultImpl", asmMethod.getDescriptor()), type2.getInternalName());
            methodEnd = new Label();
        } else {
            FrameMap frameMap = FunctionCodegen.createFrameMap(parentCodegen.state, functionDescriptor, signature, AsmUtil.isStaticMethod(context.getContextKind(), functionDescriptor));
            if (context.isInlineMethodContext()) {
                functionFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            if (context instanceof InlineLambdaContext) {
                lambdaFakeIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            Label methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context.setMethodStartLabel(methodEntry);
            if (!KotlinTypeMapper.isAccessor(functionDescriptor)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor, frameMap);
            }
            parentCodegen.beforeMethodBody(mv);
            methodEnd = new Label();
            context.setMethodEndLabel(methodEnd);
            strategy.generateBody(mv, frameMap, signature, context, parentCodegen);
        }
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor, context, typeMapper);
        FunctionCodegen.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, context.getContextKind(), typeMapper, (functionFakeIndex >= 0 ? 1 : 0) + (lambdaFakeIndex >= 0 ? 1 : 0));
        if (context.isInlineMethodContext() && functionFakeIndex != -1) {
            mv.visitLocalVariable("$i$f$" + typeMapper.mapAsmMethod(functionDescriptor).getName(), Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, functionFakeIndex);
        }
        if (context instanceof InlineLambdaContext && thisType != null && lambdaFakeIndex != -1 && (indexOfLambdaOrdinal = (name = thisType.getClassName()).lastIndexOf("$")) > 0) {
            ValueParameterDescriptor inlineArgumentDescriptor;
            int lambdaOrdinal = Integer.parseInt(name.substring(indexOfLambdaOrdinal + 1));
            Object functionArgument = parentCodegen.element;
            String functionName = "unknown";
            if (functionArgument instanceof KtFunction && (inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor((KtFunction)functionArgument, parentCodegen.bindingContext)) != null) {
                functionName = inlineArgumentDescriptor.getContainingDeclaration().getName().asString();
            }
            mv.visitLocalVariable("$i$a$" + lambdaOrdinal + "$" + functionName, Type.INT_TYPE.getDescriptor(), null, methodBegin, methodEnd, lambdaFakeIndex);
        }
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind, @NotNull KotlinTypeMapper typeMapper, int shiftForDestructuringVariables) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(42);
        }
        if (jvmMethodSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(43);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(44);
        }
        if (methodBegin == null) {
            FunctionCodegen.$$$reportNull$$$0(45);
        }
        if (methodEnd == null) {
            FunctionCodegen.$$$reportNull$$$0(46);
        }
        if (ownerKind == null) {
            FunctionCodegen.$$$reportNull$$$0(47);
        }
        if (typeMapper == null) {
            FunctionCodegen.$$$reportNull$$$0(48);
        }
        FunctionCodegen.generateLocalVariablesForParameters(mv, jvmMethodSignature, thisType, methodBegin, methodEnd, functionDescriptor.getValueParameters(), AsmUtil.isStaticMethod(ownerKind, functionDescriptor), typeMapper, shiftForDestructuringVariables);
    }

    public static void generateLocalVariablesForParameters(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters, boolean isStatic, KotlinTypeMapper typeMapper) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(49);
        }
        if (jvmMethodSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(50);
        }
        if (methodBegin == null) {
            FunctionCodegen.$$$reportNull$$$0(51);
        }
        if (methodEnd == null) {
            FunctionCodegen.$$$reportNull$$$0(52);
        }
        FunctionCodegen.generateLocalVariablesForParameters(mv, jvmMethodSignature, thisType, methodBegin, methodEnd, valueParameters, isStatic, typeMapper, 0);
    }

    private static void generateLocalVariablesForParameters(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters, boolean isStatic, KotlinTypeMapper typeMapper, int shiftForDestructuringVariables) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(53);
        }
        if (jvmMethodSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(54);
        }
        if (methodBegin == null) {
            FunctionCodegen.$$$reportNull$$$0(55);
        }
        if (methodEnd == null) {
            FunctionCodegen.$$$reportNull$$$0(56);
        }
        Iterator<ValueParameterDescriptor> valueParameterIterator = valueParameters.iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getValueParameters();
        int shift = 0;
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameterIterator.next();
                List<VariableDescriptor> destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull(parameter);
                parameterName = destructuringVariables == null ? FunctionCodegen.computeParameterName(i, parameter) : "$" + FunctionCodegen.joinParameterNames(destructuringVariables);
            } else {
                String lowercaseKind = kind.name().toLowerCase();
                parameterName = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
            }
            Type type2 = param.getAsmType();
            mv.visitLocalVariable(parameterName, type2.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type2.getSize();
        }
        shift += shiftForDestructuringVariables;
        for (ValueParameterDescriptor parameter : valueParameters) {
            List<VariableDescriptor> destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull(parameter);
            if (destructuringVariables == null) continue;
            for (VariableDescriptor entry : CodegenUtilKt.filterOutDescriptorsWithSpecialNames(destructuringVariables)) {
                Type type3 = typeMapper.mapType(entry.getType());
                mv.visitLocalVariable(entry.getName().asString(), type3.getDescriptor(), null, methodBegin, methodEnd, shift);
                shift += type3.getSize();
            }
        }
    }

    private static String computeParameterName(int i, ValueParameterDescriptor parameter) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
        if (element instanceof KtParameter && UnderscoreUtilKt.isSingleUnderscore((KtParameter)element)) {
            return "$noName_" + i;
        }
        return parameter.getName().asString();
    }

    private static String joinParameterNames(@NotNull List<VariableDescriptor> variables) {
        if (variables == null) {
            FunctionCodegen.$$$reportNull$$$0(57);
        }
        return StringsKt.join(CollectionsKt.map(variables, descriptor2 -> descriptor2.getName().isSpecial() ? "$_$" : descriptor2.getName().asString()), "_");
    }

    private static void generateFacadeDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull MultifileClassFacadeContext context) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(58);
        }
        if (asmMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(59);
        }
        if (context == null) {
            FunctionCodegen.$$$reportNull$$$0(60);
        }
        FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, asmMethod, context.getFilePartType().getInternalName());
    }

    private static void generateDelegateToMethodBody(int firstParamIndex, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo, int opcode, boolean isInterface) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(61);
        }
        if (asmMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(62);
        }
        if (classToDelegateTo == null) {
            FunctionCodegen.$$$reportNull$$$0(63);
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int paramIndex = firstParamIndex;
        if (paramIndex == -1) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
            paramIndex = 1;
        }
        for (Type argType : argTypes) {
            iv.load(paramIndex, argType);
            paramIndex += argType.getSize();
        }
        iv.visitMethodInsn(opcode, classToDelegateTo, asmMethod.getName(), asmMethod.getDescriptor(), isInterface);
        iv.areturn(asmMethod.getReturnType());
    }

    private static void generateDelegateToStaticMethodBody(boolean isStatic, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(64);
        }
        if (asmMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(65);
        }
        if (classToDelegateTo == null) {
            FunctionCodegen.$$$reportNull$$$0(66);
        }
        FunctionCodegen.generateDelegateToMethodBody(isStatic ? 0 : 1, mv, asmMethod, classToDelegateTo, 184, false);
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description) {
        FunctionCodegen.endVisit(mv, description, (PsiElement)null);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable KtPureElement method) {
        FunctionCodegen.endVisit(mv, description, (PsiElement)(method == null ? null : method.getPsiOrParent()));
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @NotNull KtElement method) {
        if (method == null) {
            FunctionCodegen.$$$reportNull$$$0(67);
        }
        FunctionCodegen.endVisit(mv, description, (PsiElement)method);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            String bytecode2 = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong code generated\n" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage() + (bytecode2 != null ? "\nbytecode:\n" + bytecode2 : ""), t, method);
        }
    }

    private static String renderByteCodeIfAvailable(MethodVisitor mv) {
        String bytecode2 = null;
        if (mv instanceof TransformationMethodVisitor) {
            mv = ((TransformationMethodVisitor)mv).getTraceMethodVisitorIfPossible();
        }
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode2 = sw.toString();
        }
        return bytecode2;
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor2) {
        boolean isSpecial;
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(68);
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.DEFAULT_IMPLS) {
            return;
        }
        if (JvmCodegenUtil.isAnnotationOrJvmInterfaceWithoutDefaults(descriptor2.getContainingDeclaration(), this.state)) {
            return;
        }
        if (FunctionCodegen.isMethodOfAny(descriptor2)) {
            return;
        }
        boolean bl = isSpecial = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2) != null;
        if (!isSpecial) {
            Set<Bridge<Method>> bridgesToGenerate2 = ImplKt.generateBridgesForFunctionDescriptor(descriptor2, this.typeMapper::mapAsmMethod, this.IS_PURE_INTERFACE_CHECKER);
            if (!bridgesToGenerate2.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                boolean isSpecialBridge = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2) != null;
                for (Bridge<Method> bridge : bridgesToGenerate2) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), isSpecialBridge, false);
                }
            }
        } else {
            Set<BridgeForBuiltinSpecial<Method>> specials = BuiltinSpecialBridgesUtil.generateBridgesForBuiltinSpecial(descriptor2, this.typeMapper::mapAsmMethod, this.IS_PURE_INTERFACE_CHECKER);
            if (!specials.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                for (BridgeForBuiltinSpecial<Method> bridge : specials) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), bridge.isSpecial(), bridge.isDelegateToSuper());
                }
            }
            if (!descriptor2.getKind().isReal() && AsmUtil.isAbstractMethod(descriptor2, OwnerKind.IMPLEMENTATION, this.state)) {
                FunctionDescriptor overridden = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2);
                assert (overridden != null);
                if (!FunctionCodegen.isThereOverriddenInKotlinClass(descriptor2)) {
                    Method method = this.typeMapper.mapAsmMethod(descriptor2);
                    int flags = 0x400 | AsmUtil.getVisibilityAccessFlag(descriptor2);
                    this.v.newMethod(JvmDeclarationOriginKt.AugmentedBuiltInApi(overridden), flags, method.getName(), method.getDescriptor(), null, null);
                }
            }
        }
    }

    public static boolean isThereOverriddenInKotlinClass(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(69);
        }
        return CollectionsKt.any(DescriptorUtils.getAllOverriddenDescriptors(descriptor2), overridden -> !(overridden.getContainingDeclaration() instanceof JavaClassDescriptor) && DescriptorUtils.isClass(overridden.getContainingDeclaration()));
    }

    public static boolean isMethodOfAny(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(70);
        }
        String name = descriptor2.getName().asString();
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        if (parameters2.isEmpty()) {
            return name.equals("hashCode") || name.equals("toString");
        }
        if (parameters2.size() == 1 && name.equals("equals")) {
            return KotlinBuiltIns.isNullableAny(parameters2.get(0).getType());
        }
        return false;
    }

    @NotNull
    public static String[] getThrownExceptions(@NotNull FunctionDescriptor function2, @NotNull KotlinTypeMapper mapper) {
        AnnotationDescriptor annotation2;
        if (function2 == null) {
            FunctionCodegen.$$$reportNull$$$0(71);
        }
        if (mapper == null) {
            FunctionCodegen.$$$reportNull$$$0(72);
        }
        if ((annotation2 = function2.getAnnotations().findAnnotation(new FqName("kotlin.throws"))) == null) {
            annotation2 = function2.getAnnotations().findAnnotation(new FqName("kotlin.jvm.Throws"));
        }
        if (annotation2 == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                FunctionCodegen.$$$reportNull$$$0(73);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Collection<ConstantValue<?>> values = annotation2.getAllValueArguments().values();
        if (values.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                FunctionCodegen.$$$reportNull$$$0(74);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ConstantValue<?> value = values.iterator().next();
        if (!(value instanceof ArrayValue)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                FunctionCodegen.$$$reportNull$$$0(75);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayValue arrayValue = (ArrayValue)value;
        List<String> strings = CollectionsKt.mapNotNull((Iterable)arrayValue.getValue(), constant -> {
            if (mapper == null) {
                FunctionCodegen.$$$reportNull$$$0(114);
            }
            if (constant instanceof KClassValue) {
                KClassValue classValue = (KClassValue)constant;
                ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(classValue.getValue());
                return mapper.mapClass(classDescriptor).getInternalName();
            }
            return null;
        });
        String[] stringArray = ArrayUtil.toStringArray(strings);
        if (stringArray == null) {
            FunctionCodegen.$$$reportNull$$$0(76);
        }
        return stringArray;
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2) {
        DeclarationDescriptor contextClass;
        if (owner == null) {
            FunctionCodegen.$$$reportNull$$$0(77);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(78);
        }
        if (kind == null) {
            FunctionCodegen.$$$reportNull$$$0(79);
        }
        if (loadStrategy == null) {
            FunctionCodegen.$$$reportNull$$$0(80);
        }
        if (DescriptorUtils.isInterface(contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration()) && !FunctionCodegen.processInterface(contextClass, kind, this.state)) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor)) {
            return;
        }
        int visibilityFlag = Visibilities.isPrivate(functionDescriptor.getVisibility()) || AnnotationUtilKt.isInlineOnlyOrReifiable(functionDescriptor) ? 0 : 1;
        int flags = visibilityFlag | AsmUtil.getDeprecatedAccessFlag(functionDescriptor) | 0x1000;
        if (!(functionDescriptor instanceof ConstructorDescriptor)) {
            flags |= 0x48;
        }
        Method defaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, kind);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Synthetic(function2, functionDescriptor), flags, defaultMethod.getName(), defaultMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        AnnotationCodegen.forMethod(mv, this.memberCodegen, this.typeMapper).genAnnotations(functionDescriptor, defaultMethod.getReturnType());
        if (!this.state.getClassBuilderMode().generateBodies) {
            if (this.owner instanceof MultifileClassFacadeContext) {
                FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            } else {
                FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            }
            return;
        }
        if (this.owner instanceof MultifileClassFacadeContext) {
            mv.visitCode();
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, defaultMethod, (MultifileClassFacadeContext)this.owner);
            FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        } else {
            mv.visitCode();
            FunctionCodegen.generateDefaultImplBody(owner, functionDescriptor, mv, loadStrategy, function2, this.memberCodegen, defaultMethod);
            FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        }
    }

    public static void generateDefaultImplBody(@NotNull MethodContext methodContext, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2, @NotNull MemberCodegen<?> parentCodegen, @NotNull Method defaultMethod) {
        int parameterIndex;
        Type type2;
        ValueParameterDescriptor parameterDescriptor;
        int index2;
        int capturedArgumentsCount;
        if (methodContext == null) {
            FunctionCodegen.$$$reportNull$$$0(81);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(82);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(83);
        }
        if (loadStrategy == null) {
            FunctionCodegen.$$$reportNull$$$0(84);
        }
        if (parentCodegen == null) {
            FunctionCodegen.$$$reportNull$$$0(85);
        }
        if (defaultMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(86);
        }
        GenerationState state2 = parentCodegen.state;
        JvmMethodGenericSignature signature = state2.getTypeMapper().mapSignatureWithGeneric(functionDescriptor, methodContext.getContextKind());
        boolean isStatic = AsmUtil.isStaticMethod(methodContext.getContextKind(), functionDescriptor);
        FrameMap frameMap = FunctionCodegen.createFrameMap(state2, functionDescriptor, signature, isStatic);
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), methodContext, state2, parentCodegen);
        CallGenerator generator = codegen.getOrCreateCallGeneratorForDefaultImplBody(functionDescriptor, function2);
        InstructionAdapter iv = new InstructionAdapter(mv);
        FunctionCodegen.genDefaultSuperCallCheckIfNeeded(iv, functionDescriptor, defaultMethod);
        List<JvmMethodParameterSignature> mappedParameters = signature.getValueParameters();
        for (capturedArgumentsCount = 0; capturedArgumentsCount < mappedParameters.size() && mappedParameters.get(capturedArgumentsCount).getKind() != JvmMethodParameterKind.VALUE; ++capturedArgumentsCount) {
        }
        int maskIndex = 0;
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        for (index2 = 0; index2 < valueParameters.size(); ++index2) {
            if (index2 % 32 == 0) {
                maskIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            parameterDescriptor = valueParameters.get(index2);
            type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            parameterIndex = frameMap.getIndex(parameterDescriptor);
            if (!parameterDescriptor.declaresDefaultValue()) continue;
            iv.load(maskIndex, Type.INT_TYPE);
            iv.iconst(1 << index2 % 32);
            iv.and(Type.INT_TYPE);
            Label loadArg = new Label();
            iv.ifeq(loadArg);
            StackValue.local(parameterIndex, type2).store(loadStrategy.genValue(parameterDescriptor, codegen), iv);
            iv.mark(loadArg);
        }
        FunctionCodegen.loadExplicitArgumentsOnStack(AsmTypes.OBJECT_TYPE, isStatic, signature, generator);
        for (index2 = 0; index2 < valueParameters.size(); ++index2) {
            parameterDescriptor = valueParameters.get(index2);
            type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            parameterIndex = frameMap.getIndex(parameterDescriptor);
            generator.putValueIfNeeded(type2, StackValue.local(parameterIndex, type2));
        }
        CallableMethod method = state2.getTypeMapper().mapToCallableMethod(functionDescriptor, false);
        generator.genCall(method, null, false, codegen);
        iv.areturn(signature.getReturnType());
    }

    private static void genDefaultSuperCallCheckIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Method defaultMethod) {
        if (iv == null) {
            FunctionCodegen.$$$reportNull$$$0(87);
        }
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(88);
        }
        if (defaultMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(89);
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (!(container2 instanceof ClassDescriptor)) {
            return;
        }
        if (((ClassDescriptor)container2).getModality() == Modality.FINAL) {
            return;
        }
        Label end = new Label();
        int handleIndex = (Type.getArgumentsAndReturnSizes(defaultMethod.getDescriptor()) >> 2) - 2;
        iv.load(handleIndex, AsmTypes.OBJECT_TYPE);
        iv.ifnull(end);
        AsmUtil.genThrow(iv, "java/lang/UnsupportedOperationException", "Super calls with default arguments not supported in this target, function: " + descriptor2.getName().asString());
        iv.visitLabel(end);
    }

    @NotNull
    public static FrameMap createFrameMap(@NotNull GenerationState state2, @NotNull FunctionDescriptor function2, @NotNull JvmMethodSignature signature, boolean isStatic) {
        if (state2 == null) {
            FunctionCodegen.$$$reportNull$$$0(90);
        }
        if (function2 == null) {
            FunctionCodegen.$$$reportNull$$$0(91);
        }
        if (signature == null) {
            FunctionCodegen.$$$reportNull$$$0(92);
        }
        FrameMap frameMap = new FrameMap();
        if (!isStatic) {
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : signature.getValueParameters()) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.RECEIVER) {
                ReceiverParameterDescriptor receiverParameter = function2.getExtensionReceiverParameter();
                if (receiverParameter != null) {
                    frameMap.enter(receiverParameter, state2.getTypeMapper().mapType(receiverParameter));
                    continue;
                }
                frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
                continue;
            }
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function2.getValueParameters()) {
            frameMap.enter(valueParameterDescriptor, state2.getTypeMapper().mapType(valueParameterDescriptor));
        }
        FrameMap frameMap2 = frameMap;
        if (frameMap2 == null) {
            FunctionCodegen.$$$reportNull$$$0(93);
        }
        return frameMap2;
    }

    private static void loadExplicitArgumentsOnStack(@NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature, @NotNull CallGenerator callGenerator) {
        if (ownerType == null) {
            FunctionCodegen.$$$reportNull$$$0(94);
        }
        if (signature == null) {
            FunctionCodegen.$$$reportNull$$$0(95);
        }
        if (callGenerator == null) {
            FunctionCodegen.$$$reportNull$$$0(96);
        }
        int var = 0;
        if (!isStatic) {
            callGenerator.putValueIfNeeded(ownerType, StackValue.local(var, ownerType));
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type2 = parameterSignature.getAsmType();
            callGenerator.putValueIfNeeded(type2, StackValue.local(var, type2));
            var += type2.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor) {
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull FunctionDescriptor descriptor2, @NotNull Method bridge, @NotNull Method delegateTo, boolean isSpecialBridge, boolean isStubDeclarationWithDelegationToSuper) {
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(97);
        }
        if (bridge == null) {
            FunctionCodegen.$$$reportNull$$$0(98);
        }
        if (delegateTo == null) {
            FunctionCodegen.$$$reportNull$$$0(99);
        }
        boolean isSpecialOrDelegationToSuper = isSpecialBridge || isStubDeclarationWithDelegationToSuper;
        int flags = 0x41 | (!isSpecialOrDelegationToSuper ? 4096 : 0) | (isSpecialBridge ? 16 : 0);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Bridge(descriptor2, origin), flags, bridge.getName(), bridge.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.markLineNumberForDescriptor(this.owner.getThisDescriptor(), iv);
        if (delegateTo.getArgumentTypes().length > 0 && isSpecialBridge) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(iv, descriptor2, bridge.getReturnType(), delegateTo.getArgumentTypes());
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        if (isStubDeclarationWithDelegationToSuper) {
            ClassDescriptor parentClass = DescriptorUtils.getSuperClassDescriptor((ClassDescriptor)descriptor2.getContainingDeclaration());
            assert (parentClass != null);
            String parentInternalName = this.typeMapper.mapClass(parentClass).getInternalName();
            iv.invokespecial(parentInternalName, delegateTo.getName(), delegateTo.getDescriptor(), false);
        } else if (JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(descriptor2, this.state)) {
            iv.invokeinterface(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        } else {
            iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor(), false);
        }
        StackValue.coerce(delegateTo.getReturnType(), bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    private static void generateTypeCheckBarrierIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Type returnType, @Nullable Type[] delegateParameterTypes) {
        BuiltinMethodsWithSpecialGenericSignature.TypeSafeBarrierDescription typeSafeBarrierDescription;
        if (iv == null) {
            FunctionCodegen.$$$reportNull$$$0(100);
        }
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(101);
        }
        if (returnType == null) {
            FunctionCodegen.$$$reportNull$$$0(102);
        }
        if ((typeSafeBarrierDescription = BuiltinMethodsWithSpecialGenericSignature.getDefaultValueForOverriddenBuiltinFunction(descriptor2)) == null) {
            return;
        }
        FunctionDescriptor overriddenBuiltin = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2);
        assert (overriddenBuiltin != null) : "Overridden built-in method should not be null for " + descriptor2;
        Label defaultBranch = new Label();
        for (int i = 0; i < descriptor2.getValueParameters().size(); ++i) {
            if (!typeSafeBarrierDescription.checkParameter(i)) continue;
            boolean isCheckForAny = delegateParameterTypes == null || AsmTypes.OBJECT_TYPE.equals(delegateParameterTypes[i]);
            KotlinType kotlinType = descriptor2.getValueParameters().get(i).getType();
            if (isCheckForAny && TypeUtils.isNullableType(kotlinType)) continue;
            iv.load(1 + i, AsmTypes.OBJECT_TYPE);
            if (isCheckForAny) {
                assert (!TypeUtils.isNullableType(kotlinType)) : "Only bridges for not-nullable types are necessary";
                iv.ifnull(defaultBranch);
                continue;
            }
            CodegenUtilKt.generateIsCheck(iv, kotlinType, AsmUtil.boxType(delegateParameterTypes[i]));
            iv.ifeq(defaultBranch);
        }
        Label afterDefaultBranch = new Label();
        iv.goTo(afterDefaultBranch);
        iv.visitLabel(defaultBranch);
        if (typeSafeBarrierDescription.equals((Object)BuiltinMethodsWithSpecialGenericSignature.TypeSafeBarrierDescription.MAP_GET_OR_DEFAULT)) {
            iv.load(2, returnType);
        } else {
            StackValue.constant(typeSafeBarrierDescription.getDefaultValue(), returnType).put(returnType, iv);
        }
        iv.areturn(returnType);
        iv.visitLabel(afterDefaultBranch);
    }

    public void genSamDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor2, StackValue field) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(103);
        }
        FunctionDescriptor delegatedTo = overriddenDescriptor2.getOriginal();
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.SamDelegation(functionDescriptor);
        this.genDelegate(functionDescriptor, delegatedTo, declarationOrigin, (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field);
    }

    public void genDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor2, StackValue field) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(104);
        }
        this.genDelegate(functionDescriptor, overriddenDescriptor2.getOriginal(), (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field);
    }

    public void genDelegate(@NotNull FunctionDescriptor delegateFunction, FunctionDescriptor delegatedTo, ClassDescriptor toClass, StackValue field) {
        if (delegateFunction == null) {
            FunctionCodegen.$$$reportNull$$$0(105);
        }
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.Delegation(DescriptorToSourceUtils.descriptorToDeclaration(delegatedTo), delegateFunction);
        this.genDelegate(delegateFunction, delegatedTo, declarationOrigin, toClass, field);
    }

    private void genDelegate(final @NotNull FunctionDescriptor delegateFunction, final FunctionDescriptor delegatedTo, @NotNull JvmDeclarationOrigin declarationOrigin, final ClassDescriptor toClass, final StackValue field) {
        if (delegateFunction == null) {
            FunctionCodegen.$$$reportNull$$$0(106);
        }
        if (declarationOrigin == null) {
            FunctionCodegen.$$$reportNull$$$0(107);
        }
        this.generateMethod(declarationOrigin, delegateFunction, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                if (mv == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (frameMap == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (signature == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (parentCodegen == null) {
                    2.$$$reportNull$$$0(4);
                }
                Method delegateToMethod = FunctionCodegen.this.typeMapper.mapToCallableMethod(delegatedTo, false).getAsmMethod();
                Method delegateMethod = FunctionCodegen.this.typeMapper.mapAsmMethod(delegateFunction);
                Type[] argTypes = delegateMethod.getArgumentTypes();
                Type[] originalArgTypes = delegateToMethod.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, AsmTypes.OBJECT_TYPE);
                field.put(field.type, iv);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                    reg += argTypes[i].getSize();
                }
                String internalName = FunctionCodegen.this.typeMapper.mapType(toClass).getInternalName();
                if (toClass.getKind() == ClassKind.INTERFACE) {
                    iv.invokeinterface(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                } else {
                    iv.invokevirtual(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor(), false);
                }
                StackValue stackValue = AsmUtil.genNotNullAssertions(FunctionCodegen.this.state, StackValue.onStack(delegateToMethod.getReturnType()), RuntimeAssertionInfo.create(delegateFunction.getReturnType(), delegatedTo.getReturnType(), new RuntimeAssertionInfo.DataFlowExtras.OnlyMessage(delegatedTo.getName() + "(...)")));
                stackValue.put(delegateMethod.getReturnType(), iv);
                iv.areturn(delegateMethod.getReturnType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "mv";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "frameMap";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "signature";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parentCodegen";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/FunctionCodegen$2";
                objectArray[2] = "generateBody";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean processInterfaceMember(@NotNull CallableMemberDescriptor function2, @NotNull OwnerKind kind, @NotNull GenerationState state2) {
        if (function2 == null) {
            FunctionCodegen.$$$reportNull$$$0(108);
        }
        if (kind == null) {
            FunctionCodegen.$$$reportNull$$$0(109);
        }
        if (state2 == null) {
            FunctionCodegen.$$$reportNull$$$0(110);
        }
        return FunctionCodegen.processInterface(function2.getContainingDeclaration(), kind, state2);
    }

    public static boolean processInterface(@NotNull DeclarationDescriptor contextClass, @NotNull OwnerKind kind, @NotNull GenerationState state2) {
        if (contextClass == null) {
            FunctionCodegen.$$$reportNull$$$0(111);
        }
        if (kind == null) {
            FunctionCodegen.$$$reportNull$$$0(112);
        }
        if (state2 == null) {
            FunctionCodegen.$$$reportNull$$$0(113);
        }
        assert (DescriptorUtils.isInterface(contextClass)) : "'processInterface' method should be called only for interfaces, but: " + contextClass;
        return JvmCodegenUtil.isJvm8InterfaceWithDefaults(contextClass, state2) ? kind != OwnerKind.DEFAULT_IMPLS : kind == OwnerKind.DEFAULT_IMPLS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 93: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 93: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 2: 
            case 26: 
            case 32: 
            case 90: 
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberCodegen";
                break;
            }
            case 4: 
            case 71: 
            case 91: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 33: 
            case 37: 
            case 44: 
            case 78: 
            case 82: 
            case 103: 
            case 104: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFunctionDescriptor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 8: 
            case 68: 
            case 69: 
            case 70: 
            case 88: 
            case 97: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 13: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 12: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: 
            case 35: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 20: 
            case 23: 
            case 28: 
            case 36: 
            case 42: 
            case 49: 
            case 53: 
            case 58: 
            case 61: 
            case 64: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmSignature";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassConsumer";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameters";
                break;
            }
            case 34: 
            case 38: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 41: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 43: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmMethodSignature";
                break;
            }
            case 45: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodBegin";
                break;
            }
            case 46: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodEnd";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerKind";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 59: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmMethod";
                break;
            }
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToDelegateTo";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 72: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/FunctionCodegen";
                break;
            }
            case 79: 
            case 109: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadStrategy";
                break;
            }
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMethod";
                break;
            }
            case 87: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iv";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callGenerator";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateTo";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFunction";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationOrigin";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/FunctionCodegen";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "gen";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateOverloadsWithDefaultValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateForDefaultImpl";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodAnnotations";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterAnnotations";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getThisTypeForFunction";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodBody";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "generateLocalVariableTable";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "generateLocalVariablesForParameters";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "joinParameterNames";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "generateFacadeDelegateMethodBody";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateToMethodBody";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateToStaticMethodBody";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "endVisit";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "generateBridges";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isThereOverriddenInKotlinClass";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isMethodOfAny";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 93: {
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultIfNeeded";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultImplBody";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "genDefaultSuperCallCheckIfNeeded";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createFrameMap";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "loadExplicitArgumentsOnStack";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "generateBridge";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "generateTypeCheckBarrierIfNeeded";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "genSamDelegate";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "genDelegate";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "processInterfaceMember";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "processInterface";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getThrownExceptions$3";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateDelegateForDefaultImpl$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 93: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

