/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.utils.StringsKt;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments2) throws InstantiationException, IllegalAccessException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        ArgumentUtils.convertArgumentsToStringList(arguments2, (CommonCompilerArguments)arguments2.getClass().newInstance(), arguments2.getClass(), result2);
        result2.addAll(arguments2.freeArgs);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ArgumentUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments2, @NotNull CommonCompilerArguments defaultArguments, @NotNull Class<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException {
        if (arguments2 == null) {
            ArgumentUtils.$$$reportNull$$$0(2);
        }
        if (defaultArguments == null) {
            ArgumentUtils.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            ArgumentUtils.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            ArgumentUtils.$$$reportNull$$$0(5);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Object defaultValue;
            Object value;
            Argument argument = field.getAnnotation(Argument.class);
            if (argument == null) continue;
            try {
                value = field.get(arguments2);
                defaultValue = field.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (Objects.equals(value, defaultValue)) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.isArray()) {
                Object[] values = (Object[])value;
                if (values.length == 0) continue;
                value = StringsKt.join(Arrays.asList(values), ",");
            }
            result2.add(argument.value());
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            if (ParseCommandLineArgumentsKt.isAdvanced(argument)) {
                result2.set(result2.size() - 1, argument.value() + "=" + value.toString());
                continue;
            }
            result2.add(value.toString());
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToStringList(arguments2, defaultArguments, superClazz, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultArguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/compilerRunner/ArgumentUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertArgumentsToStringList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertArgumentsToStringList";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

