/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsAstUtils {
    private static final JsNameRef DEFINE_PROPERTY = JsAstUtils.pureFqn("defineProperty", null);
    private static final JsNameRef CREATE_OBJECT = JsAstUtils.pureFqn("create", null);
    private static final JsNameRef VALUE = new JsNameRef("value");
    private static final JsPropertyInitializer WRITABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("writable", null), JsLiteral.TRUE);
    private static final JsPropertyInitializer ENUMERABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("enumerable", null), JsLiteral.TRUE);

    private JsAstUtils() {
    }

    @NotNull
    public static JsStatement convertToStatement(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(0);
        }
        assert (jsNode instanceof JsExpression || jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (jsNode instanceof JsExpression) {
            JsExpression expression2 = (JsExpression)jsNode;
            JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
            if (expression2 instanceof JsNullLiteral || MetadataProperties.getSynthetic(expression2)) {
                MetadataProperties.setSynthetic(statement2, true);
            }
            JsExpressionStatement jsExpressionStatement = statement2;
            if (jsExpressionStatement == null) {
                JsAstUtils.$$$reportNull$$$0(1);
            }
            return jsExpressionStatement;
        }
        JsStatement jsStatement = (JsStatement)jsNode;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(2);
        }
        return jsStatement;
    }

    @NotNull
    public static JsBlock convertToBlock(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(3);
        }
        if (jsNode instanceof JsBlock) {
            JsBlock jsBlock = (JsBlock)jsNode;
            if (jsBlock == null) {
                JsAstUtils.$$$reportNull$$$0(4);
            }
            return jsBlock;
        }
        JsBlock block = new JsBlock();
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(5);
        }
        return jsBlock;
    }

    @NotNull
    private static JsStatement deBlockIfPossible(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(6);
        }
        if (statement2 instanceof JsBlock && ((JsBlock)statement2).getStatements().size() == 1) {
            JsStatement jsStatement = ((JsBlock)statement2).getStatements().get(0);
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(7);
            }
            return jsStatement;
        }
        JsStatement jsStatement = statement2;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(8);
        }
        return jsStatement;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(9);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(10);
        }
        elseStatement = elseStatement != null ? JsAstUtils.deBlockIfPossible(elseStatement) : null;
        JsIf jsIf = new JsIf(ifExpression, JsAstUtils.deBlockIfPossible(thenStatement), elseStatement);
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$0(11);
        }
        return jsIf;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(12);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(13);
        }
        JsIf jsIf = JsAstUtils.newJsIf(ifExpression, thenStatement, null);
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$0(14);
        }
        return jsIf;
    }

    @Nullable
    public static JsExpression extractExpressionFromStatement(@Nullable JsStatement statement2) {
        return statement2 instanceof JsExpressionStatement ? ((JsExpressionStatement)statement2).getExpression() : null;
    }

    @NotNull
    public static JsStatement mergeStatementInBlockIfNeeded(@NotNull JsStatement statement2, @NotNull JsBlock block) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(15);
        }
        if (block == null) {
            JsAstUtils.$$$reportNull$$$0(16);
        }
        if (block.isEmpty()) {
            JsStatement jsStatement = statement2;
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(17);
            }
            return jsStatement;
        }
        if (JsAstUtils.isEmptyStatement(statement2)) {
            JsStatement jsStatement = JsAstUtils.deBlockIfPossible(block);
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(18);
            }
            return jsStatement;
        }
        block.getStatements().add(statement2);
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(19);
        }
        return jsBlock;
    }

    public static boolean isEmptyStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(20);
        }
        return statement2 instanceof JsEmpty;
    }

    @NotNull
    public static JsInvocation invokeKotlinFunction(@NotNull String name, JsExpression ... argument) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(21);
        }
        if (argument == null) {
            JsAstUtils.$$$reportNull$$$0(22);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinObject(), name, argument);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(23);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsInvocation invokeMethod(@NotNull JsExpression thisObject, @NotNull String name, JsExpression ... arguments2) {
        if (thisObject == null) {
            JsAstUtils.$$$reportNull$$$0(24);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(25);
        }
        if (arguments2 == null) {
            JsAstUtils.$$$reportNull$$$0(26);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(name, thisObject), arguments2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(27);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toInt32(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(28);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.BIT_OR, expression2, JsNumberLiteral.ZERO);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(29);
        }
        return jsBinaryOperation;
    }

    @Nullable
    public static JsExpression extractToInt32Argument(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(30);
        }
        if (!(expression2 instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expression2;
        if (binary.getOperator() != JsBinaryOperator.BIT_OR) {
            return null;
        }
        if (!(binary.getArg2() instanceof JsNumberLiteral.JsIntLiteral)) {
            return null;
        }
        JsNumberLiteral.JsIntLiteral arg2 = (JsNumberLiteral.JsIntLiteral)binary.getArg2();
        return arg2.value == 0 ? binary.getArg1() : null;
    }

    @NotNull
    public static JsExpression charToInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(31);
        }
        JsExpression jsExpression = JsAstUtils.toInt32(expression2);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(32);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression charToString(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(33);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef("fromCharCode", (JsExpression)new JsNameRef("String")), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(34);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression charToBoxedChar(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(35);
        }
        JsInvocation jsInvocation = JsAstUtils.withBoxingMetadata(JsAstUtils.invokeKotlinFunction("toBoxedChar", JsAstUtils.unnestBoxing(expression2)));
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(36);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression boxedCharToChar(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(37);
        }
        JsInvocation jsInvocation = JsAstUtils.withBoxingMetadata(JsAstUtils.invokeKotlinFunction("unboxChar", JsAstUtils.unnestBoxing(expression2)));
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(38);
        }
        return jsInvocation;
    }

    @NotNull
    private static JsExpression unnestBoxing(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(39);
        }
        if (expression2 instanceof JsInvocation && MetadataProperties.getBoxing((JsInvocation)expression2)) {
            JsExpression jsExpression = ((JsInvocation)expression2).getArguments().get(0);
            if (jsExpression == null) {
                JsAstUtils.$$$reportNull$$$0(40);
            }
            return jsExpression;
        }
        JsExpression jsExpression = expression2;
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(41);
        }
        return jsExpression;
    }

    @NotNull
    private static JsInvocation withBoxingMetadata(@NotNull JsInvocation call2) {
        if (call2 == null) {
            JsAstUtils.$$$reportNull$$$0(42);
        }
        MetadataProperties.setBoxing(call2, true);
        JsInvocation jsInvocation = call2;
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(43);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toShort(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(44);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.SHORT.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(45);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toByte(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(46);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.BYTE.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(47);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toLong(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(48);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.LONG.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(49);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toChar(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(50);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.CHAR.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(51);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression compareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(52);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(53);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorNameConventions.COMPARE_TO.getIdentifier(), left, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(54);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression primitiveCompareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(55);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(56);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("primitiveCompareTo", left, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(57);
        }
        return jsInvocation;
    }

    /*
     * WARNING - void declaration
     */
    public static JsExpression newLong(long value, @NotNull TranslationContext translationContext) {
        void context;
        if (translationContext == null) {
            JsAstUtils.$$$reportNull$$$0(58);
        }
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            int low = (int)value;
            int high = (int)(value >> 32);
            SmartList<JsNumberLiteral> args = new SmartList<JsNumberLiteral>();
            args.add(context.program().getNumberLiteral(low));
            args.add(context.program().getNumberLiteral(high));
            return new JsNew(Namer.kotlinLong(), args);
        }
        if (value == 0L) {
            return new JsNameRef("ZERO", (JsExpression)Namer.kotlinLong());
        }
        if (value == 1L) {
            return new JsNameRef("ONE", (JsExpression)Namer.kotlinLong());
        }
        if (value == -1L) {
            return new JsNameRef("NEG_ONE", (JsExpression)Namer.kotlinLong());
        }
        return JsAstUtils.longFromInt(context.program().getNumberLiteral((int)value));
    }

    @NotNull
    public static JsExpression longFromInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(59);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromInt", expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(60);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression longFromNumber(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(61);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromNumber", expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(62);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression compareForObject(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(63);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(64);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(left, Namer.COMPARE_TO_METHOD_NAME, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(65);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression notOptimized(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(66);
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation unary = (JsUnaryOperation)expression2;
            if (unary.getOperator() == JsUnaryOperator.NOT) {
                JsExpression jsExpression = unary.getArg();
                if (jsExpression == null) {
                    JsAstUtils.$$$reportNull$$$0(67);
                }
                return jsExpression;
            }
        } else if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)expression2;
            switch (binary.getOperator()) {
                case AND: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.or(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(68);
                    }
                    return jsBinaryOperation;
                }
                case OR: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.and(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(69);
                    }
                    return jsBinaryOperation;
                }
                case EQ: {
                    JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.NEQ, binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(70);
                    }
                    return jsBinaryOperation;
                }
                case NEQ: {
                    JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.EQ, binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(71);
                    }
                    return jsBinaryOperation;
                }
                case REF_EQ: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.inequality(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(72);
                    }
                    return jsBinaryOperation;
                }
                case REF_NEQ: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(73);
                    }
                    return jsBinaryOperation;
                }
                case LT: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.greaterThanEq(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(74);
                    }
                    return jsBinaryOperation;
                }
                case LTE: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.greaterThan(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(75);
                    }
                    return jsBinaryOperation;
                }
                case GT: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.lessThanEq(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(76);
                    }
                    return jsBinaryOperation;
                }
                case GTE: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.lessThan(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(77);
                    }
                    return jsBinaryOperation;
                }
            }
        }
        JsPrefixOperation jsPrefixOperation = JsAstUtils.not(expression2);
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$0(78);
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation and(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(79);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(80);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.AND, op1, op2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(81);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation or(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(82);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(83);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(84);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation equality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(87);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(88);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_EQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(89);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation inequality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(90);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(91);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_NEQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(92);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(93);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(94);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LTE, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(95);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(96);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(97);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LT, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(98);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation greaterThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(99);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(100);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.GT, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(101);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation greaterThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(102);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(103);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.GTE, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(104);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation assignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(105);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(106);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(107);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsStatement assignmentToThisField(@NotNull String fieldName, @NotNull JsExpression right) {
        if (fieldName == null) {
            JsAstUtils.$$$reportNull$$$0(108);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(109);
        }
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)JsLiteral.THIS), right).makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(110);
        }
        return jsStatement;
    }

    public static JsStatement asSyntheticStatement(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(111);
        }
        JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
        MetadataProperties.setSynthetic(statement2, true);
        return statement2;
    }

    @Nullable
    public static Pair<JsExpression, JsExpression> decomposeAssignment(@NotNull JsExpression expr) {
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(112);
        }
        if (!(expr instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expr;
        if (binary.getOperator() != JsBinaryOperator.ASG) {
            return null;
        }
        return new Pair<JsExpression, JsExpression>(binary.getArg1(), binary.getArg2());
    }

    @Nullable
    public static Pair<JsName, JsExpression> decomposeAssignmentToVariable(@NotNull JsExpression expr) {
        Pair<JsExpression, JsExpression> assignment;
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(113);
        }
        if ((assignment = JsAstUtils.decomposeAssignment(expr)) == null || !(assignment.getFirst() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef nameRef = (JsNameRef)assignment.getFirst();
        if (nameRef.getName() == null || nameRef.getQualifier() != null) {
            return null;
        }
        return new Pair<JsName, JsExpression>(nameRef.getName(), assignment.getSecond());
    }

    @NotNull
    public static JsBinaryOperation sum(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(114);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(115);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ADD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(116);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation addAssign(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(117);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(118);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG_ADD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(119);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation subtract(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(120);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(121);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.SUB, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(122);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mul(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(123);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(124);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MUL, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(125);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation div(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(126);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(127);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.DIV, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(128);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mod(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(129);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(130);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MOD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(131);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsPrefixOperation not(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(132);
        }
        JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.NOT, expression2);
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$0(133);
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation typeOfIs(@NotNull JsExpression expression2, @NotNull JsStringLiteral string) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(134);
        }
        if (string == null) {
            JsAstUtils.$$$reportNull$$$0(135);
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(new JsPrefixOperation(JsUnaryOperator.TYPEOF, expression2), string);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(136);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsVars newVar(@NotNull JsName name, @Nullable JsExpression expr) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(137);
        }
        JsVars jsVars = new JsVars(new JsVars.JsVar(name, expr));
        if (jsVars == null) {
            JsAstUtils.$$$reportNull$$$0(138);
        }
        return jsVars;
    }

    @NotNull
    public static JsExpression newSequence(@NotNull List<JsExpression> expressions) {
        if (expressions == null) {
            JsAstUtils.$$$reportNull$$$0(139);
        }
        assert (!expressions.isEmpty());
        if (expressions.size() == 1) {
            JsExpression jsExpression = expressions.get(0);
            if (jsExpression == null) {
                JsAstUtils.$$$reportNull$$$0(140);
            }
            return jsExpression;
        }
        JsExpression result2 = expressions.get(expressions.size() - 1);
        for (int i = expressions.size() - 2; i >= 0; --i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, expressions.get(i), result2);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(141);
        }
        return jsExpression;
    }

    @NotNull
    public static JsFunction createFunctionWithEmptyBody(@NotNull JsScope parent2) {
        if (parent2 == null) {
            JsAstUtils.$$$reportNull$$$0(142);
        }
        JsFunction jsFunction = new JsFunction(parent2, new JsBlock(), "<anonymous>");
        if (jsFunction == null) {
            JsAstUtils.$$$reportNull$$$0(143);
        }
        return jsFunction;
    }

    @NotNull
    public static List<JsExpression> toStringLiteralList(@NotNull List<String> strings, @NotNull JsProgram program) {
        if (strings == null) {
            JsAstUtils.$$$reportNull$$$0(144);
        }
        if (program == null) {
            JsAstUtils.$$$reportNull$$$0(145);
        }
        if (strings.isEmpty()) {
            List<JsExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$0(146);
            }
            return list2;
        }
        SmartList<JsExpression> result2 = new SmartList<JsExpression>();
        for (String str : strings) {
            result2.add(program.getStringLiteral(str));
        }
        SmartList<JsExpression> smartList = result2;
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$0(147);
        }
        return smartList;
    }

    @NotNull
    public static JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name, @NotNull JsExpression value, @NotNull JsProgram program) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(148);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(149);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(150);
        }
        if (program == null) {
            JsAstUtils.$$$reportNull$$$0(151);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)DEFINE_PROPERTY.deepCopy(), receiver, program.getStringLiteral(name), value);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(152);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsStatement defineSimpleProperty(@NotNull String name, @NotNull JsExpression value) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(153);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(154);
        }
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(name, (JsExpression)JsLiteral.THIS), value).makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(155);
        }
        return jsStatement;
    }

    @NotNull
    public static JsObjectLiteral createDataDescriptor(@NotNull JsExpression value, boolean writable, boolean enumerable) {
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(156);
        }
        JsObjectLiteral dataDescriptor = new JsObjectLiteral();
        dataDescriptor.getPropertyInitializers().add(new JsPropertyInitializer(VALUE, value));
        if (writable) {
            dataDescriptor.getPropertyInitializers().add(WRITABLE);
        }
        if (enumerable) {
            dataDescriptor.getPropertyInitializers().add(ENUMERABLE);
        }
        JsObjectLiteral jsObjectLiteral = dataDescriptor;
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$0(157);
        }
        return jsObjectLiteral;
    }

    @NotNull
    public static JsObjectLiteral wrapValue(@NotNull JsExpression label, @NotNull JsExpression value) {
        if (label == null) {
            JsAstUtils.$$$reportNull$$$0(158);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(159);
        }
        JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(Collections.singletonList(new JsPropertyInitializer(label, value)));
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$0(160);
        }
        return jsObjectLiteral;
    }

    public static JsExpression replaceRootReference(@NotNull JsNameRef fullQualifier, @NotNull JsExpression newQualifier) {
        if (fullQualifier == null) {
            JsAstUtils.$$$reportNull$$$0(161);
        }
        if (newQualifier == null) {
            JsAstUtils.$$$reportNull$$$0(162);
        }
        if (fullQualifier.getQualifier() == null) {
            assert (Namer.getRootPackageName().equals(fullQualifier.getIdent())) : "Expected root package, but: " + fullQualifier.getIdent();
            return newQualifier;
        }
        JsNameRef qualifier = fullQualifier = fullQualifier.deepCopy();
        while (true) {
            JsExpression parent2 = qualifier.getQualifier();
            assert (parent2 instanceof JsNameRef) : "unexpected qualifier: " + parent2 + ", original: " + fullQualifier;
            if (((JsNameRef)parent2).getQualifier() == null) {
                assert (Namer.getRootPackageName().equals(((JsNameRef)parent2).getIdent()));
                qualifier.setQualifier(newQualifier);
                return fullQualifier;
            }
            qualifier = (JsNameRef)parent2;
        }
    }

    @NotNull
    public static List<JsStatement> flattenStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(163);
        }
        if (statement2 instanceof JsBlock) {
            List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$0(164);
            }
            return list2;
        }
        SmartList<JsStatement> smartList = new SmartList<JsStatement>(statement2);
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$0(165);
        }
        return smartList;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull String identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(166);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(167);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull JsName identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(168);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(169);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation invokeBind(@NotNull JsExpression receiver, @NotNull JsExpression method) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(170);
        }
        if (method == null) {
            JsAstUtils.$$$reportNull$$$0(171);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(method, "bind", receiver);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(172);
        }
        return jsInvocation;
    }

    public static boolean isUndefinedExpression(JsExpression expression2) {
        if (!(expression2 instanceof JsUnaryOperation)) {
            return false;
        }
        JsUnaryOperation unary = (JsUnaryOperation)expression2;
        return unary.getOperator() == JsUnaryOperator.VOID;
    }

    @NotNull
    public static JsExpression defineGetter(@NotNull JsProgram program, @NotNull JsExpression receiver, @NotNull String name, @NotNull JsExpression body) {
        if (program == null) {
            JsAstUtils.$$$reportNull$$$0(173);
        }
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(174);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(175);
        }
        if (body == null) {
            JsAstUtils.$$$reportNull$$$0(176);
        }
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        propertyLiteral.getPropertyInitializers().add(new JsPropertyInitializer(new JsNameRef("get"), body));
        JsInvocation jsInvocation = JsAstUtils.defineProperty(receiver, name, propertyLiteral, program);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(177);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression prototypeOf(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(178);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn("prototype", expression2);
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(179);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression stateMachineReceiver() {
        JsNameRef result2 = new JsNameRef("$this$");
        MetadataProperties.setCoroutineReceiver(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(180);
        }
        return jsNameRef;
    }

    static {
        JsNameRef globalObjectReference = new JsNameRef("Object");
        DEFINE_PROPERTY.setQualifier(globalObjectReference);
        CREATE_OBJECT.setQualifier(globalObjectReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 110: 
            case 116: 
            case 119: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 152: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 165: 
            case 167: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 180: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 110: 
            case 116: 
            case 119: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 152: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 165: 
            case 167: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 180: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsNode";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 110: 
            case 116: 
            case 119: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 152: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 165: 
            case 167: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 6: 
            case 15: 
            case 20: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifExpression";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 21: 
            case 25: 
            case 137: 
            case 149: 
            case 153: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 59: 
            case 61: 
            case 66: 
            case 111: 
            case 132: 
            case 134: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 52: 
            case 55: 
            case 63: 
            case 105: 
            case 114: 
            case 117: 
            case 120: 
            case 123: 
            case 126: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 53: 
            case 56: 
            case 64: 
            case 106: 
            case 109: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op1";
                break;
            }
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op2";
                break;
            }
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 112: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 145: 
            case 151: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "program";
                break;
            }
            case 148: 
            case 170: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 150: 
            case 154: 
            case 156: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQualifier";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQualifier";
                break;
            }
            case 166: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deBlockIfPossible";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newJsIf";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeKotlinFunction";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeMethod";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toInt32";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "charToInt";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "charToString";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "charToBoxedChar";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "boxedCharToChar";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "unnestBoxing";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "withBoxingMetadata";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "toShort";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "toByte";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toLong";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "toChar";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTo";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "primitiveCompareTo";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromInt";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromNumber";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "compareForObject";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "notOptimized";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "equality";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "inequality";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThanEq";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThan";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThan";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThanEq";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "assignment";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentToThisField";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "sum";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "addAssign";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "mul";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "mod";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "typeOfIs";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "newVar";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "newSequence";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionWithEmptyBody";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralList";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "defineProperty";
                break;
            }
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "defineSimpleProperty";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataDescriptor";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapValue";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenStatement";
                break;
            }
            case 167: 
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "pureFqn";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeBind";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "defineGetter";
                break;
            }
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "prototypeOf";
                break;
            }
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "stateMachineReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToStatement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 110: 
            case 116: 
            case 119: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 152: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 165: 
            case 167: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 180: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deBlockIfPossible";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newJsIf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyStatement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invokeKotlinFunction";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toInt32";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractToInt32Argument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "charToInt";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "charToString";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "charToBoxedChar";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "boxedCharToChar";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "unnestBoxing";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "withBoxingMetadata";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "toShort";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "toByte";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "toLong";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toChar";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "primitiveCompareTo";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "newLong";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "longFromInt";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "longFromNumber";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "compareForObject";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "notOptimized";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "setQualifierForNameRef";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "equality";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "inequality";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "lessThanEq";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lessThan";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "greaterThan";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "greaterThanEq";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "assignment";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "assignmentToThisField";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "asSyntheticStatement";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignment";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignmentToVariable";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "sum";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "addAssign";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "mul";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "mod";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "typeOfIs";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "newVar";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "newSequence";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionWithEmptyBody";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralList";
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "defineProperty";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "defineSimpleProperty";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "createDataDescriptor";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "wrapValue";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "replaceRootReference";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "flattenStatement";
                break;
            }
            case 166: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "pureFqn";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "invokeBind";
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "defineGetter";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "prototypeOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 84: 
            case 89: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 107: 
            case 110: 
            case 116: 
            case 119: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 136: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 152: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 165: 
            case 167: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 180: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

